CHANGELOG for 5.4.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.4 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.4.0...v5.4.1

* 5.4.27 (2023-07-31)

 * bug #51178 [Finder] Revert "Fix children condition in ExcludeDirectoryFilterIterator" (derrabus)

* 5.4.26 (2023-07-29)

 * bug #50933 [Serializer] Fix deserializing nested arrays of objects with mixed keys (HypeMC)
 * bug #51078 [FrameworkBundle][Workflow] Throw exception is workflow.xxx.transitions is not an array (lyrixx)
 * bug #51114 [Serializer] Fix denormalizing abstract part headers in MimeMessageNormalizer (fancyweb)
 * bug #50788 [Validator] Fix regression with class metadatada on parent classes (rmikalkenas)
 * bug #51017 [VarExporter] Fix exporting classes with __serialize() but not __unserialize() (fancyweb)
 * bug #51031 Fix deprecations on PHP 8.3 (nicolas-grekas)
 * bug #51000 [WebProfilerBundle] Fix error in case of 'Content-Type' set null in dev environment with no debug (alexbuyanow)
 * bug #50994 [ErrorHandler][Runtime] Don't mess with ini_set('assert.warning') (nicolas-grekas)
 * bug #50968 [PropertyAccess] Fix access to undefined "file" key when checking stack frames (nicolas-grekas)
 * bug #50552 [Security] Allow custom scheme to be used as redirection URIs (Spomky)
 * bug #50945 [DebugBundle][FrameworkBundle] Fix using the framework without the Console component (HypeMC)
 * bug #50913 [HttpKernel][WebProfilerBundle] Fix search feature (Cyril HERRERA)
 * bug #50937 [Form] fetch all known ChoiceType values at once (xabbuh)
 * bug #50944 [FrameworkBundle] Add missing monolog channel tag to the `messenger:failed:retry` command (HypeMC)
 * bug #49070 [RateLimiter] fix incorrect retryAfter of FixedWindow (RobertMe)
 * bug #50960 [VarDumper] Fix dumping `ArrayObject` with `DumpDataCollector` (lyrixx, HypeMC)
 * bug #50943 [Intl] Taking into account bibliographic + overlong (oleg-andreyev)
 * bug #50954 [PhpUnitBridge] Kill the last concurrent process when it stales for more than 60s (nicolas-grekas)
 * bug #50475 [FrameworkBundle] Prevent `cache:clear` to lose files on subsequent runs (Okhoshi)
 * bug #47252 [PhpUnitBridge] Use triggering class to generate baseline for deprecation messages from DebugClassLoader (leongersen)
 * bug #50582 [Security/Http] Fix false-string handling in `RememberMeAuthenticator` (ossinkine)
 * bug #50595 [DependencyInjection] Don't ignore attributes on the actual decorator (HypeMC)
 * bug #50804 [Serializer] Fix Normalizer not utilizing converted name for index variadic param (DidierLmn)
 * bug #50813 [DoctrineBridge] Load refreshed user proxy (MatTheCat)
 * bug #50905 [DepdencyInjection] Fix costly logic when checking errored definitions (nicolas-grekas)
 * bug #50884 [Finder] Fix initial directory is opened twice (mvorisek)
 * bug #50881 [Messenger] Fix passing options set via tags to handler descriptors (nicolas-grekas)
 * bug #50837 [DependencyInjection] Fix autocasting null env values to empty string (fancyweb)
 * bug #50810 [String] Fix Inflector for 'status' (evertharmeling)

* 5.4.25 (2023-06-26)

 * bug #50763 [DependencyInjection] Skip errored definitions deep-referenced as runtime exceptions (nicolas-grekas)
 * bug #50728 [HttpClient] Explicitly exclude CURLOPT_POSTREDIR (nicolas-grekas)
 * bug #50671 [HttpClient] Fix encoding some characters in query strings (Daniel Kozák)
 * bug #50655 Revert "Respect isRetryable decision of the retry strategy for re-delivery" (bendavies)
 * bug #50665 [FrameworkBundle] Ignore missing directories in about command (ro0NL)
 * bug #50644 [VarDumper] Dumping DateTime throws error if getTimezone is false (bogdanmoza)
 * bug #50656 Only update autoload_runtime.php when it changed (Seldaek)
 * bug #50698 [HttpClient] Fix int conversion for `GenericRetryStrategy` with floated multiplier  (francisbesset)
 * bug #50548 [FrameworkBundle] Show non-bundle extensions in `debug:config` & `config:dump` list view & completion (HypeMC)
 * bug #50585 [Cache] Fix RedisTrait::createConnection for cluster (darkanakin41)
 * bug #50546 [FrameworkBundle] Fix `debug:config` & `config:dump` in debug mode (HypeMC)
 * bug #50560 [DependencyInjection] Support PHP 8.2 `true` and `null` type (ruudk)
 * bug #50562 [Lock] Fix sprintf (fancyweb)
 * bug #50524 Fix Doctrine deprecations (nicolas-grekas)
 * bug #50539 [Validator] Remove internal from methods on non-internal interfaces (wouterj)
 * bug #50534 [PhpUnitBridge] Fix support for the NO_COLOR env var (nicolas-grekas)
 * bug #50517 [DependencyInjection] Fix casting scalar env vars from null (fancyweb)
 * bug #50507 [Cache] Fix DBAL deprecations (MatTheCat)
 * bug #50501 [Serializer] Fix discriminator map not working with `AbstractNormalizer::OBJECT_TO_POPULATE` (HypeMC)
 * bug #50437 [Filesystem] Follow symlinks when dumping files (ausi)
 * bug #50478 [DependencyInjection] Escape `` from parameter-like default values (MatTheCat)

* 5.4.24 (2023-05-27)

 * bug #50429 [Console] block input stream if needed (joelwurtz)
 * bug #50315 [Translation] Fix handling of null messages in `ArrayLoader` (rob006)
 * bug #50338 [Console] Remove ``exec`` and replace it by ``shell_exec`` (maxbeckers)
 * bug #50362 [FrameworkBundle] Fix Workflow without a marking store definition uses marking store definition of previously defined workflow (krciga22)
 * bug #50309 [HttpFoundation] UrlHelper is now aware of RequestContext changes (giosh94mhz)
 * bug #50309 [HttpFoundation] UrlHelper is now aware of RequestContext changes (giosh94mhz)
 * bug #50354 [Process] Stop the process correctly even if underlying input stream is not closed (joelwurtz)
 * bug #50332 [PropertyInfo] Fix `PhpStanExtractor` when constructor has no docblock (HypeMC)
 * bug #50253 [FrameworkBundle] Generate caches consistently on successive run of `cache:clear` command (Okhoshi)
 * bug #49063 [Messenger] Respect `isRetryable` decision of the retry strategy for re-delivery (FlyingDR)
 * bug #50251 [Serializer] Handle datetime deserialization in U format (tugmaks)
 * bug #50266 [HttpFoundation] Fix file streaming after connection aborted (rlshukhov)
 * bug #50269 Fix param type annotation (l-vo)
 * bug #50256 [HttpClient] Fix setting duplicate-name headers when redirecting with AmpHttpClient (nicolas-grekas)
 * bug #50214 [WebProfilerBundle] Remove legacy filters remnants (MatTheCat)
 * bug #50235 [HttpClient] Fix getting through proxies via CONNECT (nicolas-grekas)
 * bug #50244 [HttpKernel] Fix restoring surrogate content from cache (nicolas-grekas)
 * bug #50246 [DependencyInjection] Do not check errored definitions’ type (MatTheCat)
 * bug #49557 [PropertyInfo] Fix phpDocExtractor nullable array value type (fabpot)
 * bug #50213 [ErrorHandler] Prevent conflicts with WebProfilerBundle’s JavaScript (MatTheCat)
 * bug #50192 [Serializer] backed enum throw notNormalizableValueException outside construct method (alli83)
 * bug #50238 [HttpKernel] Don't use eval() to render ESI/SSI (nicolas-grekas)
 * bug #50226 [HttpClient] Ensure HttplugClient ignores invalid HTTP headers (nicolas-grekas)
 * bug #50203 [Messenger] Fix registering message handlers (nicolas-grekas)
 * bug #50204 [ErrorHandler] Skip Httplug deprecations for HttplugClient (nicolas-grekas)

* 5.4.23 (2023-04-28)

 * bug #50143 [Console] trim(): Argument #1 () must be of type string, bool given (danepowell)
 * bug #50066 [Dumper] Trim leading newlines when checking if value begins with a space (bradtreloar)
 * bug #50111 Fix the list of supported shells for completions in a phar (stof)
 * bug #50074 [Cache] Send Predis SSL options in the $hosts parameter (magnusnordlander)
 * bug #50099 [Cache] Fix success interpretation when pruning cache (staabm)
 * bug #50092 [Security] Fix return type of AuthenticationSuccessHandlerInterface::onAuthenticationSuccess() (nicolas-grekas)
 * bug #50072 [HttpClient] Fix global state preventing two CurlHttpClient instances from working together (nicolas-grekas)
 * bug #50017 [Validator] Fix support of Enum to `ConstraintValidator::formatValue` (PhoneixS)
 * bug #49356 [Process] Path resolution changes for PHP in the cgi-fcgi mode (isdn)
 * bug #48886 [Console] Fix computing column width containing multibyte chars (cay89)
 * bug #50049 [Messenger] Fix deprecation layer of RedeliveryStamp (nicolas-grekas)
 * bug #47505 [Mime] Form field values with integer keys not resolved correctly  (claudiu-cristea)
 * bug #50048 [PhpUnitBridge] Fix PHPUnit 10.1 compatibility (enumag)
 * bug #50047 [VarDumper] Make the server TCP connection sync (ogizanagi)
 * bug #48837 [Messenger] [Redis] Fixed problem where worker stops handling messages on first empty message (jvmanji)
 * bug #49317 [Messenger] Fix warning message on failed messenger show command (gstapinato)
 * bug #49992 [Mailer] [Mailjet] Use body MessageID instead of X-MJ-Request-GUID (Starfox64)
 * bug #48972 [HttpFoundation] Fix memory limit problems in BinaryFileResponse (glady)
 * bug #48108 [PropertyAccess] Readonly properties must have no PropertyWriteInfo (CasvanDongen)
 * bug #49009 [Form] Cast choices value callback result to string (Matth--)
 * bug #49537 [Serializer] Unexpected value should throw UnexpectedValueException (ThomasTr)
 * bug #49581 Avoid leading .. for temporary files from Filesystem recursive remove (giosh94mhz)
 * bug #50036 [ErrorHandler] Don't throw deprecations for HttplugClient (nicolas-grekas)
 * bug #50024 [Serializer] Fix denormalization of object with typed constructor arg (not castable) and with COLLECT_DENORMALIZATION_ERRORS (lyrixx)
 * bug #50004 [HttpClient] fix proxied redirects in curl client (matthi4s)
 * bug #50008 [Intl] Update the ICU data to 73.1 (jderusse)
 * bug #49987 [Console] Restoring the ability to output unicode text to the Win10 console (aleksandr-shevchenko)
 * bug #49957 [ErrorHandler] Fix sending `Vary` header with `SerializerErrorRenderer` (nicolas-grekas)
 * bug #49983 [DomCrawler] Avoid passing null to substr/strrpos methods (VincentLanglet)
 * bug #49079 [DoctrineBridge] fix issue with missing stopwatch events (dmaicher)
 * bug #49926 [HttpClient] Fix canceling MockResponse (fancyweb)

* 5.4.22 (2023-03-31)

 * bug #49618 [Serializer] Preserve array keys while denormalize variadic parameters (melya)
 * bug #49401 [TwigBridge] Fix raw content rendering in HTML notification emails (1ed)
 * bug #49679 [FrameworkBundle] enable metadata cache when annotation is disabled (bastnic)
 * bug #49796 [HttpClient] Fix not calling the on progress callback when canceling a MockResponse (fancyweb)
 * bug #49833 [Translation] TranslatorBag::diff now iterates over catalogue domains instead of operation domains (welcoMattic)
 * bug #49848 [Cache] Fix storing binary keys when using pgsql (nicolas-grekas)
 * bug #49843 [FrameworkBundle] Add missing monolog channel tag for messenger services (rmikalkenas)
 * bug #49745 [FrameworkBundle] Fix wiring session.handler when handler_id is null (nicolas-grekas)
 * bug #49189 [FrameworkBundle] Improve documentation about translation:extract --sort option (marien-probesys)
 * bug #49274 [VarDumper] Disable links for IntelliJ platform (SerafimArts)
 * bug #49682 [FrameworkBundle] Workflow - Fix LogicException about a wrong configuration of "enabled" node (adpauly)
 * bug #49758 [HttpFoundation] Use separate caches for IpUtils checkIp4 and checkIp6 (danielburger1337)
 * bug #49722 [HttpClient] Encode and decode curly brackets {} (pbowyer)
 * bug #49720 [Serializer] GetSetMethodNormalizer::supportss should not check ignored methods (nikophil)
 * bug #49681 [String] Correct inflection of 'codes' and 'names' (GwendolenLynch)
 * bug #49697 [Validator] Update BIC validator IBAN mappings (maxbeckers)
 * bug #49706 Stop stopwatch events in case of exception (MatTheCat)
 * bug #49657 [HttpKernel] Change limit argument from string to integer for Profiler (Aliance)
 * bug #49674 [FrameworkBundle] Rename limiter’s `strategy` to `policy` in XSD (MatTheCat)
 * bug #49673 [VarDumper] Fixed dumping of CutStub (lyrixx)
 * bug #49604 [Mailer] STDOUT blocks infinitely under Windows when STDERR is filled (TemaYud)
 * bug #49651 [DependencyInjection] Fix support binary values in parameters. (vtsykun)
 * bug #49580 [HttpClient] Fix encoding "+" in URLs (nicolas-grekas)
 * bug #49541 [Security] Remove ``@internal`` tag on `TraceableAuthenticator::getAuthenticator()` (florentdestremau)
 * bug #49578 [DependencyInjection] Fix dumping array of enums parameters (fancyweb)

* 5.4.21 (2023-02-28)

 * bug #49526 [Security] Migrate the session on login only when the user changes (nicolas-grekas)
 * bug #49516 [Workflow] display label with new lines + colours properly when rendering a PUML dump (alexislefebvre)
 * bug #48965 [TwigBridge] Allow floats in html5 input type number field (wimhendrikx)
 * bug #48833 [Translation] Handle the translation of empty strings (javiereguiluz)
 * bug #49292 [VarDumper] Fix error when reflected class has default Enum parameter in constructor (kapiwko)
 * bug #49493 [FrameworkBundle] Fix denyAccessUnlessGranted for mixed attributes (delbertooo)
 * bug #49484 [Validator] Fix translation of AtLeastOneOf constraint message (alexandre-daubois)
 * bug #48998 [Validator] Sync IBAN formats with Swift IBAN registry (smelesh)
 * bug #49405 [MonologBridge] FirePHPHandler::onKernelResponse throws PHP 8.1 deprecation when no user agent is set (juagarc4)
 * bug #49421 [TwigBridge] do not drop embed label classes (xabbuh)
 * bug #49422 [Cache][Messenger] fixed CallbackInterface support in async expiration handler (AdamKatzDev)
 * bug #49441 [Contracts] Fix setting $container before calling parent::setContainer in ServiceSubscriberTrait (edsrzf)
 * bug #49272 [Workflow] remove new lines from workflow metadata (alexislefebvre)
 * bug #49427 [WebProfilerBundle] Render original (not encoded) email headers (1ed)
 * bug #49368 [BC Break] Make data providers for abstract test cases static (OskarStark, alexandre-daubois)
 * bug #49385 [Notifier] Make `TransportTestCase` data providers static (alexandre-daubois)
 * bug #49395 fix trying to load Memcached before checking we can (nicolas-grekas)
 * bug #49326 [Notifier] Fix notifier profiler when transport name is null (fabpot)
 * bug #49265 [HttpKernel] Fix setting the session on the main request when it's started by a subrequest (nicolas-grekas)
 * bug #49353 [Cache] Only validate dbindex parameter when applicable (loevgaard)
 * bug #49346 [ErrorHandler] Do not patch return statements in closures (wouterj)
 * bug #49334 [DependencyInjection] keep `proxy` tag on original definition when decorating (kbond)
 * bug #47946 [FrameworkBundle] Fix checkboxes check assertions (MatTheCat)
 * bug #49301 [HttpClient] Fix data collector (fancyweb)
 * bug #49310 [Notifier][WebProfilerBundle] Ignore messages whose `getNotification` returns `null` (MatTheCat)
 * bug #49299 [HttpClient] Fix over-encoding of URL parts to match browser's behavior (nicolas-grekas)
 * bug #49214 [Mailer] add Sender to the list of bypassed headers (xabbuh)
 * bug #49245 [Serializer] Fix CsvEncoder decode on empty data (cazak)
 * bug #49249 [Dotenv] Fix phpdoc Dotenv (alamirault)
 * bug #49248 [Config] Fix phpdoc nullable (alamirault)
 * bug #48880 [Response] `getMaxAge()` returns non-negative integer (pkruithof, fabpot)
 * bug #49207 [PropertyInfo] Add meaningful message when `phpstan/phpdoc-parser` is not installed when using `PhpStanExtractor` (alexandre-daubois)
 * bug #49220 [Validator] Make ConstraintValidatorTestCase compatible with PHPUnit 10 (gjuric)
 * bug #49226 [WebProfilerBundle] Disable Turbo for debug toolbar links (javiereguiluz)
 * bug #49223 [WebProfilerBundle] Fix some minor HTML issues (javiereguiluz)
 * bug #49146 [PropertyInfo] fail with a meaningful error when a needed package is missing (xabbuh)
 * bug #49187 [Ldap] Allow multiple values on `extra_fields` (mvhirsch)
 * bug #49128 [DependencyInjection] Fix combinatory explosion when autowiring union and intersection types (nicolas-grekas)

* 5.4.20 (2023-02-01)

 * bug #49141 [HttpFoundation] Fix bad return type in IpUtils::checkIp4() (tristankretzer)
 * bug #49126 [DependencyInjection] Fix order of arguments when mixing positional and named ones (nicolas-grekas)
 * bug #49104 [HttpClient] Fix collecting data non-late for the profiler (nicolas-grekas)
 * bug #49103 [Security/Http] Fix compat of persistent remember-me with legacy tokens (nicolas-grekas)
 * security #cve-2022-24895 [Security/Http] Remove CSRF tokens from storage on successful login (nicolas-grekas)
 * security #cve-2022-24894 [HttpKernel] Remove private headers before storing responses with HttpCache (nicolas-grekas)

* 5.4.19 (2023-01-24)

 * bug #49078 [Security/Http] Check tokens before loading users from providers (nicolas-grekas)
 * bug #49077 [DependencyInjection] Fix named arguments when using ContainerBuilder before compilation (nicolas-grekas)
 * bug #49031 [Cache] fix collecting cache stats when nesting computations (nicolas-grekas)
 * bug #49046 Fix for Windows when projects are deployed on junctions/symlinks (nerdgod)
 * bug #49025 [Notifier] [OvhCloud] handle invalid receiver (seferov)
 * bug #48993 [VarDumper] Fix JS to expand / collapse (nicolas-grekas)
 * bug #48983 Fix BC user_identifier support after deprecation username (vtsykun)
 * bug #48986 [Validator] Fix Email validator logic (fabpot)
 * bug #48969 [PropertyInfo] Fixes constructor extractor for mixed type (michael.kubovic)
 * bug #48978 [Serializer] use method_exists() instead of catching reflection exceptions (xabbuh)
 * bug #48937 [SecurityBundle] Fix using same handler for multiple authenticators (RobertMe)
 * bug #48971 [DependencyInjection] Fix dump order of inlined deps (nicolas-grekas)
 * bug #48966 [HttpClient] Let curl handle content-length headers (nicolas-grekas)
 * bug #48968 [VarExporter] Fix exporting enums (nicolas-grekas)
 * bug #48926 [DependencyInjection] Fix support for named arguments on non-autowired services (nicolas-grekas)
 * bug #48943 [FrameworkBundle] Fix deprecation when accessing a "container.private" service from the test container (nicolas-grekas)
 * bug #48931 [DependencyInjection] Fix dumping inlined withers (nicolas-grekas)
 * bug #48898 [HttpClient] Move Http clients data collecting at a late level (pforesi)
 * bug #48896 [DoctrineBridge] Fix detecting mapping with one line annotations (franmomu)
 * bug #48916 [FrameworkBundle] restore call to addGlobalIgnoredName (alexislefebvre)
 * bug #48917 [Config] Fix XML dump when node example is an array (alexandre-daubois)
 * bug #48904 [Validator] Allow egulias/email-validator v4 (chalasr)
 * bug #48831 [Uid] Fix validating nil and max uuid (fancyweb)

* 5.4.18 (2022-12-29)

 * bug #48823 [Cache] Fix possibly null value passed to preg_match() in RedisTrait (chalasr)
 * bug #48816 [Cache] Fix for RedisAdapter without auth parameter (rikvdh)

* 5.4.17 (2022-12-28)

 * bug #48787 [PhpUnitBridge] Use verbose deprecation output for quiet types only when it reaches the threshold (ogizanagi)
 * bug #48784 [Console] Correctly overwrite progressbars with different line count per step (ncharalampidis)
 * bug #48801 [Form] Make `ButtonType` handle `form_attr` option (MatTheCat)
 * bug #48791 [DependencyInjection] Fix deduplicating service instances in circular graphs (nicolas-grekas)
 * bug #48771 [CssSelector] Fix escape patterns (fancyweb)
 * bug #48711 [Cache] RedisTrait::createConnection does not pass auth value from redis sentinel cluster DSN (evgkord)
 * bug #48724 [VarExporter] Fix exporting classes with __unserialize() but not __serialize() (fancyweb)
 * bug #48746 [Validator] Fix IBAN format for Tunisia and Mauritania (smelesh)
 * bug #48738 [Workflow] Allow spaces in place names so the PUML dump doesn't break (Kamil Musial)
 * bug #48718 Compatibility with doctrine/annotations 2 (derrabus)
 * bug #48651 [HttpKernel] AbstractSessionListener should not override the cache lifetime for private responses (rodmen)
 * bug #48591 [DependencyInjection] Shared private services becomes public after a public service is accessed (alexpott)
 * bug #48126 [Mailer] Include all transports' debug messages in RoundRobin transport exception  (mixdf)
 * bug #48635 [HttpFoundation] Use relative timestamps with MemcachedSessionHandler (tvlooy)
 * bug #47979 [Cache] Fix dealing with ext-redis' multi/exec returning a bool (João Nogueira)
 * bug #48612 [Messenger] [Amqp] Added missing rpc_timeout option (lyrixx)
 * bug #48233 [Serializer] Prevent `GetSetMethodNormalizer` from creating invalid magic method call (klaussilveira)
 * bug #48628 [HttpFoundation] Fix dumping array cookies (nicolas-grekas)
 * bug #48048 [WebProfilerBundle] Fix dump header not being displayed (HypeMC)
 * bug #47836 [HttpClient] TraceableHttpClient: increase decorator's priority (adpeyre)
 * bug #48259 [FrameworkBundle] Allow configuring `framework.exceptions` with a config builder (MatTheCat)
 * bug #48314 [Mime] Fix MessagePart serialization (Amunak)
 * bug #48331 [Yaml] fix dumping top-level tagged values (xabbuh)
 * bug #48615 Fix getting the name of closures on PHP 8.1.11+ (nicolas-grekas)
 * bug #48618 [ErrorHandler] [DebugClassLoader] Fix some new return types support (fancyweb)
 * bug #48421 [HttpFoundation] IPv4-mapped IPv6 addresses incorrectly rejected (bonroyage)
 * bug #48501 [RateLimiter] Add `int` to `Reservation::wait()` (DaRealFreak)
 * bug #48359 [VarDumper] Ignore \Error in __debugInfo() (fancyweb)
 * bug #48482 [DependencyInjection] Revert "bug #48027 Don't autoconfigure tag when it's already set with attributes" (nicolas-grekas)
 * bug #48335 [TwigBridge] Amend `MoneyType` twig to include a space (mogilvie)
 * bug #48046 [WebProfilerBundle] Remove redundant code from logger template (HypeMC)
 * bug #48292 [Security] [LoginLink] Throw InvalidLoginLinkException on missing parameter (MatTheCat)

* 5.4.16 (2022-11-28)

 * bug #48333 [Yaml] parse unquoted digits in tag values as integers (xabbuh)
 * bug #48330 [FrameworkBundle] do not wire the MercureTransportFactory if the MercureBundle is not enabled (xabbuh)
 * bug #48262 [Notifier] [SMSBiuras] `true`/`false` mismatch for `test_mode` option (StaffNowa)
 * bug #48273 [HttpKernel] Fix message for unresovable arguments of invokable controllers (fancyweb)
 * bug #48251 [PropertyInfo] ignore const expressions read by phpdocumentor (xabbuh)
 * bug #48224 [DependencyInjection] Process bindings in `ServiceLocatorTagPass` (MatTheCat)
 * bug #48179 [Console] Support completion for bash functions (Chi-teck)
 * bug #48217 [Console] Improve error message when shell is not detected in completion command (GromNaN)
 * bug #48222 [Translation] [Lokalize] Configure `replace_breaks` to prevent issues with multilines translations (Kocal)
 * bug #48210 [Console]  Fix signal handlers called after event listeners and skip exit (GromNaN)
 * bug #48198 [Messenger] Fix time-limit check exception (alamirault)
 * bug #48122 [PhpUnitBridge] Fix language deprecations incorrectly marked as direct (wouterj)
 * bug #47998 [Console] Fix console `ProgressBar::override()` after manual `ProgressBar::cleanup()` (maxbeckers)
 * bug #48173 [HttpClient] Handle Amp HTTP client v5 incompatibility gracefully (fancyweb)
 * bug #48172 [HttpKernel] Don’t try to wire Response argument with controller.service_arguments (MatTheCat)
 * bug #48085 [Messenger] Tell about messenger:consume invalid limit options (MatTheCat)
 * bug #48120 [Messenger] Do not throw 'no handlers' exception when skipping handlers due to duplicate handling (wouterj)
 * bug #48112 [HttpFoundation] Compare cookie with null value as empty string in ResponseCookieValueSame (fancyweb)
 * bug #48119 [FrameworkBundle][Lock] Allow to disable lock without defining a resource (MatTheCat)
 * bug #48093 [DependencyInjection] don't move locator tag for service subscriber (RobertMe)
 * bug #48075 [Mailer] Stream timeout not detected fgets returns false (Sezil)
 * bug #48092 Fix the notification email theme for asynchronously dispatched emails (krisbuist)
 * bug #48097 Fix search scope when performing fallback mapping driver detection (spideyfusion)
 * bug #48103 [HttpClient] Do not set http_version instead of setting it to null (Tetragramat)
 * bug #48027 [DependencyInjection] Don't autoconfigure tag when it's already set with attributes (nicolas-grekas)
 * bug #48050 [HttpFoundation] Check IPv6 is valid before comparing it (PhilETaylor)

* 5.4.15 (2022-10-28)

 * bug #47990 [HttpClient] Fix retrying requests when the content is used by the strategy (nicolas-grekas)
 * bug #48005 [ErrorHandler] s/</br>/<br> (PhilETaylor)
 * bug #47907 [Console] Update Application.php (aleksandr-shevchenko)
 * bug #47955 [Security][Serializer] Add missing args to trigger_deprecation (alamirault)
 * bug #47932 Throw LogicException instead of Error when trying to generate logout-… (addiks)
 * bug #47918 [Intl] Update the ICU data to 72.1 - 5.4 (jderusse)
 * bug #47857 [HttpKernel] Fix empty request stack when terminating with exception (krzyc)
 * bug #47879 [HttpClient] Fix buffering after calling AsyncContext::passthru() (nicolas-grekas, lubo13)
 * bug #47878 [HttpKernel] Remove EOL when using error_log() in HttpKernel Logger (cyve)
 * bug #47883 [Console] Fix error output on windows cli (Maximilian.Beckers)
 * bug #47884 [Cache] Reserve numeric keys when doing memory leak prevention (simoheinonen)
 * bug #47831 [Messenger] Fix amqp socket lost (GurvanVgx)
 * bug #47855 [Routing] TypeError in Router when using UrlGenerator (Maximilian.Beckers)
 * bug #47822 [Mailer] fix: use message object from event (rogamoore)
 * bug #47858 [DoctrineBridge] Implement `EventManager::getAllListeners()` (derrabus)

* 5.4.14 (2022-10-12)

 * bug #47621 [Serializer] Allow getting discriminated type by class name (TamasSzigeti)
 * bug #47833 [TwigBridge] Remove empty spaces between choices when using checkbox-inline or checkbox-switch (simondaigre)
 * bug #47808 [HttpClient] Fix seeking in not-yet-initialized requests (nicolas-grekas)
 * bug #47798 [DoctrineBridge] Fix auto mapping for bundles that contain only embeddables (jorissae)
 * bug #47702 [Messenger] Fix default serializer not handling DateTime objects properly (barton-webwings)
 * bug #47779 [Console] Fix `Helper::removeDecoration` hyperlink bug (greew)
 * bug #47753 [Mime] sync message serializer code for forward-compatibility (xabbuh)
 * bug #47763 [PropertyInfo] a readonly property must not be reported as being writable (xabbuh)
 * bug #47731 [WebProfiler] Fix overflow issue in Forms panel (zolikonta)
 * bug #46956 [FrameworkBundle] Allow to specify `null` for exception mapping configuration values (andrew-demb)
 * bug #47746 [HttpFoundation] Fix BinaryFileResponse content type detection logic (X-Coder264)
 * bug #47626 [Notifier] [Expo] Throw exception on error-response from expo api (sdrewergutland)

* 5.4.13 (2022-09-30)

 * bug #47317 [Security] Fix login url matching when app is not run with url rewriting or from a sub folder (sgehrig)
 * bug #47637 [FrameworkBundle] Fix passing `serializer.default_context` option to normalizers (wuchen90)
 * bug #47695 [FrameworkBundle] Filter out trans paths that are covered by a parent folder path (natewiebe13)
 * bug #45554 [Serializer] Fixed framework.serializer.default_context is not working for JsonEncoder (siganushka)
 * bug #47547 [Ldap] Do not run ldap_set_option on failed connection (tatankat)
 * bug #47578 [Security] Fix AbstractFormLoginAuthenticator return types (AndrolGenhald)
 * bug #47614 [FrameworkBundle] Fix a phpdoc in mailer assertions (HeahDude)
 * bug #47516 [HttpFoundation] Prevent BinaryFileResponse::prepare from adding content type if no content is sent (naitsirch)
 * bug #47533 [Messenger] decode URL-encoded characters in DSN's usernames/passwords (xabbuh)
 * bug #47530 [HttpFoundation] Always return strings from accept headers (ausi)
 * bug #47523 [Uid] Ensure ULIDs are monotonic even when the time goes backward (nicolas-grekas)
 * bug #47528 [Form] fix UUID tranformer (nicolas-grekas)
 * bug #47488 [Security] Fix valid remember-me token exposure to the second consequent request (Ivan Kurnosov)
 * bug #47518 [Uid] Fix validating UUID variant bits (nicolas-grekas)
 * bug #47441 [HttpClient] [HttpClientBundle] Bugfix for delayed retryableHttpClient (martkop26)
 * bug #47499 [Uid][Validator] Stop to first ULID format violation (ogizanagi)
 * bug #47491 [HttpKernel] Prevent exception in RequestDataCollector if request stack is empty (aschempp)
 * bug #47497 [Bridge] Fix mkdir() race condition in ProxyCacheWarmer (andrey-tech)
 * bug #47415 [HttpClient] Psr18Client ignore invalid HTTP headers (nuryagdym)
 * bug #47394 [Console] [Completion] Make bash completion run in non interactive mode (Seldaek)
 * bug #47455 [Mime] Fix TextPart broken after being serialized (fabpot)
 * bug #47423 [String] CamelCase/SnakeCase on uppercase word (mpiot)
 * bug #47435 [HttpKernel] lock when writting profiles (nicolas-grekas)
 * bug #47417 [WebProfilerBundle] Fix profile search bar link query params (HeahDude)
 * bug #47437 [Mime] Fix email rendering when having inlined parts that are not related to the content (fabpot)
 * bug #47434 [HttpFoundation] move flushing outside of Response::closeOutputBuffers (nicolas-grekas)
 * bug #47351 [FrameworkBundle] Do not throw when describing a factory definition (MatTheCat)
 * bug #47403 [Mailer] Fix edge cases in STMP transports (fabpot)

* 5.4.12 (2022-08-26)

 * bug #47391 [LokaliseBridge] Fix push command --delete-missing options when there are no missing messages (rwionczek)
 * bug #47368 [Security] Count remember me cookie parts before accessing the second (MatTheCat)
 * bug #47358 Fix broken request stack state if throwable is thrown. (Warxcell)
 * bug #47304 [Serializer] Fix caching context-aware encoders/decoders in ChainEncoder/ChainDecoder (Guite)
 * bug #47329 Email image parts: regex for single closing quote (rr-it)
 * bug #47283 [HttpFoundation] Prevent accepted rate limits with no remaining token to be preferred over denied ones (MatTheCat)
 * bug #47128 [Serializer] Throw InvalidArgumentException if the data needed in the constructor doesn't belong to a backedEnum  (allison guilhem)
 * bug #47273 [HttpFoundation] Do not send Set-Cookie header twice for deleted session cookie (X-Coder264)
 * bug #47255 [Serializer] Fix get accessor regex in AnnotationLoader (jsor)
 * bug #47238 [HttpKernel] Fix passing `null` to `\trim()` method in LoggerDataCollector (SVillette)
 * bug #47216 [Translation] Crowdin provider throw Exception when status is 50x (alamirault)
 * bug #47209 Always attempt to listen for notifications (goetas)
 * bug #47211 [Validator] validate nested constraints only if they are in the same group (xabbuh)
 * bug #47218 [Console] fix dispatch signal event check for compatibility with the contract interface (xabbuh)
 * bug #47200 [Form] ignore missing keys when mapping DateTime objects to uninitialized arrays (xabbuh)
 * bug #47189 [Validator] Add additional hint when `egulias/email-validator` needs to be installed (mpdude)
 * bug #47195 [FrameworkBundle] fix writes to static $kernel property (xabbuh)
 * bug #47185 [String] Fix snake conversion (simPod)
 * bug #47175 [DowCrawler] Fix locale-sensitivity of whitespace normalization (nicolas-grekas)
 * bug #47171 [TwigBridge] suggest to install the Twig bundle when the required component is already installed (xabbuh)
 * bug #47169 [Serializer] Fix throwing right exception in ArrayDenormalizer with invalid type (norkunas)
 * bug #47161 [Mailer] Fix logic (fabpot)
 * bug #47157 [Messenger] Fix Doctrine transport on MySQL (nicolas-grekas)
 * bug #47155 [Filesystem] Remove needless `mb_*` calls (HellFirePvP)
 * bug #46190 [Translation] Fix translator overlapse (Xavier RENAUDIN)
 * bug #47142 [Mailer] Fix error message in case of an STMP error (fabpot)
 * bug #45333 [Console] Fix ConsoleEvents::SIGNAL subscriber dispatch (GwendolenLynch)
 * bug #47145 [HttpClient] Fix shared connections not being freed on PHP < 8 (nicolas-grekas)
 * bug #47143 [HttpClient] Fix memory leak when using StreamWrapper (nicolas-grekas)
 * bug #47130 [HttpFoundation] Fix invalid ID not regenerated with native PHP file sessions (BrokenSourceCode)
 * bug #47129 [FrameworkBundle] remove the ChatterInterface alias when the chatter service is removed (xabbuh)

* 5.4.11 (2022-07-29)

 * bug #47069 [Security] Allow redirect after login to absolute URLs (Tim Ward)
 * bug #47073 [HttpKernel] Fix non-scalar check in surrogate fragment renderer (aschempp)
 * bug #47003 [Cache] Ensured that redis adapter can use multiple redis sentinel hosts (warslett)
 * bug #43329 [Serializer] Respect default context in DateTimeNormalizer::denormalize (hultberg)
 * bug #47070 [Messenger] Fix function name in TriggerSql on postgresql bridge to support table name with schema (zimny9932)
 * bug #47086 Workaround disabled "var_dump" (nicolas-grekas)
 * bug #40828 [BrowserKit] Merge fields and files recursively if they are multidimensional array (januszmk)
 * bug #47010 [String] Fix `width` method in `AbstractUnicodeString` (TBoileau)
 * bug #47048 [Serializer] Fix XmlEncoder encoding attribute false (alamirault)
 * bug #47022 [Console] get full command path for command in search path (remicollet)
 * bug #47000 [ErrorHandler] Fix return type patching for list and class-string pseudo types (derrabus)
 * bug #43998 [HttpKernel] [HttpCache] Don't throw on 304 Not Modified (aleho)
 * bug #46792 [Bridge] Corrects bug in test listener trait (magikid)
 * bug #46985 [DoctrineBridge] Avoid calling `AbstractPlatform::hasNativeGuidType()` (derrabus)
 * bug #46958 [Serializer] Ignore getter with required parameters (Fix #46592) (astepin)
 * bug #46981 [Mime]  quote address names if they contain parentheses (xabbuh)
 * bug #46960 [FrameworkBundle] Fail gracefully when forms use disabled CSRF (HeahDude)
 * bug #46973 [DependencyInjection] Fail gracefully when attempting to autowire composite types (derrabus)
 * bug #45884 [Serializer] Fix inconsistent behaviour of nullable objects in key/value arrays (phramz)
 * bug #46963 [Mime] Fix inline parts when added via attachPart() (fabpot)
 * bug #46968 [PropertyInfo] Make sure nested composite types do not crash ReflectionExtractor (derrabus)
 * bug #46931 Flush backend output buffer after closing. (bradjones1)
 * bug #46947 [Serializer] Prevent that bad Ignore method annotations lead to incorrect results (astepin)
 * bug #46948 [Validator] : Fix "PHP Warning: Undefined array key 1" in NotCompromisedPasswordValidator (KevinVanSonsbeek)
 * bug #46905 [BrowserKit] fix sending request to paths containing multiple slashes (xabbuh)
 * bug #46244 [Validator] Fix traverse option on Valid constraint when used as Attribute (tobias-93)
 * bug #42033 [HttpFoundation] Fix deleteFileAfterSend on client abortion (nerg4l)
 * bug #46941 [Messenger] Fix calls to deprecated DBAL methods (derrabus)
 * bug #46863 [Mime] Fix invalid DKIM signature with multiple parts (BrokenSourceCode)
 * bug #46808 [HttpFoundation] Fix TypeError on null `$_SESSION`  in `NativeSessionStorage::save()` (chalasr)
 * bug #46811 [DoctrineBridge] Fix comment for type on Query::setValue (middlewares) (l-vo)
 * bug #46790 [HttpFoundation] Prevent PHP Warning: Session ID is too long or contains illegal characters (BrokenSourceCode)
 * bug #46800 Spaces in system temp folder path cause deprecation errors in php 8 (demeritcowboy)
 * bug #46797 [Messenger] Ceil waiting time when multiplier is a float on retry (WissameMekhilef)

* 5.4.10 (2022-06-26)

 * bug #46779 [String] Add an invariable word in french (lemonlab)
 * bug #46765 [Serializer] Fix denormalization union types with constructor (Gwemox)
 * bug #46769 [HttpKernel] Fix a PHP 8.1 deprecation notice in HttpCache (mpdude)
 * bug #46760 Fix double authentication via RememberMe resulting in wrong RememberMe cookie being set in client (heiglandreas)
 * bug #46735 [Messenger] Do not log the message object itself (ajardin)
 * bug #46748 [Security] Fix legacy impersonation system (dunglas)
 * bug #46747 Fix global state pollution between tests run with ApplicationTester (Seldaek)
 * bug #46730 [Intl] Fix the IntlDateFormatter::formatObject signature (damienalexandre)
 * bug #46668 [FrameworkBundle] Lower JsonSerializableNormalizer priority (aprat84)
 * bug #46711 [PhpUnitBridge] Exclude from baseline generation deprecations triggered in legacy test (mondrake)
 * bug #46678 [HttpFoundation] Update "[Session] Overwrite invalid session id" to only validate when files session storage is used (alexpott)
 * bug #45861 [Serializer] Try all possible denormalization route with union types when ALLOW_EXTRA_ATTRIBUTES=false (T-bond)
 * bug #46676 [DoctrineBridge] Extend type guessing on enum fields (Gigino Chianese)
 * bug #46699 [Cache] Respect $save option in all adapters (jrjohnson)
 * bug #46697 [HttpKernel] Disable session tracking while collecting profiler data (nicolas-grekas)
 * bug #46684 [MonologBridge] Fixed support of elasticsearch 7.+ in ElasticsearchLogstashHandler (lyrixx)
 * bug #46646 [Messenger] move resetting services at worker stopped into listener (Thomas Talbot)
 * bug #46368 [Mailer] Fix for missing sender name in case with usage of the EnvelopeListener (bobahvas)
 * bug #46603 [Mailer] Fix Error Handling for OhMySMTP Bridge (paul-oms)
 * bug #46545 Fix getting class constraints on debug command (loic425)
 * bug #46548 [Mime] Allow url as a path in the DataPart::fromPath (wkania)
 * bug #46576 Fix choice filter error when loading mix of grouped and non-grouped choices (BreyndotEchse)
 * bug #46594 [FrameworkBundle] Fix XML cache config (HeahDude)
 * bug #46610 [Messenger] use the outermost wrapping DBAL connection (xabbuh)
 * bug #46595 [Console] Escape  in command name & description from getDefaultName() (ogizanagi)
 * bug #46608 [Console] Fix deprecation when description is null (HypeMC)
 * bug #46574 [Console] Escape  in command name & description from PHP (getDefault* methods) (ogizanagi)
 * bug #46577 [Serializer] Fix ignore attribute in Xml files (alamirault)
 * bug #46565 [WebProfilerBundle] Fix dark theme selected line highlight color & reuse css vars (ogizanagi)
 * bug #46525 [Serializer] Get attributeContext after converting name (zenas1210)
 * bug #46535 [Mime] Check that the path is a file in the DataPart::fromPath (wkania)
 * bug #46543 [Cache] do not pass null to strlen() (xabbuh)
 * bug #46515 [PropertyInfo] Fix extracting int range type (norkunas)
 * bug #46478 [Contracts] remove static cache from `ServiceSubscriberTrait` (kbond)

* 5.4.9 (2022-05-27)

 * bug #46386 [Console]  Fix missing negative variation of negatable options in shell completion (GromNaN)
 * bug #46448 [DependencyInjection] Fix "proxy" tag: resolve its parameters and pass it to child definitions (nicolas-grekas)
 * bug #46442 [FrameworkBundle] Revert "bug #46125  Always add CacheCollectorPass (fancyweb)" (chalasr)
 * bug #46443 [DoctrineBridge] Don't reinit managers when they are proxied as ghost objects (nicolas-grekas)
 * bug #46427 [FrameworkBundle] fix wiring of annotations.cached_reader (nicolas-grekas)
 * bug #46425 [DependencyInjection] Ignore unused bindings defined by attribute (nicolas-grekas)
 * bug #46434 [FrameworkBundle] Fix BC break in abstract config commands (yceruto)
 * bug #46424 [Form] do not accept array input when a form is not multiple (xabbuh)
 * bug #46367 [Mime] Throw exception when body in Email attach method is not ok (alamirault)
 * bug #46421 [VarDumper][VarExporter] Deal with DatePeriod->include_end_date on PHP 8.2 (nicolas-grekas)
 * bug #46401 [Cache] Throw when "redis_sentinel" is used with a non-Predis "class" option (buffcode)
 * bug #46414 Bootstrap 4 fieldset for row errors (konradkozaczenko)
 * bug #46412 [FrameworkBundle] Fix dumping extension config without bundle (yceruto)
 * bug #46382 [HttpClient] Honor "max_duration" when replacing requests with async decorators (nicolas-grekas)
 * bug #46407 [Filesystem] Safeguard (sym)link calls (derrabus)
 * bug #46098 [Form] Fix same choice loader with different choice values (HeahDude)
 * bug #46380 [HttpClient] Add missing HttpOptions::setMaxDuration() (nicolas-grekas)
 * bug #46249 [HttpFoundation] [Session] Regenerate invalid session id (peter17)
 * bug #46328 [Config] Allow scalar configuration in PHP Configuration (jderusse, HypeMC)
 * bug #46366 [Mime] Add null check for EmailHeaderSame (magikid)
 * bug #46364 [Config] Fix looking for single files in phars with GlobResource (nicolas-grekas)
 * bug #46365 [HttpKernel] Revert "bug #46327  Allow ErrorHandler ^5.0 to be used" (nicolas-grekas)
 * bug #46114 Fixes "Incorrectly nested style tag found" error when using multi-line header content (Perturbatio)
 * bug #46325 [Ldap] Fix LDAP connection options (buffcode)
 * bug #46341 Fix aliases handling in command name completion (Seldaek)
 * bug #46317 [Security/Http] Ignore invalid URLs found in failure/success paths (nicolas-grekas)
 * bug #46309 [Security] Fix division by zero (tvlooy)
 * bug #46327 [HttpKernel] Allow ErrorHandler ^5.0 to be used in HttpKernel 4.4 (mpdude)
 * bug #46297 [Serializer] Fix JsonSerializableNormalizer ignores circular reference handler in $context (BreyndotEchse)
 * bug #46291 [Console] Suppress unhandled error in some specific use-cases. (rw4lll)
 * bug #46302 [ErrorHandler] Fix list of tentative return types (nicolas-grekas)
 * bug #45981 [Serializer][PropertyInfo] Fix support for "false" built-in type on PHP 8.2 (alexandre-daubois)
 * bug #46277 [HttpKernel] Fix SessionListener without session in request (edditor)
 * bug #46282 [DoctrineBridge] Treat firstResult === 0 like null (derrabus)
 * bug #46239 [Translation] Refresh local translations on PushCommand if the provider has domains (Florian-B)
 * bug #46278 [Workflow] Fix deprecated syntax for interpolated strings (nicolas-grekas)
 * bug #46264 [Console] Better required argument check in InputArgument (jnoordsij)
 * bug #46262 [EventDispatcher] Fix removing listeners when using first-class callable syntax (javer)
 * bug #46216 [Form] fix populating single widget time view data with different timezones (xabbuh)
 * bug #46221 [DomCrawler][VarDumper] Fix html-encoding emojis (nicolas-grekas)
 * bug #46167 [VarExporter] Fix exporting DateTime objects on PHP 8.2 (nicolas-grekas)

* 5.4.8 (2022-04-27)

 * bug #46154 [Mailer] Restore X-Transport after failure (zenas1210)
 * bug #46178 [DependencyInjection] Properly declare #[When] as allowed on functions (nicolas-grekas)
 * bug #46171 [VarDumper] Fix dumping floats on PHP8 (nicolas-grekas)
 * bug #46170 Fix dumping enums on PHP 8.2 (nicolas-grekas)
 * bug #46143 [Cache] Prevent fatal errors on php 8 when running concurrently with TagAwareAdapter v6.1 (sbelyshkin)
 * bug #46149 Modify processing of uploaded files to be compatible with PHP 8.1 (p-golovin)
 * bug #46125 [FrameworkBundle] Always add CacheCollectorPass (fancyweb)
 * bug #46121 Fix "Notice: Undefined index: headers" in messenger with Oracle (rjd22)
 * bug #46106 [String] Fix ansi escape sequences regex (fancyweb)
 * bug #46097 [Routing] fix router base url when default uri has trailing slash (Tobion)
 * bug #46054 [SecurityBundle] Use config's secret in remember-me signatures (jderusse)
 * bug #45980 [Finder] Add support of no-capture regex modifier in MultiplePcreFilterIterator (available from PHP 8.2) (alexandre-daubois)
 * bug #45394 [HttpKernel] Use the existing session id if available. (trsteel88)
 * bug #46008 [Workflow] Catch error when trying to get an uninitialized marking (lyrixx)
 * bug #45171 [Translation] Allow usage of Provider domains if possible (welcoMattic)
 * bug #40998 [Form] Use reference date in reverse transform (KDederichs)
 * bug #46012 [HttpKernel] Fix Symfony not working on SMB share (qinshuze)
 * bug #45983 [Messenger] DoctrineTransportFactory works with notify and decorated PostgreSQL driver (alamirault)
 * bug #45992 [Mailer] Return-Path has higher priority for envelope address than From address (tpetry)
 * bug #45998 [HttpClient] Fix sending content-length when streaming the body (nicolas-grekas)
 * bug #45565 Fix table header seperator wrapping (alamirault)
 * bug #45969 [Intl] Update the ICU data to 71.1 - 5.4 (jderusse)
 * bug #45968 [Intl] Update the ICU data to 71.1 - 4.4 (jderusse)
 * bug #45964 Fix use_cookies framework session configuration (alexander-schranz)
 * bug #45947 [FrameworkBundle] [Command] Fix `debug:router --no-interaction` error … (WilliamBoulle)
 * bug #45948 [RateLimiter] Adding default empty string value on Security::LAST_USERNAME (David-Crty)
 * bug #45931 [Process] Fix Process::getEnv() when setEnv() hasn't been called before (asika32764)
 * bug #45928 [ExpressionLanguage] Fix matching null against a regular expression (ausi)
 * bug #45925 [RateLimiter] Add typecase to SlidingWindow::getExpirationTime (georgringer)
 * bug #45910 [Messenger] reset connection on worker shutdown (SanderHagen)
 * bug #45909 [Form][TwigBundle] reset Twig form theme resources between requests (xabbuh)

* 5.4.7 (2022-04-02)

 * bug #45906 [HttpClient] on redirections don't send content related request headers (xabbuh)
 * bug #45714 [Messenger] Fix cannot select FOR UPDATE from view on Oracle (rjd22)
 * bug #45905 [TwigBridge] Fix the build (wouterj)
 * bug #45888 [Messenger] Add mysql indexes back and work around deadlocks using soft-delete (nicolas-grekas)
 * bug #45890 [PropertyInfo] PhpStanExtractor namespace missmatch issue (Korbeil)
 * bug #45897 [TwigBridge] fix bootstrap_3_layout ChoiceType's expanded label_html (ytilotti)
 * bug #45891 [HttpClient] Fix exporting objects with readonly properties (nicolas-grekas)
 * bug #45875 [ExpressionLanguage] Fix matches when the regexp is not valid (fabpot)
 * bug #44996 [RateLimiter] Always store SlidingWindows with an expiration set (Seldaek)
 * bug #45870 [Validator] Fix File constraint invalid max size exception message (fancyweb)
 * bug #45851 [Console] Fix exit status on uncaught exception with negative code (acoulton)
 * bug #45733 [Validator] fix #43345 @Assert\DivisibleBy (CharlyPoppins)
 * bug #45791 [Translation] [LocoProvider] Add content-type for POST translations (Tomasz Kusy)
 * bug #45840 [Translation] Fix locales format in CrowdinProvider (ossinkine)
 * bug #45491 [DoctrineBridge] Allow to use a middleware instead of DbalLogger (l-vo)
 * bug #45839 [Translation] Fix intersect in TranslatorBag (ossinkine)
 * bug #45838 [Serializer] Fix denormalizing union types (T-bond)
 * bug #45808 [Security] Fixed TOCTOU in RememberMe cache token verifier (Ivan Kurnosov)
 * bug #45816 [Mailer] Preserve case of headers (nicolas-grekas)
 * bug #45787 [FrameworkBundle] Fix exit codes in debug:translation command (gndk)
 * bug #45789 [Config] Fix using null values with config builders (HypeMC)
 * bug #45814 [HttpClient] Let curl handle Content-Length headers (nicolas-grekas)
 * bug #45813 [HttpClient] Move Content-Type after Content-Length (nicolas-grekas)
 * bug #45737 [Lock] SemaphoreStore catching exception from sem_get (Triplkrypl)
 * bug #45690 [Mailer] Use recipients in sendmail transport (HypeMC)
 * bug #45720 [PropertyInfo] strip only leading `\` when unknown docType (EmilMassey)
 * bug #45764 [RateLimiter] Fix rate serialization for long intervals (monthly and yearly) (smelesh)
 * bug #45684 [Serializer] Fix nested deserialization_path computation when there is no metadata for the attribute (fancyweb)
 * bug #44915 [Console] Fix compact table style to avoid outputting a leading space (Seldaek)
 * bug #45691 [Mailer] fix: stringify from address for ses+api transport (everyx)
 * bug #45696 Make FormErrorIterator generic (VincentLanglet)
 * bug #45676 [Process] Don't return executable directories in PhpExecutableFinder (fancyweb)
 * bug #45564 [symfony/mailjet-mailer] Fix invalid mailjet error managment (alamirault, fancyweb)
 * bug #45697 [Security] Fix return value of `NullToken::getUser()` (chalasr)
 * bug #45719 typehint of DkimOptions algorithm wrong (markusramsak)
 * bug #45702 [Form] Fix the usage of the Valid constraints in array-based forms (stof)
 * bug #45677 [DependencyInjection] fix `ServiceSubscriberTrait` bug where parent has `__call()` (kbond)
 * bug #45678 [HttpClient] Fix reading proxy settings from dotenv when curl is used (nicolas-grekas)
 * bug #45675 [Runtime] Fix passing $debug parameter to `ErrorHandler` (Kocal)
 * bug #45629 [FrameworkBundle] Fix container:lint and #[Autoconfigure(binds: ...)] failing (LANGERGabrielle)
 * bug #45671 [FrameworkBundle] Ensure container is reset between tests (nicolas-grekas)
 * bug #45572 [HttpKernel] fix using Target attribute with controller arguments (kbond)

* 5.4.6 (2022-03-05)

 * bug #45619 [redis-messenger] remove undefined array key warnings (PhilETaylor)
 * bug #45637 [Cache] do not pass DBAL connections to PDO adapters (xabbuh)
 * bug #45631 [HttpFoundation] Fix PHP 8.1 deprecation in `Response::isNotModified` (HypeMC)
 * bug #45610 [HttpKernel] Guard against bad profile data (nicolas-grekas)
 * bug #45532 Fix deprecations on PHP 8.2 (nicolas-grekas)
 * bug #45595 [FrameworkBundle] Fix resetting container between tests (nicolas-grekas)
 * bug #45590 [Console] Revert StringInput bc break from #45088 (bobthecow)
 * bug #45585 [HttpClient] fix checking for unset property on PHP <= 7.1.4 (nicolas-grekas)
 * bug #45583 [WebProfilerBundle] Fixes HTML syntax regression introduced by #44570 (xavismeh)

* 5.4.5 (2022-02-28)

 * bug #45351 [WebProfilerBundle] Log section minor fixes (missing "notice" filter, log priority, accessibility) (Amunak)
 * bug #44967 [Validator] Multi decimal to alpha for CssColor validator (tilimac)
 * bug #45546 [Console] Fix null handling in formatAndWrap() (derrabus)
 * bug #44570 [WebProfilerBundle] add nonces to profiler (garak)
 * bug #44839 MailerInterface: failed exception contract when enabling messenger (Giorgio Premi)
 * bug #45526 [Lock] Release Locks from Internal Store on Postgres waitAndSave* (chrisguitarguy)
 * bug #45529 [DependencyInjection] Don't reset env placeholders during compilation (nicolas-grekas)
 * bug #45527 [HttpClient] Fix overriding default options with null (nicolas-grekas)
 * bug #45531 [Serializer] Fix passing null to str_contains() (Erwin Dirks)
 * bug #42458 [Validator][Tests] Fix AssertingContextualValidator not throwing on remaining expectations (fancyweb)
 * bug #45279 [Messenger] Fix dealing with unexpected payload in Redis transport (nicoalonso)
 * bug #45496 [VarDumper] Fix dumping mysqli_driver instances (nicolas-grekas)
 * bug #45495 [HttpFoundation] Fix missing ReturnTypeWillChange attributes (luxemate)
 * bug #45482 [Cache] Add missing log when saving namespace (developer-av)
 * bug #45479 [HttpKernel] Reset services between requests performed by KernelBrowser (nicolas-grekas)
 * bug #44650 [Serializer] Make document type nodes ignorable (boenner)
 * bug #45469 [SecurityBundle] fix autoconfiguring Monolog's ProcessorInterface (nicolas-grekas)
 * bug #45414 [FrameworkBundle] KernelTestCase resets internal state on tearDown (core23)
 * bug #45430 [Dotenv] Fix reading config for symfony/runtime when running dump command (nicolas-grekas)
 * bug #45460 [Intl] fix wrong offset timezone PHP 8.1 (Lenny4)
 * bug #45462 [HttpKernel] Fix extracting controller name from closures (nicolas-grekas)
 * bug #45463 [Security/Http] Fix getting password-upgrader when user-loader is a closure (nicolas-grekas)
 * bug #45424 [DependencyInjection] Fix type binding (sveneld)
 * bug #45426 [Runtime] Fix dotenv_overload with commands (fancyweb)
 * bug #44259 [Security] AccountStatusException::$user should be nullable (Cantepie)
 * bug #45391 [Serializer] Ensuring end of line character apply with constructor settings in CSV encoder (bizley)
 * bug #45323 [Serializer] Fix ignored callbacks in denormalization (benjaminmal)
 * bug #45399 [FrameworkBundle] Fix sorting bug in sorting of tagged services by priority (Ahummeling)
 * bug #45338 [Mailer] Fix string-cast of exceptions thrown by authenticator in EsmtpTransport (wikando-ck)
 * bug #45339 [Cache] fix error handling when using Redis (nicolas-grekas)
 * bug #45331 [Security]  Fix wrong authenticator class in debug logs (chalasr)
 * bug #45322 Fix generic type for FormErrorIterator (akalineskou)
 * bug #45281 [Cache] Fix connecting to Redis via a socket file (alebedev80)
 * bug #45289 [FrameworkBundle] Fix log channel of TagAwareAdapter (fancyweb)
 * bug #45306 [PropertyAccessor] Add missing TypeError catch (b1rdex)
 * bug #44868 [DependencyInjection][FrameworkBundle] Fix using PHP 8.1 enum as parameters (ogizanagi)
 * bug #45299 [DependencyInjection] Fix AsEventListener not working on decorators (LANGERGabrielle)
 * bug #45302 [HttpKernel][WebProfilerBundle] Fixed error count by log not displayed in WebProfilerBundle (SVillette)
 * bug #45219 [WebProfilerBundle] Fixes weird spacing in log message context/trace output (jennevdmeer)
 * bug #45290 [Notifier] fix Microsoft Teams webhook url (christophkoenig)
 * bug #45274 [Mailer] allow Mailchimp to handle multiple TagHeader's (kbond)
 * bug #45275 [Mailer] ensure only a single tag can be used with Postmark (kbond)
 * bug #45261 [HttpClient] Fix Content-Length header when possible (nicolas-grekas)
 * bug #45258 [DependencyInjection] Don't dump polyfilled classes in preload script (nicolas-grekas)
 * bug #38534 [Serializer] make XmlEncoder stateless thus reentrant (connorhu)
 * bug #42253 [Form] Do not fix URL protocol for relative URLs (bogkonstantin)
 * bug #45256 [DomCrawler] ignore bad charsets (nicolas-grekas)
 * bug #45255 [PropertyAccess] Fix handling of uninitialized property of parent class (filiplikavcan)
 * bug #45204 [Validator] Fix minRatio and maxRatio when getting rounded (alexander-schranz)
 * bug #45240 [Console] Revert StringInput bc break from #45088 (bobthecow)
 * bug #45243 [DoctrineBridge] Fix compatibility with doctrine/orm 3 in Id generators (ostrolucky)

* 5.4.4 (2022-01-29)

 * security #cve-2022-xxxx [FrameworkBundle] Enable CSRF in FORM by default (jderusse)

* 5.4.3 (2022-01-28)

 * bug #45193 [FrameworkBundle] Fix missing arguments when a serialization default context is bound (ArnoudThibaut)
 * bug #44997 [Runtime] Fix --env and --no-debug with dotenv_overload (fancyweb)
 * bug #45188 [Dotenv] Fix bootEnv() override with .env.local.php when the env key already exists (fancyweb)
 * bug #45095 [Finder] Fix finding VCS re-included files in excluded directory (julienfalque)
 * bug #44987 [DoctrineBridge]  Fix automapping (mbabker)
 * bug #44860 [Validator] Fix Choice constraint with associative choices array (derrabus)
 * bug #44939 [Form] UrlType should not add protocol to emails (GromNaN)
 * bug #43149 Silence warnings during tty detection (neclimdul)
 * bug #45154 [Serializer] Fix AbstractObjectNormalizer not considering pseudo type false (Thomas Nunninger)
 * bug #45185 [Notifier] Fix encoding of messages with FreeMobileTransport (94noni)
 * bug #45181 [Console] Fix PHP 8.1 deprecation in ChoiceQuestion (BrokenSourceCode)
 * bug #44634 [HttpKernel] Fix compatibility with php bridge and already started php sessions (alexander-schranz)
 * bug #45174 [Notifier] Use the UTF-8 encoding in smsapi-notifier (marphi)
 * bug #45140 [Yaml] Making the parser stateless (mamazu)
 * bug #45109 [Console] fix restoring stty mode on CTRL+C (nicolas-grekas)
 * bug #45103 [Process] Avoid calling fclose on an already closed resource (Seldaek)
 * bug #44941 [RateLimiter] Resolve crash on near-round timestamps (xesxen)
 * bug #45088 [Console] fix parsing escaped chars in StringInput (nicolas-grekas)
 * bug #45096 [Cache] Throw exception if incompatible version of psr/simple-cache is used (colinodell)
 * bug #45067 [RateLimiter] Implicit conversion fix (brian978)
 * bug #45063 [DependencyInjection] remove arbitratry limitation to exclude inline services from bindings (nicolas-grekas)
 * bug #44986 [DependencyInjection] copy synthetic status when resolving child definitions (kbond)
 * bug #45073 [HttpClient] Fix Failed to open stream: Too many open files (adrienfr)
 * bug #45053 [Console] use STDOUT/ERR in ConsoleOutput to save opening too many file descriptors (nicolas-grekas)
 * bug #45029 [Cache] Set mtime of cache files 1 year into future if they do not expire (Blacksmoke16)
 * bug #45012 [DoctrineBridge] Fix invalid guess with enumType (jderusse)
 * bug #45015 [HttpClient] fix resetting DNS/etc when calling CurlHttpClient::reset() (nicolas-grekas)
 * bug #45004 [HttpClient] Remove deprecated usage of GuzzleHttp\Promise\promise_for (plozmun)
 * bug #44998 [FrameworkBundle] Allow default cache pools to be overwritten by user (Seldaek)
 * bug #44890 [HttpClient] Remove deprecated usage of `GuzzleHttp\Promise\queue` (GrahamCampbell)
 * bug #45002 [PropertyAccess] Fix handling of uninitialized property of anonymous class (filiplikavcan)
 * bug #44979 [DependencyInjection] Add iterable to possible binding type (vladimir.panivko)
 * bug #44976 [FrameworkBundle] Avoid calling rtrim(null, '/') in AssetsInstallCommand (pavol-tk, GromNaN)
 * bug #44879 [DependencyInjection] Ignore argument type check in CheckTypeDeclarationsPass if it's a Definition with a factory (fancyweb)
 * bug #44920 Use correct tag for ExpoTransportFactory service (jschaedl)
 * bug #44931 Allow a zero time-limit for messenger:consume (fritzmg)
 * bug #44932 [DependencyInjection] Fix nested env var with resolve processor (Laurent Moreau)
 * bug #44912 [Console] Allow OutputFormatter::escape() to be used for escaping URLs used in <href> (Seldaek)
 * bug #44877 [Validator] Error using CssColor with doctrine annotations (sormes)
 * bug #44878 [HttpClient] Turn negative timeout to a very long timeout (fancyweb)
 * bug #44854 [Validator] throw when Constraint::_construct() has not been called (nicolas-grekas)
 * bug #44857 [Translation] [LocoProvider] Fix use of asset ids (danut007ro)

* 5.4.2 (2021-12-29)

 * bug #44828 [Lock] Release DoctrineDbalPostgreSqlStore connection lock on failure (simon-watiau)
 * bug #44838 [DependencyInjection][HttpKernel] Fix enum typed bindings (ogizanagi)
 * bug #44723 [Lock] Release PostgreSqlStore connection lock on failure (simon-watiau) * commit 'e5b2f9efba':   [Lock] Release PostgreSqlStore connection lock on failure
 * bug #44826 [HttpKernel] Do not attempt to register enum arguments in controller service locator (ogizanagi)
 * bug #44824 [Mime] Fix missing sprintf in DkimSigner (alamirault)
 * bug #44816 [Translation] [LocoProvider] Use rawurlencode and separate tag setting (danut007ro)
 * bug #44805 [Security] fix unserializing session payloads from v4 (nicolas-grekas)
 * bug #44820 [Cache] Don't lock when doing nested computations (nicolas-grekas)
 * bug #44807 [Messenger] fix Redis support on 32b arch (nicolas-grekas)
 * bug #44759 [HttpFoundation] Fix notice when HTTP_PHP_AUTH_USER passed without pass (Vitali Tsyrkin)
 * bug #44809 [WebProfilerBundle] relax return type for memory data collector (94noni)
 * bug #44799 [Cache] fix compat with apcu < 5.1.10 (nicolas-grekas)
 * bug #44764 [Form] Expand FormView key to include int (biozshock)
 * bug #44730 [Console] Fix autocompletion of argument with default value (GromNaN)
 * bug #44637 [PropertyInfo] PhpStan extractor nested object fix (rmikalkenas)
 * bug #44085 [Translation] Fix TranslationPullCommand with ICU translations (Kocal)
 * bug #44578 [PropertyInfo] Fix phpstan extractor issues (ostrolucky)
 * bug #44771 [Notifier] Use correct factory for the msteams transport (veewee)
 * bug #44618 [HttpKernel] Fix SessionListener without session in request (shyim)
 * bug #44743 [HttpClient] fix checking for recent curl consts (nicolas-grekas)
 * bug #44752 [Security/Http] Fix cookie clearing on logout (maxhelias)
 * bug #44732 [Mime] Relaxing in-reply-to header validation (ThomasLandauer)
 * bug #44714 [WebProfilerBundle] fix Email HTML preview (94noni)
 * bug #44728 [Mime] Fix encoding filenames in multipart/form-data (nicolas-grekas)
 * bug #44602 [Serializer] Improve UidNormalizer denormalize error message (fancyweb)
 * bug #44383 [Lock] Create tables in transaction only if supported by driver (martinssipenko)
 * bug #44518 [HttpFoundation] Take php session.cookie settings into account (simonchrz)
 * bug #44719 [ErrorHandler] fix on patching return types on Windows (nicolas-grekas)
 * bug #44710 [DependencyInjection] fix linting callable classes (nicolas-grekas)
 * bug #44639 [DependencyInjection] Cast tag attribute value to string (ruudk)
 * bug #44473 [Validator] Restore default locale in ConstraintValidatorTestCase (rodnaph)
 * bug #44682 [FrameworkBundle] alias `cache.app.taggable` to `cache.app` if using `cache.adapter.redis_tag_aware` (kbond)
 * bug #44649 [HttpKernel] fix how configuring log-level and status-code by exception works (nicolas-grekas)
 * bug #44667 [Cache] Revert "feature #41989  make `LockRegistry` use semaphores when possible" (nicolas-grekas)
 * bug #44671 [HttpClient] Fix tracing requests made after calling withOptions() (nicolas-grekas)
 * bug #44577 [Cache] Fix proxy no expiration to the Redis (Sergey Belyshkin)
 * bug #44669 [Cache] disable lock on CLI (nicolas-grekas)
 * bug #44598 [Translation] Handle the blank-translation in Loco Adapter (kgonella)
 * bug #44448 [Validator] Allow Sequence constraint to be applied onto class as an attribute (sidz)
 * bug #44354 [RateLimiter] Make RateLimiter resilient to timeShifting (jderusse)
 * bug #44600 [Serializer] Fix denormalizing custom class in UidNormalizer (fancyweb)
 * bug #44537 [Config] In XmlUtils, avoid converting from octal every string starting with a 0 (alexandre-daubois)
 * bug #44510 [Workflow] Fix eventsToDispatch parameter setup for StateMachine (Olexandr Kalaidzhy)
 * bug #44625 [HttpClient] fix monitoring responses issued before reset() (nicolas-grekas)
 * bug #44623 [HttpClient] Fix dealing with "HTTP/1.1 000 " responses (nicolas-grekas)
 * bug #44430 [PropertyInfo] Fix aliased namespace matching (Korbeil)
 * bug #44601 [HttpClient] Fix closing curl-multi handle too early on destruct (nicolas-grekas)
 * bug #44571 [HttpClient] Don't reset timeout counter when initializing requests (nicolas-grekas)
 * bug #44479 [HttpClient] Double check if handle is complete (Nyholm)
 * bug #44418 [DependencyInjection] Resolve ChildDefinition in AbstractRecursivePass (fancyweb)
 * bug #44474 [Translation] [Bridge] [Lokalise] Fix push keys to lokalise. Closes #… (olegmifle)
 * bug #43164 [FrameworkBundle] Fix cache pool configuration with one adapter and one provider (fancyweb)
 * bug #44419 [PropertyAccess] Fix accessing public property on Object (kevcomparadise)
 * bug #44565 [FrameworkBundle] Use correct cookie domain in loginUser() (wouterj)
 * bug #44538 [Process] fixed uppercase ARGC and ARGV should also be skipped (rbaarsma)
 * bug #44438 [HttpClient] Fix handling thrown \Exception in \Generator in MockResponse (fancyweb)
 * bug #44469 [String] Fix requiring wcswitch table several times (fancyweb)
 * bug #44539 [Lock] Fix missing argument in PostgreSqlStore::putOffExpiration with DBAL connection (GromNaN)

* 5.4.1 (2021-12-09)

 * bug #44490 [DependencyInjection][Messenger] Add auto-registration for BatchHandlerInterface (GaryPEGEOT)
 * bug #44523 [Console] Fix polyfill-php73 requirement (Seldaek)
 * bug #44502 [HttpFoundation] do not call preg_match() on null (xabbuh)
 * bug #44475 [Console] Handle alias in completion script (GromNaN)
 * bug #44481 [FrameworkBundle] Fix loginUser() causing deprecation (wouterj)
 * bug #44416 [Translation] Make http requests synchronous when reading the Loco API (Kocal)
 * bug #44437 [HttpKernel] Fix wrong usage of SessionUtils::popSessionCookie (simonchrz)
 * bug #44350 [Translation] Fix TranslationTrait (Tomasz Kusy)
 * bug #44460 [SecurityBundle] Fix ambiguous deprecation message on missing provider (chalasr)
 * bug #44467 [Console] Fix parameter types for `ProcessHelper::mustRun()` (derrabus)
 * bug #44427 [FrameworkBundle] Fix compatibility with symfony/security-core 6.x (deps=high tests) (wouterj)
 * bug #44424 [SecurityBundle] Don't rely on deprecated strategy constants (derrabus)
 * bug #44399 Prevent infinite nesting of lazy `ObjectManager` instances when `ObjectManager` is reset (Ocramius)
 * bug #44395 [HttpKernel] fix sending Vary: Accept-Language when appropriate (nicolas-grekas)
 * bug #44385 [DependencyInjection] Skip parameter attribute configurators in AttributeAutoconfigurationPass if we can't get the constructor reflector (fancyweb)
 * bug #44359 Avoid duplicated session listener registration in tests (alexander-schranz)
 * bug #44375 [DoctrineBridge] fix calling get_class on non-object (kbond)
 * bug #44378 [HttpFoundation] fix SessionHandlerFactory using connections (dmaicher)
 * bug #44365 [SecurityBundle]  Fix invalid reference with `always_authenticate_before_granting` (chalasr)
 * bug #44361 [HttpClient] Fix handling error info in MockResponse (fancyweb)
 * bug #44370 [Lock] create lock table if it does not exist (martinssipenko)

* 5.4.0 (2021-11-29)

 * bug #44309 [Messenger] Leverage DBAL's getNativeConnection() method (derrabus)
 * bug #44300 [FrameworkBundle] Fix property-info phpstan extractor discovery (1ed)
 * feature #44271 [Notifier] add Vonage bridge to replace the Nexmo one (nicolas-grekas)
 * bug #44187 [Translation] [Loco] Fix idempotency of LocoProvider write method (welcoMattic)
 * bug #43992 [Security] Do not overwrite already stored tokens for REMOTE_USER authentication (stlrnz)
 * bug #43876 [Validator] Fix validation for single level domains (HypeMC)
 * bug #44327 [Debug][ErrorHandler] Increased the reserved memory from 10k to 32k (sakalys)
 * bug #44261 [Process] intersect with getenv() in case-insensitive manner to get default envs (stable-staple)
 * bug #44295 [Serializer] fix support for lazy/unset properties (nicolas-grekas)
 * bug #44277 [Notifier] Fix AllMySms bridge body content (afiocre)
 * bug #44269 [DoctrineBridge] Revert " add support for the JSON type" (dunglas)

* 5.4.0-RC1 (2021-11-24)

 * security #cve-2021-41268 [SecurityBundle] Default signature_properties to the previous behavior (wouterj)
 * security #cve-2021-41267 [HttpKernel] Fix missing extra trusted header in sub-request (jderusse)
 * security #cve-2021-41270 [Serializer] Use single quote to escape formulas (jderusse)
 * bug #44230 [Console] Add Suggestion class for more advanced completion suggestion (wouterj)
 * bug #44232 [Cache] fix connecting to local Redis sockets (nicolas-grekas)
 * bug #44204 [HttpClient] fix closing curl multi handle when destructing client (nicolas-grekas)
 * bug #44208 [Process] exclude argv/argc from possible default env vars (nicolas-grekas)
 * bug #44188 [VarExporter] fix exporting declared but unset properties when __sleep() is implemented (nicolas-grekas)
 * bug #44176 [Console] Default ansi option to null (jderusse)
 * bug #44179 [WebProfilerBundle] Fix JS error when toolbar is reloaded (jderusse)
 * bug #44172 [Security] Guard is incompatible with Symfony 6 (derrabus)
 * bug #44119 [HttpClient][Mime] Add correct IDN flags for IDNA2008 compliance (j-bernard)
 * bug #44139 [WebProfilerBundle] Prevent installation of incompatible mailer component versions (Anne-Julia Seitz)
 * bug #43917 Allow autodetecting mapping type for any object (franmomu)
 * bug #44131 [Yaml] properly parse quoted strings tagged with !!str (xabbuh)
 * bug #42323 [TwigBridge] do not merge label classes into expanded choice labels (xabbuh)

* 5.4.0-BETA3 (2021-11-18)

 * feature #44125 Add a setter on DateTimeNormalizer to change the default context at runtime (Seldaek)
 * bug #44110 [FrameworkBundle] Fix default PHP attributes support in validation and serializer configuration when doctrine/annotations is not installed with PHP 8 (fancyweb)
 * bug #44115 [WebProfilerBundle] Tweak the colors of the security panel (javiereguiluz)
 * bug #44121 [Serializer] fix support for lazy properties (nicolas-grekas)
 * bug #44108 [FrameworkBundle][Messenger] remove `FlattenExceptionNormalizer` definition if serializer not available (kbond)
 * bug #44111 [Serializer] fix support for unset properties on PHP < 7.4 (nicolas-grekas)
 * bug #44098 [DependencyInjection] fix preloading (nicolas-grekas)
 * bug #44065 [FrameworkBundle] Add framework config for DBAL cache adapter (GromNaN)
 * bug #44096 Make ExpressionVoter Cacheable (jderusse)
 * bug #44070 [Process] intersect with getenv() to populate default envs (nicolas-grekas)
 * feature #43181 Allow AbstractDoctrineExtension implementations to support the newer bundle structure (mbabker)
 * bug #44060 [Cache] Fix calculate ttl in couchbase sdk 3.0 (ajcerezo)
 * bug #43990 [Translation] [Loco] Generate id parameter instead of letting Loco do it (welcoMattic)
 * bug #44043 [Cache] fix dbindex Redis (a1812)
 * feature #44015 [Cache] Decrease the probability of invalidation loss on tag eviction (nicolas-grekas)
 * bug #44064 [Cache] fix releasing not acquired locks (nicolas-grekas)
 * bug #44063 [DependencyInjection] fix creating 2nd container instances (nicolas-grekas)
 * bug #44051 [Notifier] Fix package name (fabpot)
 * bug #44050 [Notifier] Fix package names (fabpot)

* 5.4.0-BETA2 (2021-11-14)

 * bug #44042 Fix DateIntervalToStringTransformer::transform() doc (BenMorel)
 * bug #44034 [Yaml] don't try to replace references in quoted strings (xabbuh)
 * bug #44013 [ErrorHandler] fix parsing ``@param`` with dollars in the description (nicolas-grekas)
 * bug #44010 [DependencyInjection] fix auto-refresh when inline_factories is enabled (nicolas-grekas)
 * bug #44028 [ErrorHandler] Fix FlattenException::setPrevious argument typing (welcoMattic)
 * bug #44016 [SecurityBundle] Fix listing listeners in profiler when authenticator manager is disabled (94noni)
 * bug #44012 [DependencyInjection] fix inlining when non-shared services are involved (nicolas-grekas)
 * bug #44002 [Cache] Fix Memory leak (a1812)
 * bug #43993 [FrameworkBundle] fix deprecation message (nicolas-grekas)
 * feature #43985 [HttpClient] Implement ResetInterface for all http clients (rmikalkenas)
 * bug #43981 [FrameworkBundle] fix registering late resettable services (nicolas-grekas)
 * bug #43988 [DoctrineBridge] add support for the JSON type (dunglas)
 * bug #43987 [PhpUnitBridge] Fix Uncaught ValueError (dunglas)
 * feature #43983 [HttpKernel] allow ignoring kernel.reset methods that don't exist (nicolas-grekas)
 * bug #43967 [Loco] Fix Loco Provider ID and pull & push local messages reading (welcoMattic)
 * bug #43961 [HttpClient] Curl http client has to reinit curl multi handle on reset (rmikalkenas)
 * bug #43930 [DependencyInjection] Fix support for unions/intersections together with `ServiceSubscriberInterface` (kbond)
 * bug #43948 [Asset][Security] Fixed leftover deprecations PHP 8.1 (michaljusiega)
 * bug #43944 [Yaml] revert using functions provided by polyfill packages (xabbuh)
 * bug #43940 [FrameworkBundle] Fix logic in workflow:dump between workflow name and workflow id (noniagriconomie)
 * bug #43945 [Runtime] fix defining APP_DEBUG when Dotenv is not enabled (nicolas-grekas)

* 5.4.0-BETA1 (2021-11-05)

 * feature #43916 [PropertyInfo] Support the list pseudo-type (derrabus)
 * feature #43850 Add completion for DebugConfig name and path arguments (eclairia, Adrien Jourdier)
 * feature #43838 feat: add completion for DebugAutowiring search argument (eclairia, Adrien Jourdier)
 * feature #38464 [Routing] Add support for aliasing routes (Lctrs)
 * feature #43923 [Console] Open CompleteCommand for custom outputs (wouterj)
 * feature #43663 [Messenger] Add  command completion for failed messages (scyzoryck)
 * feature #43857 [Framework] Add completion to debug:container (GromNaN)
 * feature #43891 [Messenger] Add completion to command messenger:consume (GromNaN)
 * feature #42471 Add generic types to traversable implementations (derrabus)
 * feature #43898 [Security] Make the abstract Voter class implement CacheableVoterInterface (javiereguiluz)
 * feature #43848 [FrameworkBundle] Add completion for workflow:dump (StaffNowa)
 * feature #43837 [Finder] Add .gitignore nested negated patterns support (julienfalque)
 * feature #43754 Determine attribute or annotation type for directories (cinamo)
 * feature #43846 Add completion for debug:twig (StaffNowa)
 * feature #43138 [FrameworkBundle][HttpKernel] Add the ability to enable the profiler using a parameter (dunglas)
 * feature #40457 [PropertyInfo] Add `PhpStanExtractor` (Korbeil)
 * feature #40262 [DoctrineBridge] Param as connection in `*.event_subscriber/listener` tags (wbloszyk)
 * feature #43354 [Messenger] allow processing messages in batches (nicolas-grekas)
 * feature #43835 [SecurityBundle] Deprecate not configuring explicitly a provider for custom_authenticators when there is more than one registered provider (lyrixx)
 * feature #43598 [Console] add suggestions for debug commands: firewall, form, messenger, router (IonBazan)
 * feature #41993 [Security] Prevent `FormLoginAuthenticator` from responding to requests that should be handled by `JsonLoginAuthenticator` (abunch)
 * feature #43751 [WebProfilerBundle] Add a "preview" tab in mailer profiler for HTML email (lyrixx)
 * feature #43644 [FrameworkBundle] Add completion to debug:translation command (alexandre-daubois)
 * feature #43653 [PasswordHasher] Add autocompletion for security commands (noniagriconomie)
 * feature #43676 [FrameworkBundle] Add completion feature on translation:update command (stephenkhoo)
 * feature #43672 [Translation] Add completion feature on translation pull and push commands (welcoMattic)
 * feature #43060 [RateLimiter] Add support for long intervals (months and years) (alexandre-daubois)
 * feature #42177 [Security][SecurityBundle] Implement ADM strategies as dedicated classes (derrabus)
 * feature #43804 [DependencyInjection][FrameworkBundle][SecurityBundle][TwigBundle] Deprecate Composer 1 (derrabus)
 * feature #43796 [Filesystem] Add third argument `$lockFile` to `Filesystem::appendToFile()` (fwolfsjaeger)
 * feature #42414 [Notifier] Add Expo bridge (zairigimad)
 * feature #43066 [Security] Cache voters that will always abstain (jderusse)
 * feature #43758 [FrameworkBundle] Rename translation:update to translation:extract (welcoMattic)
 * feature #41414 Support `statusCode` default param when loading template directly via route (dayallnash)
 * feature #42238 [DependencyInjection] Add `SubscribedService` attribute, deprecate current `ServiceSubscriberTrait` usage (kbond)
 * feature #38542 [FrameworkBundle][Serializer] Allow serializer default context configuration (soyuka)
 * feature #43755 [Dotenv] Add $overrideExistingVars to bootEnv() and  loadEnv() and dotenv_overload to SymfonyRuntime (fancyweb)
 * feature #43671 add ResponseIsUnprocessable (garak)
 * feature #43682 [FrameworkBundle] Add completion for config:dump-reference (StaffNowa)
 * feature #43588 [Messenger] Autoconfigurable attributes (alirezamirsepassi)
 * feature #43593 [Validator] Add CidrValidator to allow validation of CIDR notations (popsorin)
 * feature #43683 [VarDumper] Add completion to server:dump command (alexandre-daubois)
 * feature #43677 [RateLimiter] bug #42194  fix: sliding window policy to use microtime (jlekowski)
 * feature #43679 [VarDumper] Add support for Fiber (lyrixx)
 * feature #43680 Add suggestions for the option 'format' of lints commands: twig, yaml and xliff (makraz)
 * feature #43621 Add completion for cache:pool:clear and cache:pool:delete commands (andyexeter)
 * feature #43639 [Uid] Allow use autocompletion (StaffNowa)
 * feature #43626 [Console] [Framework] Add completion to secrets:set and fix secrets:remove (GromNaN)
 * feature #43640 [Console] Add completion to messenger:setup-transports command (Tayfun74)
 * feature #43615 feat: add completion for CompletionCommand "shell" argument (dkarlovi)
 * feature #43595 [Console] `SymfonyStyle` enhancements (kbond)
 * feature #41268 [HttpFoundation] Allow setting session options via DSN (makraz)
 * feature #43596 [Console] Add completion to help & list commands (GromNaN)
 * feature #43576 [Messenger] subtract handling time from sleep time in worker (nicolas-grekas)
 * feature #43386 [DependencyInjection] Extend TaggedIterator and TaggedLocator Attributes with able to specify defaultIndexMethod for #[TaggerIterator] and #[TaggedLocator] (fractalzombie)
 * feature #42251 [Console] Bash completion integration (wouterj)
 * feature #39402 [Notifier] Add push channel to notifier (norkunas)
 * feature #43332 [Lock] Split PdoStore into DoctrineDbalStore (GromNaN)
 * feature #43362 [Cache] Split PdoAdapter into DoctrineDbalAdapter (GromNaN)
 * feature #42580 [Console][FrameworkBundle] Add DotenvDebugCommand (chr-hertel)
 * feature #43411 [HttpFoundation] Deprecate passing null as $requestIp in IpUtils (W0rma)
 * feature #43526 Add a warning in WDT when using symfony/symfony (fabpot)
 * feature #43481 [String] Add `trimSuffix()` and `trimPrefix()` methods (nicolas-grekas)
 * feature #43497 [Notifier] [Twilio] Ensure from/sender is valid via regex (OskarStark)
 * feature #43492 Lower log level in case of retry (jderusse)
 * feature #43479 [DependencyInjection] autowire union and intersection types (nicolas-grekas)
 * feature #43134 [Notifier] Add sms77 Notifier Bridge (matthiez)
 * feature #43378 [HttpFoundation] Deprecate upload_progress.* and url_rewriter.tags session options (Matthew Covey)
 * feature #42582 [Security] Add authenticators info to the profiler (chalasr)
 * feature #42723 [Messenger] Log when worker should stop and when `SIGTERM` is received (ruudk)
 * feature #40168 [Validator] Added `CssColor` constraint (welcoMattic)
 * feature #43328 [MonologBridge] Deprecate the Swiftmailer handler (fabpot)
 * feature #43322 [MonologBridge] Deprecates ResetLoggersWorkerSubscriber (lyrixx)
 * feature #43108 [HttpKernel] Add basic support for language negotiation (GregoireHebert)
 * feature #41265 [Messenger] Add a middleware to log when transaction has been left open (lyrixx)
 * feature #43280 [HttpClient] Add method to set response factory in mock client (greeflas)
 * feature #42610 [Dotenv] Reimplementing symfony/flex' dump-env as a Symfony command (abdielcs, nicolas-grekas)
 * feature #42244 [HttpKernel] Add support for configuring log level, and status code by exception class (lyrixx)
 * feature #43236 [Security] Add alias for FirewallMapInterface to `@security`.firewall.map (lyrixx)
 * feature #43150 [Finder] Add recursive .gitignore files support (julienfalque)
 * feature #41608 [Runtime] Possibility to define the env and/or debug key (maxhelias)
 * feature #42257 [Messenger] Allow using user's serializer for message do not fit the expected JSON structure (welcoMattic)
 * feature #43148 [Cache] Throw ValueError in debug mode when serialization fails (nicolas-grekas)
 * feature #43139 [Notifier] Mattermost Notifier option to post in an other channel (nathanaelmartel)
 * feature #42335 [Messenger] Add `WorkerMetadata` to `Worker` class. (okwinza)
 * feature #42712 [Serializer] Save missing arguments in MissingConstructorArgumentsException (BafS)
 * feature #43004 [Serializer] Throw NotNormalizableValueException when type is not known or not in body in discriminator map (lyrixx)
 * feature #43121 [Notifier] [GoogleChat] remove support for deprecated "threadKey" parameter (IonBazan)
 * feature #42338 [DomCrawler] Added Crawler::innerText() method (Bilge)
 * feature #43095 [Form] Add the EnumType (derrabus)
 * feature #43094 [Console] Add support of RGB functional notation (alexandre-daubois)
 * feature #43098 [Validator] Add error's uid to `Count` and `Length` constraints with "exactly" option enabled (VladGapanovich)
 * feature #42668 [Yaml] Use more concise float representation in dump (dev97)
 * feature #43017 [HttpFoundation] Map `multipart/form-data` as `form` Content-Type (keichinger)
 * feature #43015 [DependencyInjection] Allow injecting tagged iterator as service locator arguments (IonBazan)
 * feature #42991 [FrameworkBundle] Add configureContainer(), configureRoutes() and getConfigDir() to MicroKernelTrait (nicolas-grekas)
 * feature #43018 [Mailer] Adding support for TagHeader and MetadataHeader to the Sendgrid API transport (gnito-org)
 * feature #42988 [ErrorHandler] Add helper script to patch type declarations (wouterj)
 * feature #42982 Add Session Token to Amazon Mailer (Jubeki)
 * feature #42959 [DependencyInjection] Make auto-aliases private by default (nicolas-grekas)
 * feature #42957 [RateLimiter][Runtime][Translation] remove ``@experimental`` flag (nicolas-grekas)
 * feature #41163 [Mesenger] Add support for reseting container services between 2 messages (lyrixx)
 * feature #41858 [Translation] Translate translatable parameters (kylekatarnls)
 * feature #42941 Implement Message Stream for Postmark Mailer (driesvints)
 * feature #42532 [DependencyInjection] Sort services in service locator according to priority (BoShurik)
 * feature #42502 [Serializer] Add support for collecting type error during denormalization (lyrixx)
 * feature #40120 [Cache] Add CouchbaseCollectionAdapter compatibility with sdk 3.0.0 (ajcerezo)
 * feature #42965 [Cache] Deprecate support for Doctrine Cache (derrabus)
 * feature #41615 [Serializer] Add option to skip uninitialized typed properties (vuryss)
 * feature #41566 [FrameworkBundle] Introduced new method for getting bundles config path (a-menshchikov)
 * feature #42881 [Console] Add more context when CommandIsSuccessful fails (yoannrenard)
 * feature #42900 [HttpFoundation] Add a flag to hasSession to distinguished session from factory (jderusse)
 * feature #41390 [HttpKernel] Add session cookie handling in cli context (alexander-schranz, Nyholm)
 * feature #42800 Display the roles of the logged-in user in the Web Debug Toolbar (NicoHaase)
 * feature #42872 [Mime] Update mime types (fabpot)
 * feature #42039 [DependencyInjection] Autoconfigurable attributes on methods, properties and parameters (ruudk)
 * feature #42710 [Mailer] Added OhMySMTP Bridge (paul-oms)
 * feature #40987 [Config] Handle ignoreExtraKeys in config builder (HypeMC)
 * feature #42426 [Notifier] Autoconfigure chatter.transport_factory (ismail1432)
 * feature #42748 [Notifier] Add Esendex message ID to SentMessage object (benr77)
 * feature #42526 [FrameworkBundle] Add BrowserKitAssertionsTrait::assertThatForBrowser (koenreiniers)
 * feature #41527 [Ldap] Fixing the behaviour of getting LDAP Attributes (mr-sven)
 * feature #42623 [ErrorHandler] Turn return-type annotations into deprecations by default + add mode to turn them into native types (nicolas-grekas)
 * feature #42696 [Notifier] Mark Transport as final (fabpot)
 * feature #42433 [Notifier] Add more explicit error if a SMSChannel doesn't have a Recipient (ismail1432)
 * feature #42619 [Serializer] Deprecate support for returning empty, iterable, countable, raw object when normalizing (lyrixx)
 * feature #42662 [Mailer] Consume a PSR-14 event dispatcher (derrabus)
 * feature #42625 [DependencyInjection] Add service_closure() to the PHP-DSL (HypeMC)
 * feature #42650 [Security] make TokenInterface::getUser() nullable to tell about unauthenticated tokens (nicolas-grekas)
 * feature #42632 [Console] Deprecate `HelperSet::setCommand()` and `getCommand()` (derrabus)
 * feature #41994 [Validator] Add support of nested attributes (alexandre-daubois)
 * feature #42595 Fix incompatibilities with upcoming security 6.0 (wouterj)
 * feature #42578 [Security] Deprecate legacy remember me services (wouterj)
 * feature #42516 [Security] Deprecate built-in authentication entry points (wouterj)
 * feature #42387 [Form] Deprecate calling FormErrorIterator::children() if the current element is not iterable (W0rma)
 * feature #39641 [Yaml] Add --exclude and negatable --parse-tags option to lint:yaml command (christingruber)
 * feature #42510 [Security] Deprecate remaining anonymous checks (wouterj)
 * feature #42423 [Security] Deprecate AnonymousToken, non-UserInterface users, and token credentials (wouterj)
 * feature #41954 [Filesystem] Add the Path class (theofidry)
 * feature #42442 [FrameworkBundle] Deprecate AbstractController::get() and has() (fabpot)
 * feature #42422 Clarify goals of AbstractController (fabpot)
 * feature #42420 [Security] Deprecate legacy signatures (wouterj)
 * feature #41754 [SecurityBundle] Create a smooth upgrade path for security factories (wouterj)
 * feature #42198 [Security] Deprecate `PassportInterface` (chalasr)
 * feature #42332 [HttpFoundation] Add `litespeed_finish_request` to `Response` (thomas2411)
 * feature #42286 [HttpFoundation] Add `SessionFactoryInterface` (kbond)
 * feature #42392 [HttpFoundation] Mark Request::get() internal (ro0NL)
 * feature #39601 [Notifier] add `SentMessageEvent` and `FailedMessageEvent` (ismail1432)
 * feature #42188 [Notifier] Add FakeChat Logger transport (noniagriconomie)
 * feature #41522 [Notifier] Add TurboSms Bridge (fre5h)
 * feature #42337 [Validator] Remove internal from `ConstraintViolationAssertion` (jordisala1991)
 * feature #42123 [Notifier] Add FakeSMS Logger transport (noniagriconomie)
 * feature #42297 [Serializer] Add support for serializing empty array as object (lyrixx)
 * feature #42326 [Security] Deprecate remaining `LogoutHandlerInterface` implementations (chalasr)
 * feature #42219 [Mailer] Add support of ping_threshold to SesTransportFactory (Tyraelqp)
 * feature #40052 [ErrorHandler] Add button to copy the path where error is thrown (lmillucci)
 * feature #38495 [Asset] [DX] Option to make asset manifests strict on missing item (GromNaN)
 * feature #39828 [Translation] XliffLintCommand supports Github Actions annotations (YaFou)
 * feature #39826 [TwigBridge] LintCommand supports Github Actions annotations (YaFou)
 * feature #39141 [Notifier] Add Amazon SNS bridge (adrien-chinour)
 * feature #42240 [Serializer] Add support for preserving empty object in object property (lyrixx)
 * feature #42239 [Notifier] Add Yunpian Notifier Bridge (welcoMattic)
 * feature #42195 [WebProfilerBundle] Redesigned the log section (javiereguiluz)
 * feature #42163 [Messenger] [Redis] Prepare turning `delete_after_ack` to `true` in 6.0 (chalasr)
 * feature #42180 [Notifier] Add bridge for smsc.ru (kozlice)
 * feature #42137 [Finder] Make Comparator immutable (derrabus)
 * feature #42127 [ExpressionLanguage] Store compiler and evaluator as closures (derrabus)
 * feature #42094 [Notifier] [Slack] Throw error if maximum block limit is reached for slack message options (norkunas)
 * feature #42050 [Security] Deprecate `TokenInterface::isAuthenticated()` (chalasr)
 * feature #42090 [Notifier] [Slack] Include additional errors to slack notifier error message (norkunas)
 * feature #41989 [Cache] make `LockRegistry` use semaphores when possible (nicolas-grekas)
 * feature #41965 [Security] Deprecate "always authenticate" and "exception on no token" (wouterj)
 * feature #41962 add ability to style doubles and integers independently (1ma)
 * feature #40830 [Serializer] Add support of PHP backed enumerations (alexandre-daubois)
 * feature #40908 [Cache] Deprecate DoctrineProvider (derrabus)
 * feature #41717 Allow TranslatableMessage object in form option 'help' (scuben)
 * feature #41705 [Notifier] add Mailjet SMS bridge (jnadaud)
 * feature #41851 Add TesterTrait::assertCommandIsSuccessful() helper (yoannrenard)
 * feature #39623 [Messenger] Added StopWorkerException (lyrixx)
 * feature #41292 [Workflow] Add support for getting updated context after a transition (lyrixx)
 * feature #41154 [Validator] Add support for `ConstraintViolationList::createFromMessage()` (lyrixx)
 * feature #41874 [SecurityBundle] Hide security toolbar if no firewall matched (wouterj)
 * feature #41375 [Notifier] Add MessageMedia Bridge (vuphuong87)
 * feature #41923 [EventDispatcher] Deprecate configuring tags on RegisterListenersPass (derrabus)
 * feature #41802 [Uid] Add NilUlid (fancyweb)
 * feature #40738 [Notifier] Add options to Microsoft Teams notifier (OskarStark)
 * feature #41172 [Notifier] Add Telnyx notifier bridge (StaffNowa)
 * feature #41770 [HttpClient] Add default base_uri to MockHttpClient (nicolas-grekas)
 * feature #41205 [TwigBridge] Add `encore_entry_*_tags()` to UndefinedCallableHandler, as no-op (nicolas-grekas)
 * feature #41786 [FrameworkBundle] Add commented base64 version of secrets' keys (nicolas-grekas)
 * feature #41432 [WebProfilerBundle] Improved the light/dark theme switching (javiereguiluz)
 * feature #41540 [VarDumper] Add casters for Symfony UUIDs and ULIDs (fancyweb)
 * feature #41530 [FrameworkBundle] Deprecate the public `profiler` service to private (nicolas-grekas)
 * feature #41199 [FrameworkBundle] Deprecate the `AdapterInterface` autowiring alias, use `CacheItemPoolInterface` instead (nicolas-grekas)
 * feature #41203 [FrameworkBundle] Add autowiring alias for `HttpCache\StoreInterface` (nicolas-grekas)

