<?php
    use App\CentralLogics\Helpers;
    $adminRoles = \App\Models\AdminRole::where('id', auth('admin')->user()->role_id)->first()->modules;
    $adminRoles = (array)json_decode($adminRoles);
?>
<div id="sidebarMain" class="d-none">
    <aside class="js-navbar-vertical-aside navbar navbar-vertical-aside navbar-vertical navbar-vertical-fixed navbar-expand-xl navbar-bordered  ">
        <div class="navbar-vertical-container">
            <div class="navbar-brand-wrapper justify-content-between">
                <!-- Logo -->
                <?php ($store_logo = \App\Models\BusinessSetting::where(['key' => 'logo'])->first()->value); ?>
                <a class="navbar-brand" href="<?php echo e(route('admin.business-settings.business-setup')); ?>" aria-label="Front">
                    <img class="navbar-brand-logo initial--36" onerror="this.src='<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>'" src="<?php echo e(asset('storage/app/public/business/' . $store_logo)); ?>" alt="Logo">
                    <img class="navbar-brand-logo-mini initial--36" onerror="this.src='<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>'" src="<?php echo e(asset('storage/app/public/business/' . $store_logo)); ?>" alt="Logo">
                </a>
                <!-- End Logo -->
                <!-- Navbar Vertical Toggle -->
                <button type="button" class="js-navbar-vertical-aside-toggle-invoker navbar-vertical-aside-toggle btn btn-icon btn-xs btn-ghost-dark">
                    <i class="tio-clear tio-lg"></i>
                </button>
                <!-- End Navbar Vertical Toggle -->

                <div class="navbar-nav-wrap-content-left">
                    <!-- Navbar Vertical Toggle -->
                    <button type="button" class="js-navbar-vertical-aside-toggle-invoker close">
                        <i class="tio-first-page navbar-vertical-aside-toggle-short-align" data-toggle="tooltip"
                        data-placement="right" title="Collapse"></i>
                        <i class="tio-last-page navbar-vertical-aside-toggle-full-align"
                        data-template='<div class="tooltip d-none d-sm-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'></i>
                    </button>
                    <!-- End Navbar Vertical Toggle -->
                </div>
            </div>

            <!-- Content -->
            <div class="navbar-vertical-content bg--005555" id="navbar-vertical-content">
                <form class="sidebar--search-form">
                    <div class="search--form-group">
                        <button type="button" class="btn"><i class="tio-search"></i></button>
                        <input type="text" class="form-control form--control" placeholder="<?php echo e(translate('Search Menu...')); ?>" id="search-sidebar-menu">
                    </div>
                </form>
                <ul class="navbar-nav navbar-nav-lg nav-tabs">

                    <!-- Business Settings -->
                    <?php if(Helpers::checkPermission(['business_setup'/*, 'social_media'*/, 'payment_methods', 'mail_config', 'sms_system_module', 'notification_settings', 'order_cancellation_reasons'], $adminRoles)): ?>
                        <li class="nav-item">
                            <small class="nav-subtitle" title="<?php echo e(translate('messages.business')); ?> <?php echo e(translate('messages.settings')); ?>"><?php echo e(translate('messages.business')); ?>

                                <?php echo e(translate('messages.settings')); ?></small>
                            <small class="tio-more-horizontal nav-subtitle-replacer"></small>
                        </li>

                        <?php if(Helpers::checkPermission('business_setup', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/business-setup') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.business-setup')); ?>" title="<?php echo e(translate('messages.business')); ?> <?php echo e(translate('messages.setup')); ?>">
                                    <span class="tio-settings nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.business')); ?>

                                        <?php echo e(translate('messages.setup')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!--
                        <?php if(Helpers::checkPermission('social_media', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/social-media')?'active':''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.social-media.index')); ?>" title="<?php echo e(translate('messages.Social Media')); ?>">
                                    <span class="tio-facebook nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.Social Media')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        -->

                        <?php if(Helpers::checkPermission('payment_methods', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/payment-method') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.payment-method')); ?>" title="<?php echo e(translate('messages.payment')); ?> <?php echo e(translate('messages.methods')); ?>">
                                    <span class="tio-atm nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.payment')); ?>

                                        <?php echo e(translate('messages.methods')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('mail_config', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/mail-config') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.mail-config')); ?>" title="<?php echo e(translate('messages.mail')); ?> <?php echo e(translate('messages.config')); ?>">
                                    <span class="tio-email nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.mail')); ?>

                                        <?php echo e(translate('messages.config')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('sms_system_module', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/sms-module') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.sms-module')); ?>" title="<?php echo e(translate('messages.sms_system_module')); ?>">
                                    <span class="tio-message nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.sms_system_module')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('notification_settings', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/fcm-index') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.fcm-index')); ?>" title="<?php echo e(translate('messages.notification_settings')); ?>">
                                    <span class="tio-notifications nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.notification_settings')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('order_cancellation_reasons', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/order-cancel-reasons') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.order-cancel-reasons.index')); ?>" title="<?php echo e(translate('messages.order_cancellation_reasons')); ?>">
                                    <span class="tio-appointment-cancelled nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.order_cancellation_reasons')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <!-- Business Settings -->

                    <!-- Module management -->
                    <?php if(Helpers::checkPermission(['zone_setup', 'add_system_module', 'modules'], $adminRoles)): ?>
                        <li class="nav-item">
                            <small class="nav-subtitle" title="<?php echo e(translate('messages.module')); ?> <?php echo e(translate('messages.section')); ?>"><?php echo e(translate('messages.module_management')); ?></small>
                            <small class="tio-more-horizontal nav-subtitle-replacer"></small>
                        </li>

                        <?php if(Helpers::checkPermission('zone_setup', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/zone*') ? 'active' : ''); ?>">
                                <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.zone.home')); ?>" title="<?php echo e(translate('messages.zone_setup')); ?>">
                                    <i class="tio-city nav-icon"></i>
                                    <span class="navbar-vertical-aside-mini-mode-hidden-elements text-truncate">
                                        <?php echo e(translate('messages.zone_setup')); ?>

                                    </span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission(['add_system_module', 'modules'], $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/module') ? 'active' : ''); ?>">
                                <a class="js-navbar-vertical-aside-menu-link nav-link nav-link-toggle" id="tourb-3" href="javascript:" title="<?php echo e(translate('messages.system_module_setup')); ?>">
                                    <i class="tio-globe nav-icon"></i>
                                    <span class="text-truncate"><?php echo e(translate('messages.system_module_setup')); ?></span>
                                </a>
                                <ul class="js-navbar-vertical-aside-submenu nav nav-sub" style="display:<?php echo e(Request::is('admin/business-settings/module*') ? 'block' : 'none'); ?>">
                                    <?php if(Helpers::checkPermission('add_system_module', $adminRoles)): ?>
                                        <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/module/create') ? 'active' : ''); ?>">
                                            <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.module.create')); ?>" title="<?php echo e(translate('messages.add')); ?> <?php echo e(translate('messages.module')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate">
                                                    <?php echo e(translate('messages.add')); ?> <?php echo e(translate('messages.module')); ?>

                                                </span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('modules', $adminRoles)): ?>
                                        <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/module') ? 'active' : ''); ?>">
                                            <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.module.index')); ?>" title="<?php echo e(translate('messages.modules')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate">
                                                    <?php echo e(translate('messages.modules')); ?>

                                                </span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <!-- Module management -->

                    <!-- Main Banner -->
                    <?php if(Helpers::checkPermission('banner', $adminRoles)): ?>
                        <li class="nav-item">
                            <small class="nav-subtitle" title="<?php echo e(translate('messages.banner')); ?> <?php echo e(translate('messages.section')); ?>"><?php echo e(translate('messages.Main_Banner')); ?></small>
                            <small class="tio-more-horizontal nav-subtitle-replacer"></small>
                        </li>

                        <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/banner*') ? 'active' : ''); ?>">
                            <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.banner.add-new')); ?>" title="<?php echo e(translate('messages.add_new_banner')); ?>">
                                <i class="tio-image nav-icon"></i>
                                <span class="navbar-vertical-aside-mini-mode-hidden-elements text-truncate">
                            <?php echo e(translate('messages.Banner')); ?>

                         </span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <!-- End Main banner-->

                    <!-- web & app Settings -->
                    <?php if(Helpers::checkPermission(['app_settings', 'landing_page_settings', 'third_party_apis', 'react_site', 'terms_and_condition', 'privacy_policy', 'about_us', 'refund_policy', 'cancellation_policy', 'shipping_policy', 'gallery'/*, 'social_login'*/, 'recaptcha', 'clean_database'], $adminRoles)): ?>
                        <li class="nav-item">
                            <small class="nav-subtitle" title="<?php echo e(translate('messages.business')); ?> <?php echo e(translate('messages.settings')); ?>"><?php echo e(translate('messages.web_and_app')); ?>

                                <?php echo e(translate('messages.settings')); ?></small>
                            <small class="tio-more-horizontal nav-subtitle-replacer"></small>
                        </li>

                        <?php if(Helpers::checkPermission('app_settings', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/app-settings*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.app-settings')); ?>" title="<?php echo e(translate('messages.app_settings')); ?>">
                                    <span class="tio-android nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.app_settings')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('landing_page_settings', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/landing-page-settings*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.landing-page-settings', 'index')); ?>" title="<?php echo e(translate('messages.landing_page_settings')); ?>">
                                    <span class="tio-website nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.landing_page_settings')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('third_party_apis', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/config*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.config-setup')); ?>" title="<?php echo e(translate('messages.third_party_apis')); ?>">
                                    <span class="tio-key nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.third_party_apis')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('react_site', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/react*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.react-setup')); ?>"
                                   title="<?php echo e(translate('messages.react_site')); ?>">
                                    <span class="tio-rear-window-defrost nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.react_site')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission(['terms_and_condition', 'privacy_policy', 'about_us', 'refund_policy', 'cancellation_policy', 'shipping_policy'], $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/pages*') ? 'active' : ''); ?>">
                                <a class="js-navbar-vertical-aside-menu-link nav-link nav-link-toggle" href="javascript:" title="<?php echo e(translate('messages.pages')); ?> <?php echo e(translate('messages.setup')); ?>">
                                    <i class="tio-pages nav-icon"></i>
                                    <span class="navbar-vertical-aside-mini-mode-hidden-elements text-truncate"><?php echo e(translate('messages.pages')); ?>

                                        <?php echo e(translate('messages.setup')); ?></span>
                                </a>
                                <ul class="js-navbar-vertical-aside-submenu nav nav-sub"  style="display:<?php echo e(Request::is('admin/business-settings/pages*') ? 'block' : 'none'); ?>">
                                    <?php if(Helpers::checkPermission('terms_and_condition', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/terms-and-conditions') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.terms-and-conditions')); ?>" title="<?php echo e(translate('messages.terms_and_condition')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('messages.terms_and_condition')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('privacy_policy', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/privacy-policy') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.privacy-policy')); ?>" title="<?php echo e(translate('messages.privacy_policy')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('messages.privacy_policy')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('about_us', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/about-us') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.about-us')); ?>" title="<?php echo e(translate('messages.about_us')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('messages.about_us')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('refund_policy', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/refund') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.refund')); ?>" title="<?php echo e(translate('messages.Refund Policy')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('Refund Policy')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('cancellation_policy', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/cancelation') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.cancelation')); ?>" title="<?php echo e(translate('messages.Cancelation Policy')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('Cancelation Policy')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if(Helpers::checkPermission('shipping_policy', $adminRoles)): ?>
                                        <li class="nav-item <?php echo e(Request::is('admin/business-settings/pages/shipping-policy') ? 'active' : ''); ?>">
                                            <a class="nav-link " href="<?php echo e(route('admin.business-settings.shipping-policy')); ?>" title="<?php echo e(translate('messages.shipping_policy')); ?>">
                                                <span class="tio-circle nav-indicator-icon"></span>
                                                <span class="text-truncate"><?php echo e(translate('Shipping Policy')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('gallery', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/file-manager*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.file-manager.index')); ?>" title="<?php echo e(translate('messages.gallery')); ?>">
                                    <span class="tio-album nav-icon"></span>
                                    <span class="text-truncate text-capitalize"><?php echo e(translate('messages.gallery')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <!--
                        <?php if(Helpers::checkPermission('social_login', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/social-login/view')?'active':''); ?>">
                                <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.social-login.view')); ?>">
                                    <i class="tio-twitter nav-icon"></i>
                                    <span class="navbar-vertical-aside-mini-mode-hidden-elements text-truncate">
                                        <?php echo e(translate('messages.social_login')); ?>

                                    </span>
                                </a>
                            </li>
                        <?php endif; ?>
                        -->

                        <?php if(Helpers::checkPermission('recaptcha', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/recaptcha*') ? 'active' : ''); ?>">
                                <a class="nav-link " href="<?php echo e(route('admin.business-settings.recaptcha_index')); ?>" title="<?php echo e(translate('messages.reCaptcha')); ?>">
                                    <span class="tio-top-security-outlined nav-icon"></span>
                                    <span class="text-truncate"><?php echo e(translate('messages.reCaptcha')); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Helpers::checkPermission('clean_database', $adminRoles)): ?>
                            <li class="navbar-vertical-aside-has-menu <?php echo e(Request::is('admin/business-settings/db-index')?'active':''); ?>">
                                <a class="js-navbar-vertical-aside-menu-link nav-link" href="<?php echo e(route('admin.business-settings.db-index')); ?>" title="<?php echo e(translate('messages.clean_database')); ?>">
                                    <i class="tio-cloud nav-icon"></i>
                                    <span class="navbar-vertical-aside-mini-mode-hidden-elements text-truncate">
                                        <?php echo e(translate('messages.clean_database')); ?>

                                    </span>
                                </a>
                            </li>
                        <?php endif; ?>





                <?php endif; ?>
                    <!-- End web & app Settings -->
                    <li class="nav-item py-5"></li>
                    <?php echo $__env->make('layouts.admin.partials.account_navbar_dropdown', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            </div>
            <!-- End Content -->
        </div>
    </aside>
</div>

<div id="sidebarCompact" class="d-none">
</div>

<?php $__env->startPush('script_2'); ?>
<script>
    $(window).on('load' , function() {
        if($(".navbar-vertical-content li.active").length) {
            $('.navbar-vertical-content').animate({
                scrollTop: $(".navbar-vertical-content li.active").offset().top - 150
            }, 10);
        }
    });

    var $rows = $('#navbar-vertical-content li');
    $('#search-sidebar-menu').keyup(function() {
        var val = $.trim($(this).val()).replace(/ +/g, ' ').toLowerCase();

        $rows.show().filter(function() {
            var text = $(this).text().replace(/\s+/g, ' ').toLowerCase();
            return !~text.indexOf(val);
        }).hide();
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/derkxgdxcnx1/public_html/ios/resources/views/layouts/admin/partials/_sidebar_settings.blade.php ENDPATH**/ ?>