<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompanyOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('company_id')->index();
            $table->longText('customer_name');
            $table->string('customer_phone');
            $table->bigInteger('region_price_form_id');
            $table->set('delivery_charge_on', ['Customer', 'Company']);
            $table->double('items_price')->default(0);
            $table->double('total_amount')->default(0);
            $table->bigInteger('delivery_man_id')->nullable()->index();
            $table->double('total_delivery_charge')->nullable();
            $table->double('admin_commission')->nullable();
            $table->double('delivery_man_commission')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_orders');
    }
}
