<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id()->index();
            $table->string('name');
            $table->string('manager_name');
            $table->string('manager_phone');
            $table->boolean('status')->default(1);
            $table->string('email')->unique();
            $table->string('password');
            $table->string('cm_firebase_token')->nullable();
            $table->string('address')->nullable();
            $table->string('work_field')->nullable();
            $table->integer('pricing_form_id');
            $table->string('website_link')->nullable();
            $table->string('facebook_link')->nullable();
            $table->string('instagram_link')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
