<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGeneralStoresTable extends Migration
{
    public function up()
    {
        Schema::create('general_stores', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('title');
            $table->string('personal_picture');
            $table->string('cover_photo');
            $table->bigInteger('zone_id');
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('general_stores');
    }
}
