<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Scopes\ZoneScope;

class MainBanner extends Model
{
    use HasFactory;

    public $table = 'main_banners';

    protected $fillable = ['title', 'type', 'image', 'status', 'data', 'zone_id', 'featured', 'default_link'];

    protected $casts = [
        'data' => 'integer',
    ];
    public function zone()
    {
        return $this->belongsTo(Zone::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', '=', 1);
    }

    public function scopeFeatured($query)
    {
        return $query->where('featured', '=', 1);
    }

    protected static function booted()
    {
        static::addGlobalScope(new ZoneScope);
    }
}
