<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneralStoreCategory extends Model
{
    use HasFactory;
    protected $fillable = ['en_name', 'ar_name', 'image', 'module_id'];

    public function module(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Module::class);
    }
    public function scopeModule($query, $module_id)
    {
        return $query->where('module_id', $module_id);
    }
}
