<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneralStore extends Model
{
    use HasFactory;
	public $table = 'general_stores';

    protected $fillable = [
        'name',
        'title',
        'personal_picture',
        'cover_photo',
        'zone_id',
        'module_id',
        'latitude',
        'longitude',
        'is_approved',
        'menu_photo',
        'menu_updated_at',
    ];

	public function zone(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Zone::class);
    }

    public function module(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Module::class);
    }

    public function category(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(GeneralStoreCategory::class, 'general_store_category_id');
    }
}
