<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DMBouns extends Model
{
    use HasFactory;
    protected $fillable = ['delivery_man_id', 'bonus_id', 'bonus_info', 'amount', 'level'];

    public function deliveryMan(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(DeliveryMan::class, 'delivery_man_id');
    }
    public function bonus(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(DMBouns::class, 'bonus_id');
    }
}
