<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;
use App\CentralLogics\Helpers;
use App\Models\BusinessSetting;
use Brian2694\Toastr\Facades\Toastr;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        /*$this->middleware('auth');*/
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        // return redirect()->route('admin.auth.login');
        return view('home');
    }

    public function terms_and_conditions(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_terms_and_conditions');
        }else{
            $data = self::get_settings('terms_and_conditions');
        }
        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('terms-and-conditions', compact('data'));
    }

    public function about_us(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_about_us');
        }else{
            $data = self::get_settings('about_us');
        }

        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('about-us', compact('data'));
    }

    public function contact_us()
    {
        return view('contact-us');
    }

    public function send_message(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'subject' => 'required',
            'message' => 'required',
        ]);

        $contact = new Contact;
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->subject = $request->subject;
        $contact->message = $request->message;
        $contact->save();

        Toastr::success('Message sent successfully!');
        return back();
    }

    public function privacy_policy(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_privacy_policy');
        }else{
            $data = self::get_settings('privacy_policy');
        }
        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('privacy-policy', compact('data'));
    }
    public function refund(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_refund');
        }else{
            $data = self::get_settings('refund')['value'];
        }
        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('refund', compact('data'));
    }
    public function shipping_policy(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_shipping_policy');
        }else{
            $data = self::get_settings('shipping_policy')['value'];
        }
        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('shipping-policy', compact('data'));
    }
    public function cancelation(Request $request)
    {
        if(app()->getLocale() == 'en' && !$request->expectsJson()){
            $data = self::get_settings('en_cancelation');
        }else{
            $data = self::get_settings('cancelation')['value'];
        }
        if ($request->expectsJson()) {
            return response()->json($data);
        }
        return view('cancelation', compact('data'));
    }

    public static function get_settings($name)
    {
        $config = null;
        $data = BusinessSetting::where(['key' => $name])->first();
        if (isset($data)) {
            $config = json_decode($data['value'], true);
            if (is_null($config)) {
                $config = $data['value'];
            }
        }
        return $config;
    }

    public function lang($local)
    {
        $direction = BusinessSetting::where('key', 'site_direction')->first();
        $direction = $direction->value ?? 'ltr';
        $language = BusinessSetting::where('key', 'system_language')->first();
        foreach (json_decode($language['value'], true) as $key => $data) {
            if ($data['code'] == $local) {
                $direction = isset($data['direction']) ? $data['direction'] : 'ltr';
            }
        }
        session()->forget('landing_language_settings');
        Helpers::landing_language_load();
        session()->put('landing_site_direction', $direction);
        session()->put('landing_local', $local);
        return redirect()->back();
    }
}
