<?php

namespace App\Http\Controllers\Api\V1;

use App\Models\Campaign;
use App\Models\Version;
use App\CentralLogics\BannerLogic;
use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class VersionController extends Controller
{
    public function index(Request $request)
    {
        $version = Version::where('system', $request->system)
            ->where('number', $request->version)
            ->where('app_type', $request->app)
            ->first();

        $is_live = true;
        $required = 2;

        if($version)
        {
            $is_live = $version->is_reviewing == 0;
            $required = $version->required??$required;
        }

        $data = [
            'required' => (string)$required,
            'is_live' => $is_live,
            'base_url' => $is_live?'https://postajji.com':'https://postajji.com/ios',
            'app_apple_store_link' => 'https://apps.apple.com/app/id6475656422',
            'app_google_store_link' => 'https://play.google.com/store/apps/details?id=com.syweb.postajji'
        ];

        return response()->json($data, 200);
    }
}
