<?php

namespace App\Http\Controllers\Api\V1;

use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use App\Models\Item;
use App\Models\Offer;
use App\Models\OfferStore;
use App\Models\Store;
use Illuminate\Http\Request;

class OfferController extends Controller
{
    public function index(Request $request): \Illuminate\Http\JsonResponse
    {
        $offers = Offer::query();

        if (isset($request->module_id)) {

            $storeQuery = Store::query();

            // إذا فيه category_id مضاف في الفلتر
            if (isset($request->category_id) && $request->category_id != '0') {

                $category_id = $request->category_id;

                // نجيب المتاجر اللي عندها منتجات في الكاتيجوري المحدد
                $storeQuery = $storeQuery->whereIn('id', Item::select('store_id')->active()
                    ->whereHas('category', function ($q) use ($category_id) {
                        $q->where('id', $category_id)
                            ->orWhere('parent_id', $category_id);
                    })
                );
            }

            // نكمل فلترة المتاجر بناءً على الموديول
            $storeQuery = $storeQuery->where('module_id', $request->module_id);

            // نستخرج الـ store IDs
            $storeIds = $storeQuery->pluck('id');

            // نجيب العروض بناءً على المتاجر اللي طلعناها
            $offerIds = OfferStore::whereIn('store_id', $storeIds)->pluck('offer_id');

            // نفلتر العروض النهائية
            $offers = $offers->whereIn('id', $offerIds);
        }

// العروض النشطة
        $offers = $offers->where('status', 1)
            ->orderBy('id', 'ASC')
            ->get();

        return response()->json($offers, 200);
    }

    public function stores(Request $request): \Illuminate\Http\JsonResponse
    {
        // 1. نجيب store_id من OfferStore
        $offerStoreIds = OfferStore::where('offer_id', $request->offer_id)->pluck('store_id');

// 2. نجهز استعلام Stores بناءً على store_ids
        $longitude= $request->header('longitude');
        $latitude= $request->header('latitude');
        $storesQuery = Store::withOpen($longitude,$latitude)->whereIn('id', $offerStoreIds)->active();

// 3. فلترة module_id إذا موجود
        if (isset($request->module_id)) {
            $storesQuery->where('module_id', $request->module_id);
        }

// 4. فلترة category_id إذا موجود
        if (isset($request->category_id) && $request->category_id != '0') {

            $category_id = $request->category_id;

            // نجيب المتاجر اللي عندها منتجات مرتبطة بالكاتيجوري المطلوب
            $storesQuery->whereIn('id', Item::select('store_id')->active()
                ->whereHas('category', function ($q) use ($category_id) {
                    $q->where('id', $category_id)
                        ->orWhere('parent_id', $category_id);
                })
            );
        }

// 5. جلب المتاجر النهائية دفعة وحدة
        $stores = $storesQuery->get();

        $stores = Helpers::store_data_formatting($stores, true);

        return response()->json($stores, 200);
    }
}
