<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\Module;
use App\Models\Zone;
use Illuminate\Http\Request;


class ModuleController extends Controller
{

    public function index(Request $request)
    {
        // استعلام الأساس (نضيف withCount('stores') لجلب عدد المتاجر مباشرة)
        if ($request->hasHeader('zoneId')) {
            $zone_id = $request->header('zoneId');
            $modulesQuery = Module::whereHas('zones', function($query) use ($zone_id) {
                $query->whereIn('zone_id', json_decode($zone_id, true));
            })->active();
        } else {
            $modulesQuery = Module::when($request->zone_id, function($query) use ($request) {
                $query->whereHas('zones', function($query) use ($request) {
                    $query->where('zone_id', $request->zone_id);
                })->notParcel();
            })->active();
        }

        // جلب الموديولات مع عدد المتاجر (stores_count)
        $modules = $modulesQuery->withCount('stores')->get();

        // دالة مساعدة لتقريب الأرقام إلى أرقام "جميلة" من الشكل {1,2,5} * 10^k
        $niceRoundUp = function(int $n) {
            if ($n <= 0) return 0;
            // حساب المرتبة
            $exp = (int) floor(log10($n));
            $base = (int) pow(10, $exp);

            $candidates = [
                1 * $base,
                2 * $base,
                5 * $base,
                10 * $base, // يغطي الانتقال إلى الرتبة التالية
            ];

            foreach ($candidates as $cand) {
                if ($cand >= $n) return $cand;
            }
            // في حالة نادرة، نرجع 10^($exp+1)
            return (int) pow(10, $exp + 1);
        };

        // تحويل للـ array وإضافة الحقول المطلوبة
        $modules = array_map(function($item) use ($niceRoundUp) {
            // ترجمة الحقول كما عندك
            if (count($item['translations']) > 0) {
                foreach ($item['translations'] as $translation) {
                    if ($translation['key'] == 'module_name') {
                        $item['module_name'] = $translation['value'];
                    }
                    if ($translation['key'] == 'description') {
                        $item['description'] = $translation['value'];
                    }
                }
            }

            // stores_count جاي من withCount => key 'stores_count'
            $storesCount = isset($item['stores_count']) ? (int) $item['stores_count'] : 0;

            // حقل جديد بالرقم الحقيقي
            $item['stores_count'] = $storesCount;

            // حقل للتقريب بالـ plus sign
            $approx = $niceRoundUp($storesCount);
            // بالنسبة للقيمة الصفرية نعرض "0" أو "+0" حسب تفضيلك — هون نعرض "0" بدون +
            $item['stores_count_approx'] = $storesCount > 0 ? ('+' . number_format($approx)) : '0';

            return $item;
        }, $modules->toArray());

        return response()->json($modules);
    }
    
}
