<?php

namespace App\Http\Controllers\Api\V1;

use App\Models\Campaign;
use App\CentralLogics\MainBannerLogic;
use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MainBannerController extends Controller
{
    public function get_banners(Request $request)
    {
        if (!$request->hasHeader('zoneId')) {
            $errors = [];
            $errors[] = ['code' => 'zoneId', 'message' => translate('messages.zone_id_required')];
            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $zone_id= $request->header('zoneId');
        $banners = MainBannerLogic::get_banners($zone_id, $request->query('featured'));
        $campaigns = [];
        if(!$request->featured)
        {
            $campaigns = Campaign::
            whereHas('stores', function($q)use($zone_id){
                $q->whereIn('zone_id', json_decode($zone_id, true));
            })
            ->running()->active()->get();
        }

        try {
            return response()->json(['campaigns'=>Helpers::basic_campaign_data_formatting($campaigns, true),'banners'=>$banners], 200);
        } catch (\Exception $e) {
            return response()->json([], 200);
        }
    }
}
