<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\DeliveryMan;
use App\Models\DeliveryManWarning;
use Illuminate\Http\Request;

class DeliveryManWarningController extends Controller
{
    public function index(Request $request): \Illuminate\Http\JsonResponse
    {
        if(!isset($request->token)){
            return response()->json([
                'errors' => [
                    ['code' => 'token', 'message' => 'token is required!']
                ]
            ], 401);
        }
        $deliveryMan = DeliveryMan::where(['auth_token' => $request->token])->first();
        $warnings = DeliveryManWarning::where('delivery_man_id', $deliveryMan->id)->orderBy('id', 'ASC')->get();
        return response()->json($warnings, 200);
    }
}
