<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\DeliveryMan;
use App\Models\DMLog;
use Illuminate\Http\Request;

class DMLogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request): \Illuminate\Http\JsonResponse
    {
        $dm = DeliveryMan::where(['auth_token' => $request['token']])->first();
        $limit = $request['limit'] ?? 10;
        $offset = $request['offset'] ?? 1;

        $DMLogs = DMLog::where('delivery_man_id', $dm->id)->orderBy('id', 'DESC')->paginate($limit, ['*'], 'page', $offset);

        $data = [
            'total_size' => $DMLogs->total(),
            'limit' => $limit,
            'offset' => $offset,
            'logs' => $DMLogs,
        ];
        return response()->json($data, 200);
    }
}
