<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\CustomerReview;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CustomerReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $userId = $request->user_id;
        $limit = $request['limit'] ?? 10;
        $offset = $request['offset'] ?? 1;

        $allReviews = CustomerReview::where('user_id', $userId)->where('status', 1)->orderBy('id', 'DESC')->paginate($limit, ['*'], 'page', $offset);

        foreach ($allReviews as $review){
            //Delivery man
            $DmImage = $review->deliveryMan->image;
            if($DmImage == null or empty($DmImage)){
                $review->deliveryMan->image = 'https://postajji.com/storage/app/public/profile/avatar.png';
            }else{
                $review->deliveryMan->image = 'https://postajji.com/storage/app/public/delivery-man/'.$DmImage;
            }
            $review['delivery_man'] = $review->deliveryMan;
        }

        $reviews = CustomerReview::select(DB::raw('COUNT(id) AS count_of_ratings'), DB::raw('SUM(rating) AS sum_of_ratings'))->where('user_id', $userId)->where('status', 1)->first();

        $avg_ratings = $reviews->count_of_ratings > 0 ? ($reviews->sum_of_ratings / $reviews->count_of_ratings) : 0.1;
        if(is_int($avg_ratings)){
            $avg_ratings = (double)($avg_ratings . '.1');
        }
        $data = [
            'count' => $reviews->count_of_ratings,
            'avg_ratings' => $avg_ratings,
            'reviews' => $allReviews,
        ];

        return response()->json($data, 200);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $deliveryManId = $request->delivery_man_id;
        $userId = $request->user_id;
        $comment = $request->comment;
        $rating = $request->rating;
        $orderId = $request->order_id ?? null;
        CustomerReview::create([
            'delivery_man_id' => $deliveryManId,
            'user_id' => $userId,
            'comment' => $comment,
            'rating' => $rating,
            'order_id' => $orderId,
            'status' => 1,
        ]);

        return response()->json(['message' => translate('messages.thank_you_for_the_review')], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\CustomerReview  $customerReview
     * @return \Illuminate\Http\Response
     */
    public function show(CustomerReview $customerReview)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\CustomerReview  $customerReview
     * @return \Illuminate\Http\Response
     */
    public function edit(CustomerReview $customerReview)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\CustomerReview  $customerReview
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CustomerReview $customerReview)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\CustomerReview  $customerReview
     * @return \Illuminate\Http\Response
     */
    public function destroy(CustomerReview $customerReview)
    {
        //
    }
}
