<?php

namespace App\Http\Controllers\Api\V1;

use App\CentralLogics\Helpers;
use App\CentralLogics\CouponLogic;
use App\Http\Controllers\Controller;
use App\Models\Coupon;
use App\Models\Order;
use App\Models\Store;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class CouponController extends Controller
{
    public function list(Request $request)
    {
        if (!$request->hasHeader('zoneId')) {
            $errors = [];
            array_push($errors, ['code' => 'zoneId', 'message' => translate('messages.zone_id_required')]);
            return response()->json([
                'errors' => $errors
            ], 403);
        }
        $customer_id = Auth::user()->id;
        $zone_id = $request->header('zoneId');
        $data = [];
        // try {
            $coupons = Coupon::with('store:id,name,latitude,longitude,zone_id')->active()
            //->when(config('module.current_module_data'), function($query){
            //    $query->module(config('module.current_module_data')['id']);
            //})
                ->where('view_in_coupons_list', 1)
            ->whereDate('expire_date', '>=', date('Y-m-d'))->whereDate('start_date', '<=', date('Y-m-d'))->get();
            foreach($coupons as $key=>$coupon)
            {

                if((in_array("all", json_decode($coupon->customer_id, true)) || in_array($customer_id,json_decode($coupon->customer_id, true))) ){
                    if(!empty($request->store_id) and $request->store_id != null){
                        if(config('module.current_module_data')){
                            $module_id = config('module.current_module_data')['id'];
                            $moduleIds = json_decode($coupon->module_ids);
                            if(isset($module_id) && ($coupon->module_id == $module_id or (is_array($moduleIds) and (in_array($module_id, $moduleIds) or in_array('all', $moduleIds)))))
                            {
                                $storeIds = json_decode($coupon->store_ids);
                                if($request->store_id == $coupon->store_id or (is_array($storeIds) and (in_array("all", $storeIds) or in_array($request->store_id, $storeIds)))){
                                    $coupon['store_ids'] = json_decode($coupon['store_ids']);
                                    $coupon['module_ids'] = json_decode($coupon['module_ids']);
                                    $data[] = $coupon;
                                }
                            }
                        }else{
                            $storeIds = json_decode($coupon->store_ids);
                            if($request->store_id == $coupon->store_id or (is_array($storeIds) and (in_array("all", $storeIds) or in_array($request->store_id, $storeIds)))){
                                $coupon['store_ids'] = json_decode($coupon['store_ids']);
                                $coupon['module_ids'] = json_decode($coupon['module_ids']);
                                $data[] = $coupon;
                            }
                        }
                    }else{
                        $coupon['store_ids'] = json_decode($coupon['store_ids']);
                        $coupon['module_ids'] = json_decode($coupon['module_ids']);
                        $data[] = $coupon;
                    }
                }
                //if($coupon->coupon_type == 'store_wise')
                //{
                //    $temp = Store::active()
                //    //->when(config('module.current_module_data'), function($query)use($zone_id){
                //    //    if(!config('module.current_module_data')['all_zone_service']) {
                //    //        $query->whereIn('zone_id', json_decode($zone_id, true));
                //    //    }
                //    //})
                //    ->whereIn('id', json_decode($coupon->data, true))->first();
                //    if($temp && (in_array("all", json_decode($coupon->customer_id, true)) || in_array($customer_id,json_decode($coupon->customer_id, true))))
                //    {
                //        $coupon->data = $temp->name;
                //        $data[] = $coupon;
                //    }
                //}
                //else if($coupon->coupon_type == 'zone_wise')
                //{
                //    if(count(array_intersect(json_decode($zone_id, true), json_decode($coupon->data,true))))
                //    {
                //        $data[] = $coupon;
                //    }
                //}
                //else{
                //    if((in_array("all", json_decode($coupon->customer_id, true)) || in_array($customer_id,json_decode($coupon->customer_id, true))) ){
                //        $data[] = $coupon;
                //    }
                //}
            }

            return response()->json($data, 200);
        // } catch (\Exception $e) {
        //     return response()->json(['errors' => $e], 403);
        // }
    }

    public function apply(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'code' => 'required',
            'store_id' => 'required',
        ]);

        if ($validator->errors()->count()>0) {
            return response()->json(['errors' => Helpers::error_processor($validator)], 403);
        }

        try {
            $coupon = Coupon::active()->where(['code' => $request['code']])->first();
            if (isset($coupon)) {
                $staus = CouponLogic::is_valide($coupon, $request->user()->id ,$request['store_id']);

                switch ($staus) {
                case 200:
                    return response()->json($coupon, 200);
                case 406:
                    return response()->json([
                        'errors' => [
                            ['code' => 'coupon', 'message' => translate('messages.coupon_usage_limit_over')]
                        ]
                    ], 406);
                case 407:
                    return response()->json([
                        'errors' => [
                            ['code' => 'coupon', 'message' => translate('messages.coupon_expire')]
                        ]
                    ], 407);
                case 408:
                    return response()->json([
                        'errors' => [
                            ['code' => 'coupon', 'message' => translate('messages.You_are_not_eligible_for_this_coupon')]
                        ]
                    ], 403);
                case 405:
                    return response()->json([
                        'errors' => [
                            ['code' => 'coupon', 'message' => translate('messages.coupon_used_from_another_user')]
                        ]
                    ], 403);
                default:
                    return response()->json([
                        'errors' => [
                            ['code' => 'coupon', 'message' => translate('messages.not_found')]
                        ]
                    ], 404);
                }
            } else {
                return response()->json([
                    'errors' => [
                        ['code' => 'coupon', 'message' => translate('messages.not_found')]
                    ]
                ], 404);
            }
        } catch (\Exception $e) {
            return response()->json(['errors' => $e], 403);
        }
    }
}
