<?php

namespace App\Http\Controllers\Admin;

use App\CentralLogics\Helpers;
use App\Models\Offer;
use App\Models\OfferStore;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;

class OfferController extends Controller
{
    public function create()
    {
        $offers = Offer::latest()->paginate(config('default_pagination'));
        return view('admin-views.offers.index', compact('offers'));
    }

    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'en_name' => 'required',
            'ar_name' => 'required',
            'status' => 'required',
            'en_image' => 'required',
            'ar_image' => 'required',
        ]);

        $enImage = Helpers::upload('offers/', $request->file('en_image')->guessExtension(), $request->file('en_image'));
        $arImage = Helpers::upload('offers/', $request->file('ar_image')->guessExtension(), $request->file('ar_image'));

        $offer = Offer::create([
            'en_name' => $request->en_name,
            'ar_name' => $request->ar_name,
            'status' => $request->status,
            'en_image' => $enImage,
            'ar_image' => $arImage,
        ]);

        if(isset($request->store_ids)){
            for($i = 0; $i < count($request->store_ids); $i++){
                if(!empty($request->store_ids[$i])){
                    OfferStore::create([
                        'store_id' => $request->store_ids[$i],
                        'offer_id' => $offer->id,
                    ]);
                }
            }
        }

        Toastr::success(translate('messages.offer_added_successfully'));
        return back();
    }

    public function edit($id)
    {
        $offer = Offer::where(['id' => $id])->first();
        return view('admin-views.offers.edit', compact('offer'));
    }

    public function update(Request $request, $id): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'en_name' => 'required',
            'ar_name' => 'required',
        ]);

        $offerInfo = Offer::where('id', $id)->first();

        $enImage = !empty($request->en_image) ? Helpers::upload('offers/', $request->file('en_image')->guessExtension(), $request->file('en_image')) : $offerInfo->en_image;
        $arImage = !empty($request->ar_image) ? Helpers::upload('offers/', $request->file('ar_image')->guessExtension(), $request->file('ar_image')) : $offerInfo->ar_image;

        Offer::where(['id' => $id])->update([
            'en_name' => $request->en_name,
            'ar_name' => $request->ar_name,
            'en_image' => $enImage,
            'ar_image' => $arImage,
        ]);

        OfferStore::where('offer_id', $id)->delete();

        if(isset($request->store_ids)){
            for($i = 0; $i < count($request->store_ids); $i++){
                if(!empty($request->store_ids[$i])){
                    OfferStore::create([
                        'store_id' => $request->store_ids[$i],
                        'offer_id' => $id,
                    ]);
                }
            }
        }

        Toastr::success(translate('messages.offer_updated_successfully'));
        return back();
    }

    public function status(Request $request)
    {
        $offer = Offer::find($request->id);
        $offer->status = $request->status;
        $offer->save();
        Toastr::success(translate('messages.offer_status_updated'));
        return back();
    }

    public function delete(Request $request)
    {
        $offer = Offer::find($request->id);
        $offer->delete();
        OfferStore::where('offer_id', $request->id)->delete();
        Toastr::success('تم الحذف');
        return back();
    }
}
