<?php

namespace App\Http\Controllers\Admin;

use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use App\Models\GeneralStoreCategory;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;

class GeneralStoreCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function index()
    {
        $categories = GeneralStoreCategory::with('module')->latest()->paginate(config('default_pagination'));
        return view('admin-views.general-store-category.index',compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'en_name' => 'required|max:100',
            'ar_name' => 'required|max:100',
        ], [
            'en_name.required' => translate('messages.(EN) Name is required!'),
            'ar_name.required' => translate('messages.(AR) Name is required!'),
        ]);

        $category = new GeneralStoreCategory;
        $category->en_name = $request->en_name;
        $category->ar_name = $request->ar_name;
        $category->image = Helpers::upload('category/', $request->file('image')->guessExtension(), $request->file('image'));
        $category->module_id = $request->module_id;
        $category->save();

        Toastr::success(translate('messages.category_added_successfully'));
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\GeneralStoreCategory  $generalStoreCategory
     * @return \Illuminate\Http\Response
     */
    public function show(GeneralStoreCategory $generalStoreCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\GeneralStoreCategory  $generalStoreCategory
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function edit(GeneralStoreCategory $generalStoreCategory)
    {
        $category = GeneralStoreCategory::findOrFail($generalStoreCategory->id);
        return view('admin-views.general-store-category.index', compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\GeneralStoreCategory  $generalStoreCategory
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, GeneralStoreCategory $generalStoreCategory): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'en_name' => 'required|max:100',
            'ar_name' => 'required|max:100',
        ], [
            'en_name.required' => translate('messages.(EN) Name is required!'),
            'ar_name.required' => translate('messages.(AR) Name is required!'),
        ]);

        $generalStoreCategory->en_name = $request->en_name;
        $generalStoreCategory->ar_name = $request->ar_name;
        $generalStoreCategory->image = $request->has('image') ? Helpers::upload('category/', $request->file('image')->guessExtension(), $request->file('image')) : $generalStoreCategory->image;
        $generalStoreCategory->module_id = $request->module_id;
        $generalStoreCategory->save();
        Toastr::success(translate('messages.category_updated_successfully'));
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\GeneralStoreCategory  $generalStoreCategory
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(GeneralStoreCategory $generalStoreCategory): \Illuminate\Http\RedirectResponse
    {
        $generalStoreCategory->delete();
        Toastr::success('Category removed!');
        return back();
    }
}
