<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DeliveryManWarning;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class DeliveryManWarningController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        $deliveryManId = $request->delivery_man_id;
        $warning = $request->warning;
        if(!empty($warning)){
            $deliveryManWarning = new DeliveryManWarning;
            $deliveryManWarning->createWarning($deliveryManId, $warning);
        }
        Toastr::success('تم توجيه الإنذار للمندوب!');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\DeliveryManWarning  $deliveryManWarning
     * @return \Illuminate\Http\Response
     */
    public function show(DeliveryManWarning $deliveryManWarning)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DeliveryManWarning  $deliveryManWarning
     * @return \Illuminate\Http\Response
     */
    public function edit(DeliveryManWarning $deliveryManWarning)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\DeliveryManWarning  $deliveryManWarning
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DeliveryManWarning $deliveryManWarning)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\DeliveryManWarning  $deliveryManWarning
     * @return \Illuminate\Http\Response
     */
    public function destroy(DeliveryManWarning $deliveryManWarning)
    {
        //
    }
}
