<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DeliveryManBoost;
use App\Models\DMBoost;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;
class DeliveryManBoostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function add_new()
    {
        $deliveryManBoosts = DeliveryManBoost::latest()->paginate(config('default_pagination'));
        return view('admin-views.delivery_man_boosts.index', compact('deliveryManBoosts'));
    }
    public function all()
    {
        $deliveryManBoosts = DeliveryManBoost::latest()->paginate(config('default_pagination'));
        return view('admin-views.delivery_man_boosts.index', compact('deliveryManBoosts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        //Validate date
        $checkDates = DeliveryManBoost::whereBetween('start_at', [$request->start_at, $request->end_at])->orWhereBetween('end_at', [$request->start_at, $request->end_at])->first();
        if($checkDates){
            Toastr::error(translate('messages.there_is_a_boost_in_this_dates'));
            return back();
        }

        //Store
        DeliveryManBoost::create([
            'start_at' => $request->start_at,
            'end_at' => $request->end_at,
            'duration_by_hours' => $request->duration_by_hours,
            'max_number_of_orders' => $request->max_number_of_orders,
            'amount_percentage' => $request->amount_percentage,
            'max_amount' => $request->max_amount,
        ]);
        Toastr::success(translate('messages.added_successfully'));
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\DeliveryManBoost  $deliveryManBoost
     * @return \Illuminate\Http\Response
     */
    public function show(DeliveryManBoost $deliveryManBoost)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DeliveryManBoost  $deliveryManBoost
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function edit(DeliveryManBoost $deliveryManBoost)
    {
        return view('admin-views.delivery_man_boosts.edit', compact('deliveryManBoost'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\DeliveryManBoost  $deliveryManBoost
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, DeliveryManBoost $deliveryManBoost): \Illuminate\Http\RedirectResponse
    {
        //Validate date
        $checkDates = DeliveryManBoost::where(function($q) use($request){
            $q = $q->whereBetween('start_at', [$request->start_at, $request->end_at])->orWhereBetween('end_at', [$request->start_at, $request->end_at]);
        })->where('id', '!=', $deliveryManBoost->id)->first();
        if($checkDates){
            Toastr::error(translate('messages.there_is_a_boost_in_this_dates'));
            return back();
        }

        //Update
        DeliveryManBoost::where('id', $deliveryManBoost->id)->update([
            'start_at' => $request->start_at,
            'end_at' => $request->end_at,
            'duration_by_hours' => $request->duration_by_hours,
            'max_number_of_orders' => $request->max_number_of_orders,
            'amount_percentage' => $request->amount_percentage,
            'max_amount' => $request->max_amount,
        ]);

        DMBoost::where('boost_id', $deliveryManBoost->id)->update([
            'boost_info' => DeliveryManBoost::where('id', $deliveryManBoost->id)->first(),
        ]);
        Toastr::success(translate('messages.saved_successfully'));
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\DeliveryManBoost  $deliveryManBoost
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(DeliveryManBoost $deliveryManBoost): \Illuminate\Http\RedirectResponse
    {
        $deliveryManBoost->delete();
        return back();
    }
}
