<?php

namespace App\Http\Controllers\Admin;

use App\CentralLogics\Helpers;
use App\Http\Controllers\Controller;
use App\Models\DeliveryManBonus;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class DeliveryManBonusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function add_new()
    {
        $deliveryManBonuses = DeliveryManBonus::latest()->paginate(config('default_pagination'));
        return view('admin-views.delivery_man_bonuses.index', compact('deliveryManBonuses'));
    }
    public function all()
    {
        $deliveryManBonuses = DeliveryManBonus::latest()->paginate(config('default_pagination'));
        return view('admin-views.delivery_man_bonuses.index', compact('deliveryManBonuses'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        //Validate date
        $checkDates = DeliveryManBonus::whereBetween('from_date', [$request->from_date, $request->to_date])->orWhereBetween('to_date', [$request->from_date, $request->to_date])->first();
        if($checkDates){
            Toastr::error(translate('messages.there_is_a_bonus_in_this_dates'));
            return back();
        }

        $levels = [];

        if(isset($request->orders_count)) {
            for ($i = 0; $i < count($request->orders_count); $i++) {
                $orders_count = $request->orders_count[$i];
                $amount = $request->amount[$i] ?? 0;
                $gift_title = $request->gift_title[$i] ?? '';
                if(!empty($request->file('gift_picture')[$i])) {
                    $gift_picture = Helpers::upload('gifts/', $request->file('gift_picture')[$i]->guessExtension(), $request->file('gift_picture')[$i]) ?? '';
                }else{
                    $gift_picture = '';
                }
                if (!empty($orders_count)) {
                    $levels[] = [
                        'orders_count' => $orders_count,
                        'amount' => $amount,
                        'gift_title' => $gift_title,
                        'gift_picture' => $gift_picture,
                    ];
                }
            }
        }

        //Store
        DeliveryManBonus::create([
            'from_date' => $request->from_date,
            'to_date' => $request->to_date,
            //'amount' => $request->amount,
            //'period_in_hours' => $request->period_in_hours,
            //'orders_count' => $request->orders_count,
            //'is_can_repeat' => $request->is_can_repeat,
            'levels' => json_encode($levels),
        ]);
        Toastr::success(translate('messages.added_successfully'));
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\DeliveryManBonus  $deliveryManBonus
     * @return \Illuminate\Http\Response
     */
    public function show(DeliveryManBonus $deliveryManBonus)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\DeliveryManBonus  $deliveryManBonus
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View|\Illuminate\Http\Response
     */
    public function edit(DeliveryManBonus $deliveryManBonus)
    {
        return view('admin-views.delivery_man_bonuses.edit', compact('deliveryManBonus'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\DeliveryManBonus  $deliveryManBonus
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, DeliveryManBonus $deliveryManBonus): \Illuminate\Http\RedirectResponse
    {
        //Validate date
        $checkDates = DeliveryManBonus::where(function($q) use($request){
            $q = $q->whereBetween('from_date', [$request->from_date, $request->to_date])->orWhereBetween('to_date', [$request->from_date, $request->to_date]);
        })->where('id', '!=', $deliveryManBonus->id)->first();
        if($checkDates){
            Toastr::error(translate('messages.there_is_a_bonus_in_this_dates'));
            return back();
        }

        $levels = [];

        if(isset($request->orders_count)) {
            for ($i = 0; $i < count($request->orders_count); $i++) {
                $orders_count = $request->orders_count[$i];
                $amount = $request->amount[$i] ?? 0;
                $gift_title = $request->gift_title[$i] ?? '';
                if(!empty($request->file('gift_picture')[$i])) {
                    $gift_picture = Helpers::upload('gifts/', $request->file('gift_picture')[$i]->guessExtension(), $request->file('gift_picture')[$i]) ?? '';
                }else if(!empty($request->gift_picture_old[$i])){
                    $gift_picture = $request->gift_picture_old[$i];
                }else{
                    $gift_picture = '';
                }
                if (!empty($orders_count)) {
                    $levels[] = [
                        'orders_count' => $orders_count,
                        'amount' => $amount,
                        'gift_title' => $gift_title,
                        'gift_picture' => $gift_picture,
                    ];
                }
            }
        }

        //Update
        DeliveryManBonus::where('id', $deliveryManBonus->id)->update([
            'from_date' => $request->from_date,
            'to_date' => $request->to_date,
            //'amount' => $request->amount,
            //'period_in_hours' => $request->period_in_hours,
            //'orders_count' => $request->orders_count,
            //'is_can_repeat' => $request->is_can_repeat,
            'levels' => json_encode($levels),
        ]);
        Toastr::success(translate('messages.added_successfully'));
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\DeliveryManBonus  $deliveryManBonus
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy(DeliveryManBonus $deliveryManBonus): \Illuminate\Http\RedirectResponse
    {
        $deliveryManBonus->delete();
        return back();
    }
}
