<?php

namespace App\CentralLogics;

use App\Models\BusinessSetting;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Nexmo\Laravel\Facade\Nexmo;
use Twilio\Rest\Client;

class SMS_module
{
    public static $MTN = [
        "API" => "http://postajji.sy/t.php?",
        "USER" => "ija520",
        "PASS" => "tso151210",
        "FROM" => "Postajji",
        "CODE" => "Code=Sec!@123",
        "LANG" => 0
    ];

    public static function send($receiver, $otp): string
    {
        self::whatsApp($receiver, 'رمز التحقق الخاص بك للدخول الى تطبيق بوسطجي هو: ' . $otp);
        return self::mtn($receiver, $otp);

        /*
        $config = self::get_settings('twilio_sms');
        if (isset($config) && $config['status'] == 1) {
            $response = self::twilio($receiver, $otp);
            return $response;
        }

        $config = self::get_settings('nexmo_sms');
        if (isset($config) && $config['status'] == 1) {
            $response = self::nexmo($receiver, $otp);
            return $response;
        }

        $config = self::get_settings('2factor_sms');
        if (isset($config) && $config['status'] == 1) {
            $response = self::two_factor($receiver, $otp);
            return $response;
        }

        $config = self::get_settings('msg91_sms');
        if (isset($config) && $config['status'] == 1) {
            $response = self::msg_91($receiver, $otp);
            return $response;
        }

        return 'not_found';
        */
    }

    public static function whatsApp($receiver, $message): string
    {
        $INSTANCE_ID = 'instance134256';
        $TOKEN = 'ye8bsg50odkk24ed';

        $receiver = SMS_module::fixWhatsAppNumber($receiver);

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.ultramsg.com/". $INSTANCE_ID ."/messages/chat",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "token=". $TOKEN ."&to=". $receiver ."&body=". $message ."&priority=10&referenceId=",
            CURLOPT_HTTPHEADER => array(
                "content-type: application/x-www-form-urlencoded"
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        return 'success';
    }

    public static function fixWhatsAppNumber($number): string
    {
        if ($number[0] === "+") {
            $number = substr($number, 1);
        }

        if ($number[0] === "0") {
            $number = substr($number, 1);
        }

        if(strlen($number) == 9){
            $number = '963' . $number;
        }

        return '+' . $number;
    }

    public static function mtn__OLD($receiver, $message){

        if ($receiver[0] === "+") {
            $receiver = substr($receiver, 1);
        }

        $MTN = [
            "API" => "https://services.mtnsyr.com:7443/general/MTNSERVICES/ConcatenatedSender.aspx/?",
            "USER" => "ija520",
            "PASS" => "tso151210",
            "FROM" => "Postajji",
            "CODE" => "Sec!@123",
            "LANG" => 1
        ];

        $response = Http::withOptions(['verify' => false])->get($MTN['API'], [
            "USER" => "ija520",
            "PASS" => "tso151210",
            "FROM" => "Postajji",
            "CODE" => "Sec!@123",
            "LANG" => 1,
            "Gsm" => $receiver,
            "Msg" => "OTP: " . $message
        ]);

        return 'success';

        if ($response->successful()) {
            return 'success';
        }else{
            return 'error';
        }

        /*
        $url = $baseURL . '?' . http_build_query([
            'to' => $to,
            'msg' => $message,
        ]);

        $context = stream_context_create([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
            ],
        ]);

        // Open the URL for reading with the stream context
        $handle = fopen($url, 'r');

        // Check if the handle was opened successfully
        if ($handle === false) {
            $response = 'error';
        } else {
            // Read the response content
            $response = stream_get_contents($handle);

            // Check if the request was successful
            if ($response === false) {
                $response = 'error';
            } else {
                // Process the API response here
                $response = $handle;
            }

            // Close the handle
            return $response;
        }
        */
    }

    public static function mtn($receiver, $message){
        if ($receiver[0] === "+") {
            $receiver = substr($receiver, 1);
        }

        if ($receiver[0] === "0") {
            $receiver = substr($receiver, 1);
        }

        if(strlen($receiver) == 9){
            $receiver = '963' . $receiver;
        }

        $API = "https://postajji.sy/api/v1/send-sms?phone=" . $receiver . '&message=' . base64_encode($message);

        $response = Http::withOptions(['verify' => false])->get($API);

        return 'success';

        if ($response == 'success') {
            return 'success';
        }else{
            return 'error';
        }
    }

    public static function sendMTNSMSCompanyMessage($receiver, $message): string
    {

        //return self::whatsApp($receiver, $message);
        if ($receiver[0] === "+") {
            $receiver = substr($receiver, 1);
        }

        if ($receiver[0] === "0") {
            $receiver = substr($receiver, 1);
        }

        if(strlen($receiver) == 9){
            $receiver = '963' . $receiver;
        }

        $message = base64_decode($message);
        $message = mb_convert_encoding($message, 'UTF-32', 'UTF-8');
        $message = bin2hex($message);
        $message = str_replace('0000', '', $message);
        $message = strtoupper($message);

        $MTN = [
            "API" => "https://services.mtnsyr.com:7443/general/MTNSERVICES/ConcatenatedSender.aspx/?",
            "USER" => "ija520",
            "PASS" => "tso151210",
            "FROM" => "Postajji",
            "CODE" => "Sec!@123",
            "LANG" => 0
        ];

        $response = Http::withOptions(['verify' => false])->get($MTN['API'], [
            "USER" => "ija520",
            "PASS" => "tso151210",
            "FROM" => "Postajji",
            "CODE" => "Sec!@123",
            "LANG" => 0,
            "Gsm" => $receiver,
            "Msg" => $message
        ]);

        return 'success';

        if ($response->successful()) {
            return 'success';
        }else{
            return 'error';
        }
    }

    public static function twilio($receiver, $otp)
    {
        $config = self::get_settings('twilio_sms');
        $response = 'error';

        if (isset($config) && $config['status'] == 1) {
            $message = str_replace("#OTP#", $otp, $config['otp_template']);
            $sid = $config['sid'];
            $token = $config['token'];
            try {
                $twilio = new Client($sid, $token);
                $twilio->messages
                    ->create($receiver, // to
                        array(
                            "messagingServiceSid" => $config['messaging_service_id'],
                            "body" => $message
                        )
                    );
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        } elseif (empty($config)) {
            DB::table('business_settings')->updateOrInsert(['key' => 'twilio_sms'], [
                'key' => 'twilio_sms',
                'value' => json_encode([
                    'status' => 0,
                    'sid' => '',
                    'token' => '',
                    'from' => '',
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return $response;
    }

    public static function nexmo($receiver, $otp)
    {
        $sms_nexmo = self::get_settings('nexmo_sms');
        $response = 'error';
        if (isset($sms_nexmo) && $sms_nexmo['status'] == 1) {
            $message = str_replace("#OTP#", $otp, $sms_nexmo['otp_template']);
            try {
                $config = [
                    'api_key' => $sms_nexmo['api_key'],
                    'api_secret' => $sms_nexmo['api_secret'],
                    'signature_secret' => '',
                    'private_key' => '',
                    'application_id' => '',
                    'app' => ['name' => '', 'version' => ''],
                    'http_client' => ''
                ];
                Config::set('nexmo', $config);
                Nexmo::message()->send([
                    'to' => $receiver,
                    'from' => $sms_nexmo['from'],
                    'text' => $message
                ]);
                $response = 'success';
            } catch (\Exception $exception) {
                $response = 'error';
            }
        } elseif (empty($config)) {
            DB::table('business_settings')->updateOrInsert(['key' => 'nexmo_sms'], [
                'key' => 'nexmo_sms',
                'value' => json_encode([
                    'status' => 0,
                    'api_key' => '',
                    'api_secret' => '',
                    'signature_secret' => '',
                    'private_key' => '',
                    'application_id' => '',
                    'from' => '',
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return $response;
    }

    public static function two_factor($receiver, $otp)
    {
        $config = self::get_settings('2factor_sms');
        $response = 'error';
        if (isset($config) && $config['status'] == 1) {
            $api_key = $config['api_key'];
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://2factor.in/API/V1/" . $api_key . "/SMS/" . $receiver . "/" . $otp . "",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if (!$err) {
                $response = 'success';
            } else {
                $response = 'error';
            }
        } elseif (empty($config)) {
            DB::table('business_settings')->updateOrInsert(['key' => '2factor_sms'], [
                'key' => '2factor_sms',
                'value' => json_encode([
                    'status' => 0,
                    'api_key' => 'aabf4e9c-f55f-11eb-85d5-0200cd936042',
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return $response;
    }

    public static function msg_91($receiver, $otp)
    {
        $config = self::get_settings('msg91_sms');
        $response = 'error';
        if (isset($config) && $config['status'] == 1) {
            $receiver = str_replace("+", "", $receiver);
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.msg91.com/api/v5/otp?template_id=" . $config['template_id'] . "&mobile=" . $receiver . "&authkey=" . $config['authkey'] . "",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_POSTFIELDS => "{\"OTP\":\"$otp\"}",
                CURLOPT_HTTPHEADER => array(
                    "content-type: application/json"
                ),
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            if (!$err) {
                $response = 'success';
            } else {
                $response = 'error';
            }
        } elseif (empty($config)) {
            DB::table('business_settings')->updateOrInsert(['key' => 'msg91_sms'], [
                'key' => 'msg91_sms',
                'value' => json_encode([
                    'status' => 0,
                    'template_id' => '',
                    'authkey' => '',
                ]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return $response;
    }

    public static function get_settings($name)
    {
        $config = null;
        $data = BusinessSetting::where(['key' => $name])->first();
        if (isset($data)) {
            $config = json_decode($data['value'], true);
            if (is_null($config)) {
                $config = $data['value'];
            }
        }
        return $config;
    }
}
