<?php

namespace App\CentralLogics;

use App\Models\AccountTransaction;
use App\Models\Admin;
use App\Models\DeliveryMan;
use App\Models\DeliveryManBlockingLog;
use App\Models\DMLog;
use App\Models\Order;
use App\Models\OrderTransaction;
use App\Models\AdminWallet;
use App\Models\BusinessSetting;
use App\Models\StoreWallet;
use App\Models\DeliveryManWallet;
use App\CentralLogics\CustomerLogic;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class OrderLogic
{
    public static function gen_unique_id()
    {
        return rand(1000, 9999) . '-' . Str::random(5) . '-' . time();
    }

    public static function track_order($order_id)
    {
        return Helpers::order_data_formatting(Order::with(['details', 'delivery_man.rating'])->where(['id' => $order_id])->first(), false);
    }

    public static function updated_order_calculation($order)
    {
        return true;
    }
    public static function create_transaction($order, $received_by=false, $status = null)
    {
        $type = $order->order_type;
        $dm_tips_manage_status = BusinessSetting::where('key', 'dm_tips_status')->first()->value;
        $admin_subsidy = 0;
        $amount_admin = 0;
        $store_d_amount = 0;
        $admin_coupon_discount_subsidy =0;
        $store_subsidy =0;
        $store_coupon_discount_subsidy =0;
        $store_discount_amount=0;
        $comission_on_store_amount=0;

        // free delivery by admin
        if($order->free_delivery_by == 'admin')
        {
            $admin_subsidy = $order->original_delivery_charge;
            Helpers::expenseCreate($order->original_delivery_charge,'free_delivery',now(),$order->id,$order->free_delivery_by);
        }
        // free delivery by store
        if($order->free_delivery_by == 'vendor')
        {
            $store_subsidy = $order->original_delivery_charge;
            Helpers::expenseCreate($order->original_delivery_charge,'free_delivery',now(),$order->id,$order->free_delivery_by,$order->store->id);
        }
        // coupon discount by Admin
        if($order->coupon_created_by == 'admin')
        {
            $admin_coupon_discount_subsidy = $order->coupon_discount_amount;
            Helpers::expenseCreate($admin_coupon_discount_subsidy,'coupon_discount',now(),$order->id,$order->coupon_created_by);
        }
        // coupon discount by store
        if($order->coupon_created_by == 'vendor')
        {
            $store_coupon_discount_subsidy = $order->coupon_discount_amount;
            Helpers::expenseCreate($store_coupon_discount_subsidy,'coupon_discount',now(),$order->id,$order->coupon_created_by,$order->store->id);
        }

        if($type == 'parcel')
        {
            $comission = \App\Models\BusinessSetting::where('key','parcel_commission_dm')->first();
            $dm_tips = $dm_tips_manage_status ? $order->dm_tips : 0;
            $comission = isset($comission) ? $comission->value : 0;
            $order_amount = $order->order_amount - $dm_tips;
            $dm_commission = $comission?($order_amount/ 100) * $comission:0;
            $comission_amount = $order_amount - $dm_commission;
            $commissionFromStore = 0;
        }
        else
        {
            $comission = isset($order->store->comission) == null?\App\Models\BusinessSetting::where('key','admin_commission')->first()->value:$order->store->comission;
            $dm_tips = $dm_tips_manage_status ? $order->dm_tips : 0;
            // $order_amount = $order->order_amount - $order->delivery_charge - $order->total_tax_amount - $dm_tips;

            if($order->store_discount_amount > 0  && $order->discount_on_product_by == 'vendor')
            {
                $amount_admin = $comission?($order->store_discount_amount/ 100) * $comission:0;
                $store_d_amount=  $order->store_discount_amount- $amount_admin;
                Helpers::expenseCreate($store_d_amount,'discount_on_product',now(),$order->id,'vendor',$order->store->id);
                Helpers::expenseCreate($amount_admin,'discount_on_product',now(),$order->id,'admin');
            }

            if($order->store_discount_amount > 0  && $order->discount_on_product_by == 'admin')
            {
                $store_discount_amount=$order->store_discount_amount;
                Helpers::expenseCreate($store_discount_amount,'discount_on_product',now(),$order->id,'admin');
            }



            $order_amount = $order->order_amount - $order->delivery_charge - $order->total_tax_amount - $dm_tips + $order->coupon_discount_amount + $store_discount_amount;
            // comission in delivery charge
            $delivery_charge_comission = BusinessSetting::where('key', 'delivery_charge_comission')->first();
            $delivery_charge_comission_percentage = $delivery_charge_comission ? $delivery_charge_comission->value : 0;
            $comission_on_delivery = $delivery_charge_comission_percentage * ( $order->original_delivery_charge / 100 );

            if($order->store->self_delivery_system)
            {
                $comission_on_actual_delivery_fee = 0;
            }else{
                $comission_on_actual_delivery_fee = ($order->delivery_charge > 0) ? $comission_on_delivery : 0;
            }

            //final comission
            $comission_on_store_amount = ($comission?($order_amount/ 100) * $comission:0);
            $comission_amount = $comission_on_store_amount + $comission_on_actual_delivery_fee;
            $dm_commission = $order->original_delivery_charge - $comission_on_actual_delivery_fee;

            if($order->free_delivery_by == 'admin')
            {
                if($order->store->self_delivery_system)
                {
                    $comission_on_actual_delivery_fee = 0;
                }else{

                    $comission_on_actual_delivery_fee = ($order->original_delivery_charge > 0) ? $comission_on_delivery : 0;
                }

                //final comission
                $comission_on_store_amount = ($comission?($order_amount/ 100) * $comission:0);
                $comission_amount = $comission_on_store_amount + $comission_on_actual_delivery_fee;
                $dm_commission = $order->original_delivery_charge - $comission_on_actual_delivery_fee;
            }
            $commissionFromStore = isset($order->store->comission) ? ($order->order_amount * $order->store->comission ) / 100 : 0;
            $store_amount = $order->order_amount - $commissionFromStore;
        }
        //Fix delivery man delivery charge if he is freelancer or employee (original_delivery_charge)
        if($order->delivery_man_id != null){
            $dm_commission = Order::getOriginalDeliveryCharge($order->delivery_charge, $order->delivery_man_id);
            // Update original_delivery_charge in order
            Order::where('id', $order->id)->update(['original_delivery_charge' => $dm_commission]);
        }
        //$store_amount = $order_amount + $order->total_tax_amount - $comission_on_store_amount - $store_coupon_discount_subsidy;

        $couponInfo = $order->coupon_info != null ? json_decode($order->coupon_info) : null;
        $discount_amount_coupon_on_delivery_charge = null;
        $discount_amount_coupon_on_items = null;
        if($couponInfo != null){
            if($couponInfo->coupon_type == 'free_delivery'){
                $discount_amount_coupon_on_delivery_charge = $order->coupon_discount_amount;
            }else if($couponInfo->coupon_type == 'store_wise'){
                $discount_amount_coupon_on_items = $order->coupon_discount_amount;
            }else if($couponInfo->coupon_type == 'vip'){
                $discount_amount_coupon_on_delivery_charge = $order->delivery_charge;
                $discount_amount_coupon_on_items = $order->coupon_discount_amount - $order->delivery_charge;
            }
        }

        //if($type == 'parcel') {
        //    $admin_commission = $comission_amount - $admin_subsidy - $admin_coupon_discount_subsidy;
        //}else{
        //    $admin_commission = $order->delivery_charge - $dm_commission - $admin_coupon_discount_subsidy;
        //}

        $admin_commission = $order->delivery_charge - $dm_commission;

        if($order->boost_id != null and $order->boost_info != null){
            $boostInfo = json_decode($order->boost_info);
            $boost_amount = ( $dm_commission * $boostInfo->amount_percentage ) / 100;
            if($boost_amount > $boostInfo->max_amount){
                $boost_amount = $boostInfo->max_amount;
            }
            if($boost_amount > 0 && $order->delivery_charge <= $boostInfo->max_amount) {
                $order->boost_amount = $boost_amount;
                $order->save();

                $account_transaction = new AccountTransaction();
                $account_transaction->from_type = 'deliveryman';
                $account_transaction->from_id = $order->delivery_man_id;
                $account_transaction->method = 'By system';
                $account_transaction->ref = 'Boost للطلب رقم: ' . $order->id;
                $account_transaction->amount = (float)$boost_amount;
                $account_transaction->current_balance = DeliveryMan::getTheRemainingBalanceForDeliveryMan($order->delivery_man, '', '');
                $account_transaction->transaction_date = now();
                $account_transaction->save();

                $getDMLogMessage = Helpers::getDMLogMessage('boost_for_order');
                $getDMLogMessage = str_replace('******', $order->id, $getDMLogMessage);
                DMLog::createLog($order->delivery_man_id, $getDMLogMessage, $boost_amount, null);
            }
        }else{
            $boost_amount = 0;
        }

        try{
            OrderTransaction::insert([
                'vendor_id' => $type=='parcel'?null:$order->store->vendor->id,
                'store_id' => $type=='parcel' ? null : $order->store->id,
                'delivery_man_id'=>$order->delivery_man_id,
                'order_id' =>$order->id,
                'order_amount'=> $order->order_amount,
                'store_amount'=> $type=='parcel' ? 0 : $store_amount,
                // 'store_amount'=>$type=='parcel' ? 0 : $order_amount + $order->total_tax_amount - $comission_on_store_amount,
                //'admin_commission'=> $type=='parcel' ? ($comission_amount - $admin_subsidy - $admin_coupon_discount_subsidy) : ( ($comission_amount - $admin_subsidy - $admin_coupon_discount_subsidy) + ($order->delivery_charge - $dm_commission) ),
                //'admin_commission'=> $type=='parcel' ? ($comission_amount - $admin_subsidy - $admin_coupon_discount_subsidy) : ($order->delivery_charge - $dm_commission - $admin_coupon_discount_subsidy),
                'admin_commission'=> $admin_commission,
                'delivery_charge'=> $order->delivery_charge,
                'original_delivery_charge'=>$dm_commission,
                'tax'=>$order->total_tax_amount,
                'received_by'=> $received_by ? $received_by : 'admin',
                'zone_id'=>$order->zone_id,
                'module_id'=>$order->module_id,
                'admin_expense'=>$admin_subsidy + $admin_coupon_discount_subsidy + $store_discount_amount + $amount_admin,
                'store_expense'=>$store_subsidy + $store_coupon_discount_subsidy ,
                'status'=> $status,
                'dm_tips'=> $dm_tips,
                'created_at' => now(),
                'updated_at' => now(),
                'delivery_fee_comission'=>isset($comission_on_actual_delivery_fee)?$comission_on_actual_delivery_fee: 0,
                'discount_amount_by_store' => $store_coupon_discount_subsidy + $store_d_amount + $store_subsidy,
                'commission_amount_from_store' => $type != 'parcel' ? ($order->order_amount - $store_amount) : null,
                'discount_amount_coupon_on_delivery_charge' => $couponInfo != null ? ($discount_amount_coupon_on_delivery_charge) : null,
                'discount_amount_coupon_on_items' => $couponInfo != null ? ($discount_amount_coupon_on_items) : null,
                'boost_amount' => $boost_amount,
            ]);

            $deliveryChargeAmountForCompany = $order->delivery_charge - $order->original_delivery_charge - ($couponInfo != null ? ($discount_amount_coupon_on_delivery_charge) : 0);
            if($deliveryChargeAmountForCompany > 0){
                $getDMLogMessage = Helpers::getDMLogMessage('delivery_charge_amount_for_company');
                $getDMLogMessage = str_replace('******', $order->id, $getDMLogMessage);
                DMLog::createLog($order->delivery_man_id, $getDMLogMessage, null, $deliveryChargeAmountForCompany);
            }

            $commissionAmountFromStore = ($type != 'parcel' ? ($order->order_amount - $store_amount) : 0) - ($couponInfo != null ? ($discount_amount_coupon_on_items) : 0);
            if($commissionAmountFromStore > 0){
                $getDMLogMessage = Helpers::getDMLogMessage('commission_amount_from_store');
                $getDMLogMessage = str_replace('******', $order->id, $getDMLogMessage);
                DMLog::createLog($order->delivery_man_id, $getDMLogMessage, null, $commissionAmountFromStore);
            }

            if($couponInfo != null){
                $account_transaction = new AccountTransaction();
                $dm = DeliveryMan::findOrFail($order->delivery_man_id);
                $current_balance = $dm->wallet ? $dm->wallet->collected_cash : 0;
                $saveAccountTransaction = false;
                if($couponInfo->coupon_type == 'free_delivery'){
                    //$saveAccountTransaction = true;
                    $ref = 'تم تعويض المندوب بقيمة التوصيل للطلب رقم: ' . $order->id . ' بسبب استخدام الزبون لكوبون نوعه توصيل مجاني';
                    //$amount = $order->delivery_charge;
                }else if($couponInfo->coupon_type == 'store_wise'){
                    //$saveAccountTransaction = true;
                    $ref = 'تم تعويض المندوب بقيمة الكوبون للطلب رقم: ' . $order->id . ' بسبب استخدام الزبون لكوبون للمتاجر';
                    //$amount = $order->coupon_discount_amount;
                }else if($couponInfo->coupon_type == 'default'){
                    $ref = 'تم تعويض المندوب بقيمة الكوبون للطلب رقم: ' . $order->id . ' بسبب استخدام الزبون لكوبون';
                }else if($couponInfo->coupon_type == 'vip'){
                        //$saveAccountTransaction = true;
                        $ref = 'تم تعويض المندوب بقيمة التوصيل للطلب رقم: ' . $order->id . ' بسبب استخدام الزبون لكوبون نوعه VIP';
                        //$amount = $order->delivery_charge;
                    }
                $amount = $order->coupon_discount_amount;
                if(isset($amount) and $amount > 0) {
                    $account_transaction->from_type = 'deliveryman';
                    $account_transaction->from_id = $order->delivery_man_id;
                    $account_transaction->method = 'By system';
                    $account_transaction->ref = $ref;
                    $account_transaction->amount = (float)$amount;
                    $account_transaction->current_balance = $current_balance;
                    $account_transaction->transaction_date = now();
                    $account_transaction->save();

                    $getDMLogMessage = Helpers::getDMLogMessage('customer_used_coupon');
                    $getDMLogMessage = str_replace('******', $order->id, $getDMLogMessage);
                    DMLog::createLog($order->delivery_man_id, $getDMLogMessage, $amount, null);
                }
            }

            $adminWallet = AdminWallet::firstOrNew(
                ['admin_id' => Admin::where('role_id', 1)->first()->id]
            );

            $adminWallet->total_commission_earning = $adminWallet->total_commission_earning + $comission_amount - $admin_subsidy- $admin_coupon_discount_subsidy -$store_discount_amount;

            if($type != 'parcel')
            {
                $vendorWallet = StoreWallet::firstOrNew(
                    ['vendor_id' => $order->store->vendor->id]
                );
                if($order->store->self_delivery_system)
                {
                    $vendorWallet->total_earning = $vendorWallet->total_earning + $order->delivery_charge + $dm_tips;
                }
                else{
                    $adminWallet->delivery_charge = $adminWallet->delivery_charge+$order->delivery_charge;
                }
                // $vendorWallet->total_earning = $vendorWallet->total_earning+($order_amount + $order->total_tax_amount - $comission_on_store_amount);
                $vendorWallet->total_earning = $vendorWallet->total_earning+$store_amount;
            }
            if($order->delivery_man && ($type == 'parcel' || ($order->store && !$order->store->self_delivery_system))){
                $dmWallet = DeliveryManWallet::firstOrNew(
                    ['delivery_man_id' => $order->delivery_man_id]
                );
                if($order->delivery_man->earning == 1){
                    $dmWallet->total_earning = $dmWallet->total_earning + $dm_commission+ $dm_tips;
                }else {
                    $adminWallet->total_commission_earning = $adminWallet->total_commission_earning + $dm_commission + $dm_tips;
                }
            } else {
                $adminWallet->total_commission_earning = $adminWallet->total_commission_earning + $dm_commission + $dm_tips;
            }

            $deliveryman = DeliveryMan::where('id', $order->delivery_man_id)->first();

            $theRemainingBalance = DeliveryMan::getTheRemainingBalanceForDeliveryMan($deliveryman, '', '');

            if($theRemainingBalance >= 0 && $deliveryman->earning == '1' && !DeliveryMan::isHaveActiveMonthlySubscription($deliveryman->id)){
                DeliveryMan::where('id', $deliveryman->id)->update([
                    'status' => '0'
                ]);
                DeliveryManBlockingLog::create([
                    'delivery_man_id' => $deliveryman->id,
                    'type' => 'blocking',
                    'reason' => 'تم تقييد الحساب من السيستم بشكل تلقائي عند وصول رصيد المندوب الى: ' . $theRemainingBalance,
                ]);
            }

            if($order->distance_between_dm_and_source_location > 0){
                Order::compensateDeliveryManForDistance($order);
            }

            try
            {
                DB::beginTransaction();
                /*if($received_by=='admin')
                {
                    $adminWallet->digital_received = $adminWallet->digital_received+$order->order_amount;
                }
                else if($received_by=='store' && $type != 'parcel' && $order->payment_method == "cash_on_delivery")
                {
                    $vendorWallet->collected_cash = $vendorWallet->collected_cash+$order->order_amount;
                }
                else if($received_by==false)
                {
                    $adminWallet->manual_received = $adminWallet->manual_received+$order->order_amount;
                }
                else if($received_by=='deliveryman' && $order->delivery_man && $order->delivery_man->type == 'zone_wise')
                {
                    $dmWallet->collected_cash = $dmWallet->collected_cash+$order->order_amount;
                }

                $adminWallet->save();*/
                if($type != 'parcel')
                {
                    $vendorWallet->save();
                }
                if(isset($dmWallet)){
                    $dmWallet->save();
                }

                DB::commit();

                $ref_status = BusinessSetting::where('key','ref_earning_status')->first()->value;
                if(isset($order->customer->ref_by) && $order->customer->order_count == 0  && $ref_status == 1){
                    $ref_code_exchange_amt = BusinessSetting::where('key','ref_earning_exchange_rate')->first()->value;
                    $referar_user=User::where('id',$order->customer->ref_by)->first();
                    $refer_wallet_transaction = CustomerLogic::create_wallet_transaction($referar_user->id, $ref_code_exchange_amt, 'referrer',$order->customer->phone);
                 //   try{
                   //     if(config('mail.status')) {
                     //       Mail::to($referar_user->email)->send(new \App\Mail\AddFundToWallet($refer_wallet_transaction));
                       //     }
                        //} catch(\Exception $ex){
                          //  info($ex->getMessage());
                        //}
                }

                if($order->user_id) {
                    CustomerLogic::create_loyalty_point_transaction($order->user_id, $order->id, $order->order_amount, 'order_place');
                }
            }
            catch(\Exception $e)
            {
                DB::rollBack();
                info($e);
                return false;
            }
        }
        catch(\Exception $e){
            info($e);
            return false;
        }

        return true;
    }

    public static function refund_before_delivered($order){
        $adminWallet = AdminWallet::firstOrNew(
            ['admin_id' => Admin::where('role_id', 1)->first()->id]
        );
        if ($order->payment_method == 'cash_on_delivery') {
            return false;
        }
        $adminWallet->digital_received = $adminWallet->digital_received - $order->order_amount;
        $adminWallet->save();
        if ($order->payment_status == "paid" && BusinessSetting::where('key', 'wallet_add_refund')->first()->value == 1) {
            CustomerLogic::create_wallet_transaction($order->user_id, $order->order_amount, 'order_refund', $order->id);
        }
        return true;
    }

    public static function refund_order($order)
    {
        $order_transaction = $order->transaction;
        if($order_transaction == null || $order->store == null)
        {
            return false;
        }
        $received_by = $order_transaction->received_by;

        $adminWallet = AdminWallet::firstOrNew(
            ['admin_id' => Admin::where('role_id', 1)->first()->id]
        );

        $vendorWallet = StoreWallet::firstOrNew(
            ['vendor_id' => $order->store->vendor->id]
        );

        $adminWallet->total_commission_earning = $adminWallet->total_commission_earning - $order_transaction->admin_commission + $order_transaction->delivery_fee_comission;

        $vendorWallet->total_earning = $vendorWallet->total_earning - $order_transaction->store_amount;

        $refund_amount = $order->order_amount;

        $status = 'refunded_with_delivery_charge';
        if($order->order_status == 'delivered' || $order->order_status == 'refund_requested')
        {
            $refund_amount = $order->order_amount - $order->delivery_charge -$order->dm_tips;
            $status = 'refunded_without_delivery_charge';
        }
        else
        {
            $adminWallet->delivery_charge = $adminWallet->delivery_charge - $order_transaction->delivery_charge;
        }
        try
        {
            DB::beginTransaction();
            if($received_by=='admin')
            {
                if($order->delivery_man_id && $order->payment_method != "cash_on_delivery")
                {
                    $adminWallet->digital_received = $adminWallet->digital_received - $refund_amount;
                }
                else
                {
                    $adminWallet->manual_received = $adminWallet->manual_received - $refund_amount;
                }

            }
            else if($received_by=='store')
            {
                $vendorWallet->collected_cash = $vendorWallet->collected_cash - $refund_amount;
            }

            // else if($received_by=='deliveryman')
            // {
            //     $dmWallet = DeliveryManWallet::firstOrNew(
            //         ['delivery_man_id' => $order->delivery_man_id]
            //     );
            //     $dmWallet->collected_cash=$dmWallet->collected_cash - $refund_amount;
            //     $dmWallet->save();
            // }
            $order_transaction->status = $status;
            $order_transaction->save();
            $adminWallet->save();
            $vendorWallet->save();
            DB::commit();
        }
        catch(\Exception $e)
        {
            DB::rollBack();
            info($e->getMessage());
            return false;
        }
        return true;

    }

    public static function format_export_data($orders, $type='order')
    {
        $data = [];
        foreach($orders as $key=>$order)
        {

            $data[]=[
                '#'=>$key+1,
                translate('messages.order')=>$order['id'],
                translate('messages.date')=>date('Y-m-d H:i',strtotime($order['created_at'])),
                'Delivery man name' => ($order->delivery_man) ? $order->delivery_man->f_name . ' ' . $order->delivery_man->l_name : '',
                translate('messages.customer')=>$order->customer?$order->customer['f_name'].' '.$order->customer['l_name']:translate('messages.invalid').' '.translate('messages.customer').' '.translate('messages.data'),
                translate($type=='order'?'messages.store':'messages.parcel_category')=>Str::limit($type=='order'?($order->store?$order->store->name:''):($order->parcel_category?$order->parcel_category->name:translate('messages.not_found')),20,'...'),
                translate('messages.payment').' '.translate('messages.status')=>$order->payment_status=='paid'?translate('messages.paid'):translate('messages.unpaid'),
                translate('messages.total')=> $order['order_amount'],
                translate('messages.order').' '.translate('messages.status')=>translate('messages.'. $order['order_status']),
                translate('messages.order').' '.translate('messages.type')=>translate('messages.'.$order['order_type'])
            ];
        }
        return $data;
    }
    public static function format_store_order_export_data($orders)
    {
        $data = [];
        foreach($orders as $key=>$order)
        {

            $data[]=[
                '#'=>$key+1,
                translate('messages.order')=>$order['id'],
                translate('messages.date')=>date('d M Y',strtotime($order['created_at'])),
                translate('messages.customer')=>$order->customer?$order->customer['f_name'].' '.$order->customer['l_name']:translate('messages.invalid').' '.translate('messages.customer').' '.translate('messages.data'),
                translate('messages.payment').' '.translate('messages.status')=>$order->payment_status=='paid'?translate('messages.paid'):translate('messages.unpaid'),
                translate('messages.total')=> $order['order_amount'],
                translate('messages.order').' '.translate('messages.status')=>translate('messages.'. $order['order_status']),
                translate('messages.order').' '.translate('messages.type')=>translate('messages.'.$order['order_type']),
                translate('messages.discount_amount')=>$order['coupon_discount_amount']+$order['store_discount_amount'],
                translate('messages.total_tax_amount')=>$order['total_tax_amount'],
                translate('messages.delivery_charge')=>$order['original_delivery_charge']
            ];
        }
        return $data;
    }

    public static function format_order_report_export_data($orders)
    {
        $data = [];
        foreach($orders as $key=>$order)
        {

            $data[]=[
                '#'=>$key+1,
                translate('messages.order')=>$order['id'],
                translate('messages.store')=>$order->store?$order->store->name:translate('messages.invalid'),
                translate('messages.customer_name')=>$order->customer?$order->customer['f_name'].' '.$order->customer['l_name']:translate('messages.invalid').' '.translate('messages.customer').' '.translate('messages.data'),
                translate('Total Item Amount')=>\App\CentralLogics\Helpers::format_currency($order['order_amount']-$order['dm_tips']-$order['total_tax_amount']-$order['delivery_charge']+$order['coupon_discount_amount'] + $order['store_discount_amount']),
                translate('Item Discount')=>\App\CentralLogics\Helpers::format_currency($order->details->sum('discount_on_item')),
                translate('Coupon Discount')=>\App\CentralLogics\Helpers::format_currency($order['coupon_discount_amount']),
                translate('Discounted Amount')=>\App\CentralLogics\Helpers::format_currency($order['coupon_discount_amount'] + $order['store_discount_amount']),
                translate('messages.tax')=>\App\CentralLogics\Helpers::format_currency($order['total_tax_amount']),
                translate('messages.delivery_charge')=>\App\CentralLogics\Helpers::format_currency($order['original_delivery_charge']),
                translate('messages.order_amount')=>\App\CentralLogics\Helpers::format_currency($order['order_amount']),
                translate('messages.amount_received_by')=>isset($order->transaction) ? $order->transaction->received_by : translate('messages.unpaid'),
                translate('messages.payment_method')=>translate(str_replace('_', ' ', $order['payment_method'])),
                translate('messages.order').' '.translate('messages.status')=>translate('messages.'. $order['order_status']),
                translate('messages.order').' '.translate('messages.type')=>translate('messages.'.$order['order_type']),
            ];
        }
        return $data;
    }
}
