<?php

namespace App\CentralLogics;

use App\Models\Admin;
use App\Models\DeliveryMan;
use App\Models\Item;
use App\Models\Message;
use App\Models\ModuleZone;
use App\Models\OrderTransaction;
use App\Models\Store;
use App\Models\StoreSchedule;
use App\Models\WhatsAppStore;
use App\Models\Zone;
use App\Models\AddOn;
use App\Models\Order;
use App\Models\Review;
use App\Mail\PlaceOrder;
use App\Models\Currency;
use App\Models\DMReview;
use Google\Service\AdExchangeBuyer\Product;
use Illuminate\Support\Carbon;
use App\Models\BusinessSetting;
use App\CentralLogics\StoreLogic;
use App\Models\Expense;
use App\Models\NotificationMessage;
use App\Models\User;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Laravelpkg\Laravelchk\Http\Controllers\LaravelchkController;
use Grimzy\LaravelMysqlSpatial\Types\Point;
use Illuminate\Support\Str;
use Mockery\Exception;
use PayPal\Api\Transaction;
use function Symfony\Component\Translation\t;

class Helpers
{
    public static function error_processor($validator)
    {
        $err_keeper = [];
        foreach ($validator->errors()->getMessages() as $index => $error) {
            array_push($err_keeper, ['code' => $index, 'message' => $error[0]]);
        }
        return $err_keeper;
    }

    public static function schedule_order()
    {
        return (bool)BusinessSetting::where(['key' => 'schedule_order'])->first()->value;
    }


    public static function combinations($arrays)
    {
        $result = [[]];
        foreach ($arrays as $property => $property_values) {
            $tmp = [];
            foreach ($result as $result_item) {
                foreach ($property_values as $property_value) {
                    $tmp[] = array_merge($result_item, [$property => $property_value]);
                }
            }
            $result = $tmp;
        }
        return $result;
    }

    public static function variation_price($product, $variation)
    {
        $match = json_decode($variation, true)[0];
        $result = ['price' => 0, 'stock' => 0];
        foreach (json_decode($product['variations'], true) as $property => $value) {
            if ($value['type'] == $match['type']) {
                $result = ['price' => $value['price'], 'stock' => $value['stock'] ?? 0];
            }
        }
        return $result;
    }

    public static function address_data_formatting($data)
    {
        foreach ($data as $key=>$item) {
            $point = new Point($item->latitude, $item->longitude);
            $data[$key]['zone_ids'] = array_column(Zone::contains('coordinates', $point)->latest()->get(['id'])->toArray(), 'id');;
        }
        return $data;
    }

    public static function product_data_formatting($data, $multi_data = false, $trans = false, $local = 'en')
    {
        $storage = [];
        if ($multi_data == true) {
            foreach ($data as $item) {
                $variations = [];
                if ($item->title) {
                    $item['name'] = $item->title;
                    unset($item['title']);
                }
                if ($item->start_time) {
                    $item['available_time_starts'] = $item->start_time->format('H:i');
                    unset($item['start_time']);
                }
                if ($item->end_time) {
                    $item['available_time_ends'] = $item->end_time->format('H:i');
                    unset($item['end_time']);
                }
                if ($item->start_date) {
                    $item['available_date_starts'] = $item->start_date->format('Y-m-d');
                    unset($item['start_date']);
                }
                if ($item->end_date) {
                    $item['available_date_ends'] = $item->end_date->format('Y-m-d');
                    unset($item['end_date']);
                }
                // Fix available time for item when store is closed
                if (isset($item['available_time_starts']) and isset($item['available_time_ends'])){
                    $storeSchedule = StoreSchedule::where('store_id', $item->store_id)->where('day', date('w'))->first();
                    if($storeSchedule){
                        $currentTime = strtotime(date('h:i:s'));
                        $openingTime = strtotime($storeSchedule->opening_time);
                        $closingTime = strtotime($storeSchedule->closing_time);
                        if ($currentTime < $openingTime or $currentTime > $closingTime){
                            $item['available_time_starts'] = $storeSchedule->opening_time;
                            $item['available_time_ends'] = $storeSchedule->closing_time;
                        }
                    }else{
                        $item['available_time_starts'] = '04:00:00';
                        $item['available_time_ends'] = '04:00:01';
                    }
                }
                $item['recommended'] =(int) $item->recommended;
                $categories = [];
                if($item['category_ids'] != null) {
                    foreach (json_decode($item['category_ids']) as $value) {
                        $categories[] = ['id' => (string)$value->id, 'position' => $value->position];
                    }
                }
                $item['category_ids'] = $categories;
                $item['attributes'] = json_decode($item['attributes']);
                $item['choice_options'] = json_decode($item['choice_options']);

                $add_on_ids = json_decode($item['add_ons'], true);
                $add_on_ids = is_array($add_on_ids) ? $add_on_ids : [];

                $item['add_ons'] = self::addon_data_formatting(
                    AddOn::withoutGlobalScope('translate')
                        ->whereIn('id', $add_on_ids)
                        ->active()
                        ->get(),
                    true,
                    $trans,
                    $local
                );

                $variations_data = json_decode($item['variations'], true) ?? [];

                foreach ($variations_data as $var) {
                    $variations[] = [
                        'type' => $var['type'],
                        'price' => (float)$var['price'],
                        'stock' => (int)($var['stock'] ?? 0)
                    ];
                }
                $item['variations'] = $variations;
                $item['food_variations'] = $item['food_variations']?json_decode($item['food_variations'], true):'';
                $item['module_type'] = $item->module->module_type;
                $item['store_name'] = $item->store->name;
                $item['en_store_name'] = $item->store->en_name;
                $item['zone_id'] = $item->store->zone_id;
                $item['store_discount'] = self::get_store_discount($item->store) ? $item->store->discount->discount : 0;
                $item['schedule_order'] = $item->store->schedule_order;
                $item['tax'] = $item->store->tax;
                $item['rating_count'] = (int)($item->rating ? array_sum(json_decode($item->rating, true)) : 0);
                $item['avg_rating'] = (float)($item->avg_rating ? $item->avg_rating : 0);
                $item['recommended'] =(int) $item->recommended;


                if ($trans) {
                    $item['translations'][] = [
                        'translationable_type' => 'App\Models\Item',
                        'translationable_id' => $item->id,
                        'locale' => 'en',
                        'key' => 'name',
                        'value' => $item->name
                    ];

                    $item['translations'][] = [
                        'translationable_type' => 'App\Models\Item',
                        'translationable_id' => $item->id,
                        'locale' => 'en',
                        'key' => 'description',
                        'value' => $item->description
                    ];
                }

                if (count($item['translations']) > 0) {
                    foreach ($item['translations'] as $translation) {
                        if ($translation['locale'] == $local) {
                            if ($translation['key'] == 'name') {
                                $item['name'] = $translation['value'] ?? $item->name;
                            }

                            if ($translation['key'] == 'title') {
                                $item['name'] = $translation['value'] ?? $item->name;
                            }

                            if ($translation['key'] == 'description') {
                                $item['description'] = $translation['value'] ?? $item->description;
                            }
                        }
                    }
                }
                if (!$trans) {
                    unset($item['translations']);
                }

                $translate = DB::table('translations')->where('translationable_type', 'App\Models\Item')->where('translationable_id', $item['id'])->where('key', 'name')->first();
                $arName = isset($translate->value) ? $translate->value : null;
                $item['en_name'] = $item['name'] ?? '';
                $item['name'] = $arName ?? $item['name'];

                $translate2 = DB::table('translations')->where('translationable_type', 'App\Models\Item')->where('translationable_id', $item->id)->where('key', 'description')->first();
                $arDescription = isset($translate2->value) ? $translate2->value : null;
                $item['en_description'] = $item['description'] ?? '';
                $item['description'] = $arDescription ?? $item['description'];

                unset($item['store']);
                unset($item['rating']);
                array_push($storage, $item);
            }
            $data = $storage;
        } else {
            $variations = [];
            $categories = [];
            foreach (json_decode($data['category_ids']) as $value) {
                $categories[] = ['id' => (string)$value->id, 'position' => $value->position];
            }
            $data['category_ids'] = $categories;

            $data['attributes'] = json_decode($data['attributes']);
            $data['choice_options'] = json_decode($data['choice_options']);
            $data['add_ons'] = self::addon_data_formatting(AddOn::whereIn('id', json_decode($data['add_ons']))->active()->get(), true, $trans, $local);
            foreach (json_decode($data['variations'], true) as $var) {
                array_push($variations, [
                    'type' => $var['type'],
                    'price' => (float)$var['price'],
                    'stock' => (int)($var['stock'] ?? 0)
                ]);
            }
            if ($data->title) {
                $data['name'] = $data->title;
                unset($data['title']);
            }
            if ($data->start_time) {
                $data['available_time_starts'] = $data->start_time->format('H:i');
                unset($data['start_time']);
            }
            if ($data->end_time) {
                $data['available_time_ends'] = $data->end_time->format('H:i');
                unset($data['end_time']);
            }
            if ($data->start_date) {
                $data['available_date_starts'] = $data->start_date->format('Y-m-d');
                unset($data['start_date']);
            }
            if ($data->end_date) {
                $data['available_date_ends'] = $data->end_date->format('Y-m-d');
                unset($data['end_date']);
            }
            $data['variations'] = $variations;
            $data['food_variations'] = $data['food_variations']?json_decode($data['food_variations'], true):'';
            $data['store_name'] = $data->store->name;
            $data['en_store_name'] = $data->store->en_name;
            $data['module_type'] = $data->module->module_type;
            $data['zone_id'] = $data->store->zone_id;
            $data['store_discount'] = self::get_store_discount($data->store) ? $data->store->discount->discount : 0;
            $data['schedule_order'] = $data->store->schedule_order;
            $data['rating_count'] = (int)($data->rating ? array_sum(json_decode($data->rating, true)) : 0);
            $data['avg_rating'] = (float)($data->avg_rating ? $data->avg_rating : 0);

            if ($trans) {
                $data['translations'][] = [
                    'translationable_type' => 'App\Models\Item',
                    'translationable_id' => $data->id,
                    'locale' => 'en',
                    'key' => 'name',
                    'value' => $data->name
                ];

                $data['translations'][] = [
                    'translationable_type' => 'App\Models\Item',
                    'translationable_id' => $data->id,
                    'locale' => 'en',
                    'key' => 'description',
                    'value' => $data->description
                ];
            }

            /*if (count($data['translations']) > 0) {
                foreach ($data['translations'] as $translation) {
                    if ($translation['locale'] == $local) {
                        if ($translation['key'] == 'name') {
                            $data['name'] = $translation['value'];
                        }

                        if ($translation['key'] == 'title') {
                            $item['name'] = $translation['value'];
                        }

                        if ($translation['key'] == 'description') {
                            $data['description'] = $translation['value'];
                        }
                    }
                }
            }*/
            if (!$trans) {
                unset($data['translations']);
            }

            $translate = DB::table('translations')->where('translationable_type', 'App\Models\Item')->where('translationable_id', $data->id)->where('key', 'name')->first();
            $arName = isset($translate->value) ? $translate->value : '';
            $data['en_name'] = $data['name'] ?? '';
            $data['name'] = $arName ?? '';

            $translate2 = DB::table('translations')->where('translationable_type', 'App\Models\Item')->where('translationable_id', $data->id)->where('key', 'description')->first();
            $arDescription = isset($translate2->value) ? $translate2->value : '';
            $data['en_description'] = $data['description'] ?? '';
            $data['description'] = $arDescription ?? '';

            unset($data['store']);
            unset($data['rating']);
        }

        return $data;
    }

    public static function addon_data_formatting($data, $multi_data = false, $trans = false, $local = 'en')
    {
        $storage = [];
        if ($multi_data == true) {
            foreach ($data as $item) {
                if ($trans) {
                    $item['translations'][] = [
                        'translationable_type' => 'App\Models\AddOn',
                        'translationable_id' => $item->id,
                        'locale' => 'en',
                        'key' => 'name',
                        'value' => $item->name
                    ];
                }
                if (count($item->translations) > 0) {
                    foreach ($item['translations'] as $translation) {
                        if ($translation['locale'] == $local && $translation['key'] == 'name') {
                            $item['name'] = $translation['value'];
                        }
                    }
                }

                if (!$trans) {
                    unset($item['translations']);
                }

                $storage[] = $item;
            }
            $data = $storage;
        } else if (isset($data)) {
            if ($trans) {
                $data['translations'][] = [
                    'translationable_type' => 'App\Models\AddOn',
                    'translationable_id' => $data->id,
                    'locale' => 'en',
                    'key' => 'name',
                    'value' => $data->name
                ];
            }

            if (count($data->translations) > 0) {
                foreach ($data['translations'] as $translation) {
                    if ($translation['locale'] == $local && $translation['key'] == 'name') {
                        $data['name'] = $translation['value'];
                    }
                }
            }

            if (!$trans) {
                unset($data['translations']);
            }
        }
        return $data;
    }

    public static function category_data_formatting($data, $multi_data = false, $trans = false)
    {
        $storage = [];
        if ($multi_data == true) {
            $firstItem = [
                'id' => 0,
                'name' => translate('messages.all'),
                'image' => 'all-categories-1.jpeg',
                'parent_id' => 0,
                'position' => 0,
                'status' => 1,
                'priority' => 0,
                'slug' => 'all',
                'module_id' => 1,
                'created_at' => now(),
                'updated_at' => now(),
                'products_count' => Item::count(),
                'childes_count' => count($data),
            ];
            $storage[] = $firstItem;

            foreach ($data as $item) {
                if (count($item->translations) > 0) {
                    $item->name = $item->translations[0]['value'];
                }

                if (!$trans) {
                    unset($item['translations']);
                }

                $storage[] = $item;
            }
            $data = $storage;
        } else if (isset($data)) {
            if (count($data->translations) > 0) {
                $data->name = $data->translations[0]['value'];
            }

            if (!$trans) {
                unset($data['translations']);
            }
        }
        return $data;
    }

    public static function parcel_category_data_formatting($data, $multi_data = false)
    {
        $storage = [];
        if ($multi_data == true) {
            foreach ($data as $item) {
                if (count($item['translations']) > 0) {
                    $translate = array_column($item['translations']->toArray(), 'value', 'key');
                    $item['name'] = $translate['name'];
                    $item['description'] = $translate['description'];
                    unset($item['translations']);
                }
                $storage[] = $item;
            }
            $data = $storage;
        } else {
            if (count($data['translations']) > 0) {
                $translate = array_column($data['translations']->toArray(), 'value', 'key');
                $data['title'] = $translate['title'];
                $data['description'] = $translate['description'];
                unset($data['translations']);
            }
        }
        return $data;
    }

    public static function basic_campaign_data_formatting($data, $multi_data = false)
    {
        $storage = [];
        if ($multi_data == true) {
            foreach ($data as $item) {
                $variations = [];

                if ($item->start_date) {
                    $item['available_date_starts'] = $item->start_date->format('Y-m-d');
                    unset($item['start_date']);
                }
                if ($item->end_date) {
                    $item['available_date_ends'] = $item->end_date->format('Y-m-d');
                    unset($item['end_date']);
                }

                if (count($item['translations']) > 0) {
                    $translate = array_column($item['translations']->toArray(), 'value', 'key');
                    $item['title'] = $translate['title'];
                    $item['description'] = $translate['description'];
                }

                array_push($storage, $item);
            }
            $data = $storage;
        } else {
            if ($data->start_date) {
                $data['available_date_starts'] = $data->start_date->format('Y-m-d');
                unset($data['start_date']);
            }
            if ($data->end_date) {
                $data['available_date_ends'] = $data->end_date->format('Y-m-d');
                unset($data['end_date']);
            }
            if (count($data['translations']) > 0) {
                $translate = array_column($data['translations']->toArray(), 'value', 'key');
                $data['title'] = $translate['title'];
                $data['description'] = $translate['description'];
            }
        }

        return $data;
    }

    public static function store_data_formatting($data, $multi_data = false)
    {
        $storage = [];
        if ($multi_data == true) {
            foreach ($data as $item) {
                if (isset($item['rating'])) {
                    $ratings = StoreLogic::calculate_store_rating($item['rating']);
                    unset($item['rating']);
                    $item['avg_rating'] = $ratings['rating'];
                    $item['rating_count'] = $ratings['total'];
                }
                unset($item['campaigns']);
                unset($item['pivot']);

                if ($item) {
                    $moduleId = $item->module_id;
                    $zoneId = $item->zone_id;
                    $moduleZone = ModuleZone::where('module_id', $moduleId)->where('zone_id', $zoneId)->first();
                    if($moduleZone){
                        $minimum_shipping_charge = $moduleZone['minimum_shipping_charge'];
                        $per_km_shipping_charge = $moduleZone['per_km_shipping_charge'];
                        $maximum_shipping_charge = $moduleZone['maximum_shipping_charge'];

                        $item['minimum_shipping_charge'] = (float) $minimum_shipping_charge;
                        $item['per_km_shipping_charge'] = (float) $per_km_shipping_charge;
                        $item['maximum_shipping_charge'] = (float) $maximum_shipping_charge;
                    }

                }

                array_push($storage, $item);
            }
            $data = $storage;
        } else {
            if (isset($data['rating'])) {
                $ratings = StoreLogic::calculate_store_rating($data['rating']);
                unset($data['rating']);
                $data['avg_rating'] = $ratings['rating'];
                $data['rating_count'] = $ratings['total'];
            }
            unset($data['campaigns']);
            unset($data['pivot']);
            if ($data) {
                $moduleId = $data->module_id;
                $zoneId = $data->zone_id;
                $moduleZone = ModuleZone::where('module_id', $moduleId)->where('zone_id', $zoneId)->first();
                if($moduleZone){
                    $minimum_shipping_charge = $moduleZone['minimum_shipping_charge'];
                    $per_km_shipping_charge = $moduleZone['per_km_shipping_charge'];
                    $maximum_shipping_charge = $moduleZone['maximum_shipping_charge'];

                    $data['minimum_shipping_charge'] = (float) $minimum_shipping_charge;
                    $data['per_km_shipping_charge'] = (float) $per_km_shipping_charge;
                    $data['maximum_shipping_charge'] = (float) $maximum_shipping_charge;
                }

            }
        }

        return $data;
    }

    public static function wishlist_data_formatting($data, $multi_data = false)
    {
        $items = [];
        $stores = [];
        if ($multi_data == true) {

            foreach ($data as $temp) {
                if ($temp->item) {
                    $items[] = self::product_data_formatting($temp->item, false, false, app()->getLocale());
                }
                if ($temp->store) {
                    $stores[] = self::store_data_formatting($temp->store);
                }
            }
        } else {
            if ($data->item) {
                $items[] = self::product_data_formatting($data->item, false, false, app()->getLocale());
            }
            if ($data->store) {
                $stores[] = self::store_data_formatting($data->store);
            }
        }

        return ['item' => $items, 'store' => $stores];
    }

    public static function order_data_formatting($data, $multi_data = false)
    {
        $storage = [];
        if ($multi_data) {
            foreach ($data as $item) {
                if (isset($item['store'])){
                    $item['store_name'] = $item['store']['name'];
                    $item['store_address'] = $item['store']['address'];
                    $item['store_phone'] = $item['store']['phone'];
                    $item['store_phone_2'] = $item['store']['phone_2'];
                    $item['store_lat'] = $item['store']['latitude'];
                    $item['store_lng'] = $item['store']['longitude'];
                    $item['store_logo'] = $item['store']['logo'];
                    $item['store_commission'] = $item['store']['comission'];
                    unset($item['store']);
                }else{
                    $item['store_name'] = null;
                    $item['store_address'] = null;
                    $item['store_phone'] = null;
                    $item['store_phone_2'] = null;
                    $item['store_lat'] = null;
                    $item['store_lng'] = null;
                    $item['store_logo'] = null;
                    $item['store_commission'] = null;
                }
                $item['item_campaign'] = 0;
                foreach ($item->details as $d) {
                    if ($d->item_campaign_id != null) {
                        $item['item_campaign'] = 1;
                    }
                }

                $item['delivery_address'] = $item->delivery_address ? json_decode($item->delivery_address, true) : null;
                $item['details_count'] = (int)$item->details->count();
                $item['service_name'] = translate('messages.'.$item['module']['module_name']);
                $item['order_time'] = translate('messages.now');

                if($item['customer']['image'] == null){
                    $item['customer']['image'] = 'https://postajji.com/storage/app/public/profile/avatar.png';
                }else{
                    $item['customer']['image'] = 'https://postajji.com/storage/app/public/profile/' . $item['customer']['image'];
                }
                $item['customer']['f_name'] = mb_substr($item['customer']['f_name'], 0, 1) . '*********';
                $item['customer']['l_name'] = '';
                if($item['order_status'] == 'pending'){
                    $item['customer']['image'] = 'https://postajji.com/storage/app/public/profile/avatar.png';
                }
                if(in_array($item['order_type'], ['Whatsapp', 'Water', 'Store'])){
                    $item['receiver_details'] = json_decode($item['receiver_details']);
                }

                array_push($storage, $item);
            }
            $data = $storage;
        } else {
            if (isset($data['store'])) {
                $data['store_name'] = $data['store']['name'];
                $data['store_address'] = $data['store']['address'];
                $data['store_phone'] = $data['store']['phone'];
                $data['store_phone_2'] = $data['store']['phone_2'];
                $data['store_lat'] = $data['store']['latitude'];
                $data['store_lng'] = $data['store']['longitude'];
                $data['store_logo'] = $data['store']['logo'];
                $data['store_commission'] = $data['store']['comission'];
                unset($data['store']);
            } else {
                $data['store_name'] = null;
                $data['store_address'] = null;
                $data['store_phone'] = null;
                $data['store_phone_2'] = null;
                $data['store_lat'] = null;
                $data['store_lng'] = null;
                $data['store_logo'] = null;
                $data['store_commission'] = null;
            }

            $data['item_campaign'] = 0;
            foreach ($data->details as $d) {
                if ($d->item_campaign_id != null) {
                    $data['item_campaign'] = 1;
                }
            }
            $data['delivery_address'] = $data->delivery_address ? json_decode($data->delivery_address, true) : null;
            $data['details_count'] = (int)$data->details->count();
            $data['service_name'] = translate('messages.'.$data['module']['module_name']);
            $data['order_time'] = translate('messages.now');

            if($data['customer']['image'] == null){
                $data['customer']['image'] = 'https://postajji.com/storage/app/public/profile/avatar.png';
            }else{
                $data['customer']['image'] = 'https://postajji.com/storage/app/public/profile/' . $data['customer']['image'];
            }
            $data['customer']['f_name'] = mb_substr($data['customer']['f_name'], 0, 1) . '*********';
            $data['customer']['l_name'] = '';
            if($data['order_status'] == 'pending'){
                $data['customer']['image'] = 'https://postajji.com/storage/app/public/profile/avatar.png';
            }
            if(in_array($data['order_type'], ['Whatsapp', 'Water', 'Store'])){
                $data['receiver_details'] = json_decode($data['receiver_details']);
            }

        }
        return $data;
    }

    public static function order_details_data_formatting($data): array
    {
        $storage = [];
        foreach ($data as $item) {
            $item['add_ons'] = json_decode($item['add_ons']);
            foreach ($item['add_ons'] as $add_on){
                $translate = DB::table('translations')->where('translationable_type', 'App\Models\AddOn')->where('translationable_id', $add_on->id)->where('key', 'name')->first();
                if($translate->value){
                    $add_on->ar_name = $translate->value;
                }
            }
            if (isset($item->order_id) && isset($item->item_id)) {
                $itemReviewsCount = Review::where('order_id', $item->order_id)
                    ->where('item_id', $item->item_id)
                    ->count();
                $isReviewed = $itemReviewsCount > 0;
            } else {
                $isReviewed = false;
            }

            $toArray = function ($val) {
                if (is_array($val)) return $val;
                if (is_null($val)) return [];
                if (is_string($val)) {
                    $decoded = json_decode($val, true);
                    return is_array($decoded) ? $decoded : [];
                }
                return []; // fallback
            };

            $itemDetails = $toArray($item->item_details ?? null);
            $variation   = $toArray($item->variation ?? null);

            $itemDetails['is_reviewed'] = $isReviewed;

            $item->item_details = $itemDetails;
            $item->variation = $variation;
            $storage[] = $item;
        }
        $data = $storage;

        return $data;
    }

    public static function deliverymen_list_formatting($data)
    {
        $storage = [];
        foreach ($data as $item) {
            //$last_location = $item->last_location;
            $last_location = DB::table('delivery_histories')->where('delivery_man_id', $item['id'])->orderBy('id', 'DESC')->limit(1)->first();
            $storage[] = [
                'id' => $item['id'],
                'name' => $item['f_name'] . ' ' . $item['l_name'],
                'image' => $item['image'],
                'assigned_order_count' => $item['assigned_order_count'],
                'lat' => $last_location ? $last_location->latitude : false,
                'lng' => $last_location ? $last_location->longitude : false,
                'location' => $last_location ? $last_location->location : '',
            ];
        }
        $data = $storage;

        return $data;
    }

    public static function deliverymen_data_formatting($data)
    {
        $storage = [];
        foreach ($data as $item) {
            $item['avg_rating'] = (float)(count($item->rating) ? (float)$item->rating[0]->average : 0);
            $item['rating_count'] = (int)(count($item->rating) ? $item->rating[0]->rating_count : 0);
            $item['lat'] = $item->last_location ? $item->last_location->latitude : null;
            $item['lng'] = $item->last_location ? $item->last_location->longitude : null;
            $item['location'] = $item->last_location ? $item->last_location->location : null;
            if ($item['rating']) {
                unset($item['rating']);
            }
            if ($item['last_location']) {
                unset($item['last_location']);
            }
            $storage[] = $item;
        }
        $data = $storage;

        return $data;
    }

    public static function get_business_settings($name)
    {
        $config = null;

        $paymentmethod = BusinessSetting::where('key', $name)->first();

        if ($paymentmethod) {
            $config = json_decode($paymentmethod->value, true);
        }

        return $config;
    }

    public static function currency_code()
    {
        if(!request()->is('/api*') && !session()->has('currency_code')){
            $currency = BusinessSetting::where(['key' => 'currency'])->first()->value;
            session()->put('currency_code',$currency);
        }else{
            $currency = BusinessSetting::where(['key' => 'currency'])->first()->value;
        }

        if(!request()->is('/api*')){
            $currency = session()->get('currency_code');
        }

        return $currency;
    }

    // public static function currency_symbol()
    // {
    //     $currency_symbol = Currency::where(['currency_code' => Helpers::currency_code()])->first()->currency_symbol;
    //     return $currency_symbol;
    // }

    public static function currency_symbol()
    {
        if(!session()->has('currency_symbol')){
            $currency_symbol = Currency::where(['currency_code' => Helpers::currency_code()])->first()->currency_symbol;
            session()->put('currency_symbol',$currency_symbol);
        }
        $currency_symbol = session()->get('currency_symbol');
        return $currency_symbol;
    }

    // public static function format_currency($value)
    // {
    //     $currency_symbol_position = BusinessSetting::where(['key' => 'currency_symbol_position'])->first()->value;

    //     return $currency_symbol_position == 'right' ? number_format($value, config('round_up_to_digit')) . ' ' . self::currency_symbol() : self::currency_symbol() . ' ' . number_format($value, config('round_up_to_digit'));
    // }

    public static function format_currency($value)
    {
        if(!session()->has('currency_symbol_position')){
            $currency_symbol_position = BusinessSetting::where(['key' => 'currency_symbol_position'])->first()->value;
            session()->put('currency_symbol_position',$currency_symbol_position);
        }
        $currency_symbol_position = session()->get('currency_symbol_position');
        return $currency_symbol_position == 'right' ? number_format($value, config('round_up_to_digit')) . ' ' . self::currency_symbol() : self::currency_symbol() . ' ' . number_format($value, config('round_up_to_digit'));
    }

    public static function send_push_notif_to_device($fcm_token, $data, $web_push_link = null)
    {
        $deliveryManProjectId = 'postajji-279313';
        $customersProjectId = 'postajii-user';
        $storeProjectId = 'postajji-store';

        $click_action = "";
        if ($web_push_link) {
            $click_action = ',
            "click_action": "' . $web_push_link . '"';
        }

        $fields = [
            'message' => [
                'token' => $fcm_token,
                'notification' => [
                    'title' => $data['title'],
                    'body' => $data['description'],
                    'image' => $data['image'] ?? '',
                ],
                'data' => [
                    "title" => $data['title'],
                    "body" => $data['description'],
                    "image" => isset($data['image']) ? $data['image'] : "",
                    "order_id" => isset($data['order_id']) ? (string)($data['order_id']) : "",
                    "type" => isset($data['type']) ? $data['type'] : "",
                    "conversation_id" => isset($data['conversation_id']) ? (string)($data['conversation_id']) : "",
                    "sender_type" => isset($data['sender_type']) ? $data['sender_type'] : "",
                    "module_id" => isset($data['module_id']) ? (string)($data['module_id']) : "",
                    "order_type" => isset($data['order_type']) ? $data['order_type'] : "",
                ],
            ]
        ];

        //Send to delivery man
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $deliveryManProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('delivery_man');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }

        //Send to customer
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $customersProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('customers');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }

        //Send to store
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $storeProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('store');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }

        return $result;
    }

    public static function getGoogleAccessToken($app = 'customers'){
        if($app == 'delivery_man'){
            $fileName = 'firebase-service-account-for-delivery-man.json';
        }
        if($app == 'customers'){
            $fileName = 'firebase-service-account-for-customer.json';
        }
        if($app == 'store'){
            $fileName = 'firebase-service-account-for-store.json';
        }
        $credentialsFilePath = storage_path('app/' . $fileName); //replace this with your actual path and file name
        $client = new \Google_Client();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
        return $token['access_token'];
    }

    public static function send_push_notif_to_device____old_____($fcm_token, $data, $web_push_link = null)
    {
        $key = BusinessSetting::where(['key' => 'push_notification_key'])->first()->value;
        $url = "https://fcm.googleapis.com/fcm/send";
        $header = array(
            "authorization: key=" . $key . "",
            "content-type: application/json"
        );
        $header2 = array(
            "authorization: key=AAAA-xr_tG8:APA91bEO-99Mp813tfmpx0yH7_QQt3a9NHcRvo9YmDkljx_L8VhRVg3-S9bLLRFPV2KGsOao3hJ8kA109vUoq9YdgXeoJQxlbvuacjz9fSqKRqU-nTZpt4FDWVbkYBT_bdx7_tHSTw8Q",
            "content-type: application/json"
        );

        if(isset($data['message'])){
            $message = $data['message'];
        }else{
            $message = '';
        }
        if(isset($data['conversation_id'])){
            $conversation_id = $data['conversation_id'];
        }else{
            $conversation_id = '';
        }
        if(isset($data['sender_type'])){
            $sender_type = $data['sender_type'];
        }else{
            $sender_type = '';
        }
        if(isset($data['module_id'])){
            $module_id = $data['module_id'];
        }else{
            $module_id = '';
        }
        if(isset($data['order_type'])){
            $order_type = $data['order_type'];
        }else{
            $order_type = '';
        }

        $click_action = "";
        if($web_push_link){
            $click_action = ',
            "click_action": "'.$web_push_link.'"';
        }

        $postdata = '{
            "to" : "' . $fcm_token . '",
            "mutable_content": true,
            "data" : {
                "title":"' . $data['title'] . '",
                "body" : "' . $data['description'] . '",
                "image" : "' . $data['image'] . '",
                "order_id":"' . $data['order_id'] . '",
                "type":"' . $data['type'] . '",
                "conversation_id":"' . $conversation_id . '",
                "sender_type":"' . $sender_type . '",
                "module_id":"' . $module_id . '",
                "order_type":"' . $order_type . '",
                "is_read": 0
            },
            "notification" : {
                "title" :"' . $data['title'] . '",
                "body" : "' . $data['description'] . '",
                "image" : "' . $data['image'] . '",
                "order_id":"' . $data['order_id'] . '",
                "title_loc_key":"' . $data['order_id'] . '",
                "body_loc_key":"' . $data['type'] . '",
                "type":"' . $data['type'] . '",
                "is_read": 0,
                "icon" : "new",
                "sound": "notification.wav",
                "android_channel_id": "6ammart"
                '.$click_action.'
            }
        }';

        $ch = curl_init();
        $timeout = 120;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header2);
        // Get URL content
        $result = curl_exec($ch);
        // close handle to release resources
        curl_close($ch);

        $ch = curl_init();
        $timeout = 120;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        // Get URL content
        $result = curl_exec($ch);
        // close handle to release resources
        curl_close($ch);

        return $result;
    }

    public static function send_push_notif_to_topic($data, $topic, $type,$web_push_link = null)
    {
        $deliveryManProjectId = 'postajji-279313';
        $customersProjectId = 'postajii-user';
        $storeProjectId = 'postajji-store';

        $click_action = "";
        if ($web_push_link) {
            $click_action = ',
            "click_action": "' . $web_push_link . '"';
        }

        $fields = [
            'message' => [
                'topic' => $topic,
                'notification' => [
                    'title' => $data['title'],
                    'body' => $data['description'],
                    'image' => $data['image'] ?? '',
                ],
                'data' => [
                    "title" => $data['title'],
                    "body" => $data['description'],
                    "image" => isset($data['image']) ? $data['image'] : "",
                    "order_id" => isset($data['order_id']) ? (string)($data['order_id']) : "",
                    "type" => isset($type) ? (isset($data['type']) ? $data['type'] : "") : "",
                    "conversation_id" => isset($data['conversation_id']) ? (string)($data['conversation_id']) : "",
                    "sender_type" => isset($data['sender_type']) ? $data['sender_type'] : "",
                    "module_id" => isset($data['module_id']) ? (string)($data['module_id']) : "",
                    "order_type" => isset($data['order_type']) ? $data['order_type'] : "",
                ]
            ]
        ];

        //Send to delivery man
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $deliveryManProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('delivery_man');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }

        //Send to customer
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $customersProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('customers');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }

        //Send to store
        try {
            $url = 'https://fcm.googleapis.com/v1/projects/'. $storeProjectId .'/messages:send';
            $access_token = Helpers::getGoogleAccessToken('store');
            $headers = array(
                'Authorization: Bearer ' . $access_token,
                'Content-type: Application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

            $result = curl_exec($ch);

            curl_close($ch);
        }catch (Exception $exception){

        }
        return $result;
    }

    public static function send_push_notif_to_topic______old($data, $topic, $type,$web_push_link = null)
    {
        info([$data, $topic, $type, $web_push_link]);
        $key = BusinessSetting::where(['key' => 'push_notification_key'])->first()->value;

        $url = "https://fcm.googleapis.com/fcm/send";
        $header = array(
            "authorization: key=" . $key . "",
            "content-type: application/json"
        );
        $header2 = array(
            "authorization: key=AAAA-xr_tG8:APA91bEO-99Mp813tfmpx0yH7_QQt3a9NHcRvo9YmDkljx_L8VhRVg3-S9bLLRFPV2KGsOao3hJ8kA109vUoq9YdgXeoJQxlbvuacjz9fSqKRqU-nTZpt4FDWVbkYBT_bdx7_tHSTw8Q",
            "content-type: application/json"
        );

        if(isset($data['module_id'])){
            $module_id = $data['module_id'];
        }else{
            $module_id = '';
        }
        if(isset($data['order_type'])){
            $order_type = $data['order_type'];
        }else{
            $order_type = '';
        }

        $click_action = "";
        if($web_push_link){
            $click_action = ',
            "click_action": "'.$web_push_link.'"';
        }

        if (isset($data['order_id'])) {
            $postdata = '{
                "to" : "/topics/' . $topic . '",
                "mutable_content": true,
                "data" : {
                    "title":"' . $data['title'] . '",
                    "body" : "' . $data['description'] . '",
                    "image" : "' . $data['image'] . '",
                    "order_id":"' . $data['order_id'] . '",
                    "module_id":"' . $module_id . '",
                    "order_type":"' . $order_type . '",
                    "is_read": 0,
                    "type":"' . $type . '"
                },
                "notification" : {
                    "title":"' . $data['title'] . '",
                    "body" : "' . $data['description'] . '",
                    "image" : "' . $data['image'] . '",
                    "order_id":"' . $data['order_id'] . '",
                    "title_loc_key":"' . $data['order_id'] . '",
                    "body_loc_key":"' . $type . '",
                    "type":"' . $type . '",
                    "is_read": 0,
                    "icon" : "new",
                    "sound": "notification.wav",
                    "android_channel_id": "6ammart"
                    '.$click_action.'
                  }
            }';
        } else {
            $postdata = '{
                "to" : "/topics/' . $topic . '",
                "mutable_content": true,
                "data" : {
                    "title":"' . $data['title'] . '",
                    "body" : "' . $data['description'] . '",
                    "image" : "' . $data['image'] . '",
                    "is_read": 0,
                    "type":"' . $type . '"
                },
                "notification" : {
                    "title":"' . $data['title'] . '",
                    "body" : "' . $data['description'] . '",
                    "image" : "' . $data['image'] . '",
                    "body_loc_key":"' . $type . '",
                    "type":"' . $type . '",
                    "is_read": 0,
                    "icon" : "new",
                    "sound": "notification.wav",
                    "android_channel_id": "6ammart"
                    '.$click_action.'
                  }
            }';
        }

        $ch = curl_init();
        $timeout = 120;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header2);
        // Get URL content
        $result = curl_exec($ch);
        // close handle to release resources
        curl_close($ch);

        $ch = curl_init();
        $timeout = 120;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        // Get URL content
        $result = curl_exec($ch);
        // close handle to release resources
        curl_close($ch);

        return $result;
    }

    public static function rating_count($item_id, $rating)
    {
        return Review::where(['item_id' => $item_id, 'rating' => $rating])->count();
    }

    public static function dm_rating_count($deliveryman_id, $rating)
    {
        return DMReview::where(['delivery_man_id' => $deliveryman_id, 'rating' => $rating])->count();
    }

    public static function tax_calculate($item, $price)
    {
        if ($item['tax_type'] == 'percent') {
            $price_tax = ($price / 100) * $item['tax'];
        } else {
            $price_tax = $item['tax'];
        }
        return $price_tax;
    }

    public static function discount_calculate($product, $price)
    {
        if ($product['store_discount']) {
            $price_discount = ($price / 100) * $product['store_discount'];
        } else if ($product['discount_type'] == 'percent') {
            $price_discount = ($price / 100) * $product['discount'];
        } else {
            $price_discount = $product['discount'];
        }
        return $price_discount;
    }

    public static function get_product_discount($product)
    {
        $store_discount = self::get_store_discount($product->store);
        if ($store_discount) {
            $discount = $store_discount['discount'] . ' %';
        } else if ($product['discount_type'] == 'percent') {
            $discount = $product['discount'] . ' %';
        } else {
            $discount = self::format_currency($product['discount']);
        }
        return $discount;
    }

    public static function product_discount_calculate($product, $price, $store)
    {
        $store_discount = self::get_store_discount($store);
        if (isset($store_discount)) {
            $price_discount = ($price / 100) * $store_discount['discount'];
        } else if ($product['discount_type'] == 'percent') {
            $price_discount = ($price / 100) * $product['discount'];
        } else {
            $price_discount = $product['discount'];
        }
        return $price_discount;
    }

    public static function get_price_range($product, $discount = false)
    {
        $lowest_price = $product->price;
        $highest_price = $product->price;
        if ($product->variations && is_array(json_decode($product['variations'], true))) {
            foreach (json_decode($product->variations) as $key => $variation) {
                if ($lowest_price > $variation->price) {
                    $lowest_price = round($variation->price, 2);
                }
                if ($highest_price < $variation->price) {
                    $highest_price = round($variation->price, 2);
                }
            }
        }

        if ($discount) {
            $lowest_price -= self::product_discount_calculate($product, $lowest_price, $product->store);
            $highest_price -= self::product_discount_calculate($product, $highest_price, $product->store);
        }
        $lowest_price = self::format_currency($lowest_price);
        $highest_price = self::format_currency($highest_price);

        if ($lowest_price == $highest_price) {
            return $lowest_price;
        }
        return $lowest_price . ' - ' . $highest_price;
    }
    public static function get_food_price_range($product, $discount = false)
    {
        $lowest_price = $product->price;
        // $highest_price = $product->price;
        // if ($product->variations && is_array(json_decode($product['variations'], true))) {
        //     foreach (json_decode($product->variations) as $key => $variation) {
        //         if ($lowest_price > $variation->price) {
        //             $lowest_price = round($variation->price, 2);
        //         }
        //         if ($highest_price < $variation->price) {
        //             $highest_price = round($variation->price, 2);
        //         }
        //     }
        // }

        if ($discount) {
            $store = $product->store ?? null;
            if(!$store){
                $store = Store::where('id', $product->store_id)->first();
            }
            $lowest_price -= self::product_discount_calculate($product, $lowest_price, $store);
            // $highest_price -= self::product_discount_calculate($product, $highest_price, $product->store);
        }
        $lowest_price = self::format_currency($lowest_price);
        // $highest_price = self::format_currency($highest_price);

        // if ($lowest_price == $highest_price) {
        //     return $lowest_price;
        // }
        return $lowest_price;
    }

    public static function get_store_discount($store)
    {
        if ($store->discount) {
            if (date('Y-m-d', strtotime($store->discount->start_date)) <= now()->format('Y-m-d') && date('Y-m-d', strtotime($store->discount->end_date)) >= now()->format('Y-m-d') && date('H:i', strtotime($store->discount->start_time)) <= now()->format('H:i') && date('H:i', strtotime($store->discount->end_time)) >= now()->format('H:i')) {
                return [
                    'discount' => $store->discount->discount,
                    'min_purchase' => $store->discount->min_purchase,
                    'max_discount' => $store->discount->max_discount
                ];
            }
        }
        return null;
    }

    public static function max_earning()
    {
        $data = Order::where(['order_status' => 'delivered'])->select('id', 'created_at', 'order_amount')
            ->get()
            ->groupBy(function ($date) {
                return Carbon::parse($date->created_at)->format('m');
            });

        $max = 0;
        foreach ($data as $month) {
            $count = 0;
            foreach ($month as $order) {
                $count += $order['order_amount'];
            }
            if ($count > $max) {
                $max = $count;
            }
        }
        return $max;
    }

    public static function max_orders()
    {
        $data = Order::select('id', 'created_at')
            ->get()
            ->groupBy(function ($date) {
                return Carbon::parse($date->created_at)->format('m');
            });

        $max = 0;
        foreach ($data as $month) {
            $count = 0;
            foreach ($month as $order) {
                $count += 1;
            }
            if ($count > $max) {
                $max = $count;
            }
        }
        return $max;
    }

    // public static function order_status_update_message($status)
    // {
    //     if ($status == 'pending') {
    //         $data = BusinessSetting::where('key', 'order_pending_message')->first()->value;
    //     } elseif ($status == 'confirmed') {
    //         $data = BusinessSetting::where('key', 'order_confirmation_msg')->first()->value;
    //     } elseif ($status == 'processing') {
    //         $data = BusinessSetting::where('key', 'order_processing_message')->first()->value;
    //     } elseif ($status == 'picked_up') {
    //         $data = BusinessSetting::where('key', 'out_for_delivery_message')->first()->value;
    //     } elseif ($status == 'handover') {
    //         $data = BusinessSetting::where('key', 'order_handover_message')->first()->value;
    //     } elseif ($status == 'delivered') {
    //         $data = BusinessSetting::where('key', 'order_delivered_message')->first()->value;
    //     } elseif ($status == 'delivery_boy_delivered') {
    //         $data = BusinessSetting::where('key', 'delivery_boy_delivered_message')->first()->value;
    //     } elseif ($status == 'accepted') {
    //         $data = BusinessSetting::where('key', 'delivery_boy_assign_message')->first()->value;
    //     } elseif ($status == 'canceled') {
    //         $data = BusinessSetting::where('key', 'order_cancled_message')->first()->value;
    //     } elseif ($status == 'refunded') {
    //         $data = BusinessSetting::where('key', 'order_refunded_message')->first()->value;
    //     }elseif ($status == 'refund_request_canceled') {
    //         $data = BusinessSetting::where('key', 'refund_request_canceled')->first()->value;
    //     } else {
    //         $data = '{"status":"0","message":""}';
    //     }

    //     $res = json_decode($data, true);

    //     if ($res['status'] == 0) {
    //         return 0;
    //     }
    //     return $res['message'];
    // }
    // public static function order_status_update_message($status , $module_type)
    // {
    //     if ($status == 'pending') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_pending_message')->first();
    //     } elseif ($status == 'confirmed') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_confirmation_msg')->first();
    //     } elseif ($status == 'processing') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_processing_message')->first();
    //     } elseif ($status == 'picked_up') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'out_for_delivery_message')->first();
    //     } elseif ($status == 'handover') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_handover_message')->first();
    //     } elseif ($status == 'delivered') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_delivered_message')->first();
    //     } elseif ($status == 'delivery_boy_delivered') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'delivery_boy_delivered_message')->first();
    //     } elseif ($status == 'accepted') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'delivery_boy_assign_message')->first();
    //     } elseif ($status == 'canceled') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_cancled_message')->first();
    //     } elseif ($status == 'refunded') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'order_refunded_message')->first();
    //     }elseif ($status == 'refund_request_canceled') {
    //         $data = NotificationMessage::where('module_type',$module_type)->where('key', 'refund_request_canceled')->first();
    //     } else {
    //         $data = '{"status":"0","message":""}';
    //     }

    //     $res = $data;

    //     if($res){
    //         if ($res['status'] == 0) {
    //             return 0;
    //         }
    //         return $res['message'];
    //     }else{
    //         return true;
    //     }

    // }

    public static function order_status_update_message($status,$module_type, $lang='en')
    {
        if ($status == 'pending') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_pending_message')->first();
        } elseif ($status == 'confirmed') {
            $data =  NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_confirmation_msg')->first();
        } elseif ($status == 'processing') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_processing_message')->first();
        } elseif ($status == 'picked_up') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'out_for_delivery_message')->first();
        } elseif ($status == 'handover') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_handover_message')->first();
        } elseif ($status == 'delivered') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_delivered_message')->first();
        } elseif ($status == 'delivery_boy_delivered') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'delivery_boy_delivered_message')->first();
        } elseif ($status == 'accepted') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'delivery_boy_assign_message')->first();
        } elseif ($status == 'canceled') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_cancled_message')->first();
        } elseif ($status == 'refunded') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'order_refunded_message')->first();
        } elseif ($status == 'refund_request_canceled') {
            $data = NotificationMessage::with(['translations'=>function($query)use($lang){
                $query->where('locale', $lang);
            }])->where('module_type',$module_type)->where('key', 'refund_request_canceled')->first();
        } else {
            $data = ["status"=>"0","message"=>"",'translations'=>[]];
        }

        if($data){
            if ($data['status'] == 0) {
                return '';
            }
            return count($data->translations) > 0 ? $data->translations[0]->value : $data['message'];
        }else{
            return '';
        }
    }

    public static function send_order_notification($order)
    {

        try {

            if(($order->payment_method == 'cash_on_delivery' && $order->order_status == 'pending' )||($order->payment_method != 'cash_on_delivery' && $order->order_status == 'confirmed' )){
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => translate('messages.new_order_push_description'),
                    'order_id' => $order->id,
                    'image' => '',
                    'module_id' => $order->module_id,
                    'order_type' => $order->order_type,
                    'type' => 'new_order',
                ];
                self::send_push_notif_to_topic($data, 'admin_message', 'order_request', url('/').'/admin/all-order/list/all'); // /admin/order/list/all
            }

            $status = ($order->order_status == 'delivered' && $order->delivery_man) ? 'delivery_boy_delivered' : $order->order_status;
            $value = self::order_status_update_message($status,$order->module->module_type,$order->customer?
            $order->customer->current_language_key:'en') ?? translate('messages.order_push_title');
            if ($value) {
                $data = [
                    'title' => $value,
                    'description' => '',
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'order_status',
                ];
                self::send_push_notif_to_device($order->customer->cm_firebase_token, $data);
                DB::table('user_notifications')->insert([
                    'data' => json_encode($data),
                    'user_id' => $order->user_id,
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }

            if ($status == 'picked_up') {
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => $value,
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'order_status',
                ];
                if($order->store && $order->store->vendor){
                    self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                    DB::table('user_notifications')->insert([
                        'data' => json_encode($data),
                        'vendor_id' => $order->store->vendor_id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);
                }
            }

            //Send notification to store when place order
            /*
            if ($order->order_type == 'delivery' && !$order->scheduled && $status == 'pending' && $order->payment_method == 'cash_on_delivery' && config('order_confirmation_model') == 'deliveryman') {
                if ($order->store->self_delivery_system) {
                    $data = [
                        'title' => translate('messages.order_push_title'),
                        'description' => translate('messages.new_order_push_description'),
                        'order_id' => $order->id,
                        'module_id' => $order->module_id,
                        'order_type' => $order->order_type,
                        'image' => '',
                        'type' => 'new_order',
                    ];
                    if($order->store && $order->store->vendor){
                        self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                        $web_push_link = url('/').'/store-panel/order/list/all';
                        self::send_push_notif_to_topic($data, "store_panel_{$order->store_id}_message", 'new_order', $web_push_link);
                        DB::table('user_notifications')->insert([
                            'data' => json_encode($data),
                            'vendor_id' => $order->store->vendor_id,
                            //'module_id' => $order->module_id,
                            'order_type' => $order->order_type,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                } else {
                    $data = [
                        'title' => translate('messages.order_push_title'),
                        'description' => translate('messages.new_order_push_description'),
                        'order_id' => $order->id,
                        'module_id' => $order->module_id,
                        'order_type' => $order->order_type,
                        'image' => '',
                    ];
                    if($order->zone){
                        if($order->dm_vehicle_id){

                            $topic = 'delivery_man_'.$order->zone_id.'_'.$order->dm_vehicle_id;
                            self::send_push_notif_to_topic($data, $topic, 'order_request');
                        }
                        self::send_push_notif_to_topic($data, $order->zone->deliveryman_wise_topic, 'order_request');


                    }
                }
                // self::send_push_notif_to_topic($data, 'admin_message', 'order_request', url('/').'/admin/order/list/all');
            }
            */
            //if ($order->order_type == 'parcel' && in_array($order->order_status, ['pending', 'confirmed'])) {
            if ($order->order_status == 'pending') {
                $data = [
                    //'title' => 'وحشنا الاصفر طلبنا ناطر انقاذك💪🏻',
                    'title' => 'بطلنا الحر، الطلب ناطر تحريرك 💚',
                    'description' => 'الطلب بانتظار قبولك',
                    'order_id' => $order->id,
                    'module_id' => $order->module_id,
                    'order_type' => 'parcel_order',
                    'image' => '',
                ];
                if($order->zone){
                    if($order->dm_vehicle_id){

                        $topic = 'delivery_man_'.$order->zone_id.'_'.$order->dm_vehicle_id;
                        self::send_push_notif_to_topic($data, $topic, 'order_request');
                    }
                    self::send_push_notif_to_topic($data, $order->zone->deliveryman_wise_topic, 'order_request');

                }
                // self::send_push_notif_to_topic($data, 'admin_message', 'order_request');
            }

            if ($order->order_type == 'delivery' && !$order->scheduled && $order->order_status == 'pending' && $order->payment_method == 'cash_on_delivery' && config('order_confirmation_model') == 'store') {
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => translate('messages.new_order_push_description'),
                    'order_id' => $order->id,
                    'module_id' => $order->module_id,
                    'order_type' => $order->order_type,
                    'image' => '',
                    'type' => 'new_order',
                ];
                if($order->store && $order->store->vendor){
                    self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                    $web_push_link = url('/').'/store-panel/order/list/all';
                    self::send_push_notif_to_topic($data, "store_panel_{$order->store_id}_message", 'new_order', $web_push_link);
                    // self::send_push_notif_to_topic($data, 'admin_message', 'order_request');
                    DB::table('user_notifications')->insert([
                        'data' => json_encode($data),
                        'vendor_id' => $order->store->vendor_id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);
                }
            }

            if (!$order->scheduled && (($order->order_type == 'take_away' && $order->order_status == 'pending') || ($order->payment_method != 'cash_on_delivery' && $order->order_status == 'confirmed'))) {
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => translate('messages.new_order_push_description'),
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'new_order',
                ];
                if($order->store && $order->store->vendor){
                    self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                    $web_push_link = url('/').'/store-panel/order/list/all';
                    self::send_push_notif_to_topic($data, "store_panel_{$order->store_id}_message", 'new_order', $web_push_link);
                    DB::table('user_notifications')->insert([
                        'data' => json_encode($data),
                        'vendor_id' => $order->store->vendor_id,
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);
                }
            }

            if ($order->order_status == 'confirmed' && $order->order_type != 'take_away' && config('order_confirmation_model') == 'deliveryman' && $order->payment_method == 'cash_on_delivery') {
                if ($order->store->self_delivery_system) {
                    $data = [
                        'title' => translate('messages.order_push_title'),
                        'description' => translate('messages.new_order_push_description'),
                        'order_id' => $order->id,
                        'module_id' => $order->module_id,
                        'order_type' => $order->order_type,
                        'image' => '',
                    ];

                    self::send_push_notif_to_topic($data, "restaurant_dm_" . $order->store_id, 'new_order');
                } else {
                    $data = [
                        'title' => translate('messages.order_push_title'),
                        'description' => translate('messages.new_order_push_description'),
                        'order_id' => $order->id,
                        'module_id' => $order->module_id,
                        'order_type' => $order->order_type,
                        'image' => '',
                        'type' => 'new_order',
                    ];
                    if($order->store && $order->store->vendor){
                        self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                        $web_push_link = url('/').'/store-panel/order/list/all';
                        self::send_push_notif_to_topic($data, "store_panel_{$order->store_id}_message", 'new_order', $web_push_link);
                        DB::table('user_notifications')->insert([
                            'data' => json_encode($data),
                            'vendor_id' => $order->store->vendor_id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }

            if ($order->order_type == 'delivery' && !$order->scheduled && $order->order_status == 'confirmed'  && ($order->payment_method != 'cash_on_delivery' || config('order_confirmation_model') == 'store')) {
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => translate('messages.new_order_push_description'),
                    'order_id' => $order->id,
                    'module_id' => $order->module_id,
                    'order_type' => $order->order_type,
                    'image' => '',
                ];
                if ($order->store->self_delivery_system) {
                    self::send_push_notif_to_topic($data, "restaurant_dm_" . $order->store_id, 'order_request');
                } else
                 {if($order->zone){
                    if($order->dm_vehicle_id){

                        $topic = 'delivery_man_'.$order->zone_id.'_'.$order->dm_vehicle_id;
                        self::send_push_notif_to_topic($data, $topic, 'order_request');
                    }
                    self::send_push_notif_to_topic($data, $order->zone->deliveryman_wise_topic, 'order_request');
                 }
                }
            }

            if (in_array($order->order_status, ['processing', 'handover']) && $order->delivery_man) {
                $data = [
                    'title' => translate('messages.order_push_title'),
                    'description' => $order->order_status == 'processing' ? translate('messages.Proceed_for_cooking') : translate('messages.ready_for_delivery'),
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'order_status'
                ];
                self::send_push_notif_to_device($order->delivery_man->fcm_token, $data);
                DB::table('user_notifications')->insert([
                    'data' => json_encode($data),
                    'delivery_man_id' => $order->delivery_man->id,
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }
         //   try {
           //     if ($order->order_status == 'confirmed' && $order->payment_method != 'cash_on_delivery' && config('mail.status')) {
             //           Mail::to($order->customer->email)->send(new PlaceOrder($order->id));
               // }
            //} catch (\Exception $ex) {
              //  info($ex);
            //}

            //Send notification to API subscription server
            Helpers::sendNotificationToAPISubscriptionServer($order);

            return true;
        } catch (\Exception $e) {
            info($e);
        }
        return false;
    }

    public static function sendNotificationToDeliveryManForCancellationOrder($order)
    {
        try{
            $data = [
                'title' => 'تم إلغاء الطلب من الإدارة' . ' (#'. $order->id .')',
                'description' => $order->cancellation_reason,
                'order_id' => $order->id,
                'image' => '',
                'type' => 'order_status'
            ];
            self::send_push_notif_to_device($order->delivery_man->fcm_token, $data);
            DB::table('user_notifications')->insert([
                'data' => json_encode($data),
                'delivery_man_id' => $order->delivery_man->id,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function sendNotificationToStoreForCancellationOrder($order)
    {
        try{
            $data = [
                'title' => 'تم إلغاء الطلب من الإدارة' . ' (#'. $order->id .')',
                'description' => $order->cancellation_reason,
                'order_id' => $order->id,
                'image' => '',
                'type' => 'order_status'
            ];
            self::send_push_notif_to_device($order->store->firebase_token, $data);
            DB::table('user_notifications')->insert([
                'data' => json_encode($data),
                'delivery_man_id' => $order->store->vendor->id,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function sendNotificationToAPISubscriptionServer($order){
        if ($order->order_status != 'pending') {
            if ($order->api_subscription_info != null) {
                $subscriptionInfo = json_decode($order->api_subscription_info);
                if (isset($subscriptionInfo->server_link_for_notification) && isset($subscriptionInfo->server_api_key) && isset($subscriptionInfo->server_secret_key)) {

                    $url = $subscriptionInfo->server_link_for_notification;
                    $serverApiKey = $subscriptionInfo->server_api_key;
                    $serverSecretKey = $subscriptionInfo->server_secret_key;

                    $data = [
                        'order_id' => (string)$order->id,
                        'status' => (string)$order->order_status,
                        'api_key' => (string)$serverApiKey,
                        'secret_key' => (string)$serverSecretKey,
                    ];

                    try {
                        $client = new \GuzzleHttp\Client();
                        $client->post($url, [
                            'headers' => [
                                'Accept' => 'application/json',
                                'Content-Type' => 'application/json',
                            ],
                            'json' => $data,
                            'timeout' => 10,
                        ]);
                    } catch (\Exception $e) {
                        \Log::error('Guzzle POST request failed', [
                            'url' => $url,
                            'data' => $data,
                            'message' => $e->getMessage(),
                            'trace' => $e->getTraceAsString(),
                        ]);
                    }
                }
            }
        }
    }

    public static function sendOrderNotificationToCustomer($order, $title, $description, $data = '')
    {
        try{
            if(empty($data)) {
                $data = [
                    'title' => $title,
                    'description' => $description,
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'order_status'
                ];
            }
            self::send_push_notif_to_device($order->customer->cm_firebase_token, $data);
            DB::table('user_notifications')->insert([
                'data' => json_encode($data),
                'user_id' => $order->user_id,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function sendOrderNotificationToDeliveryMan($order, $title, $description, $data = '')
    {
        try{
            $conversationId = Message::where('order_id', $order->id)->first()->conversation_id;
            if(empty($data)) {
                $data = [
                    'title' => $title,
                    'description' => $description,
                    'order_id' => $order->id,
                    'image' => '',
                    'message' => json_encode($title),
                    'type' => 'message',
                    'conversation_id' => $conversationId,
                    'sender_type' => 'customer',
                    'order_status' => $order->order_status,
                    'order_type' => $order->order_type,
                ];
            }
            self::send_push_notif_to_device($order->delivery_man->fcm_token, $data);
            DB::table('user_notifications')->insert([
                'data' => json_encode($data),
                'delivery_man_id' => $order->delivery_man->id,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function sendOrderNotificationToStore($order, $title, $description)
    {
        try{
            //To Store App
            if(!empty($order->store->vendor->firebase_token)) {
                $data = [
                    'title' => $title,
                    'description' => $description,
                    'order_id' => $order->id,
                    'image' => '',
                    'type' => 'order_status'
                ];
                self::send_push_notif_to_device($order->store->vendor->firebase_token, $data);
                DB::table('user_notifications')->insert([
                    'data' => json_encode($data),
                    'delivery_man_id' => $order->store->vendor->id,
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }

            //To Store Panel
            if($order->store && $order->store->vendor){
                $data = [
                    'title' => $title,
                    'description' => $description,
                    'order_id' => $order->id,
                    'module_id' => $order->module_id,
                    'order_type' => $order->order_type,
                    'image' => '',
                    'type' => 'new_order',
                ];
                $web_push_link = url('/').'/store-panel/order/list/all';
                self::send_push_notif_to_topic($data, "store_panel_{$order->store_id}_message", 'new_order', $web_push_link);
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public static function day_part()
    {
        $part = "";
        $morning_start = date("h:i:s", strtotime("5:00:00"));
        $afternoon_start = date("h:i:s", strtotime("12:01:00"));
        $evening_start = date("h:i:s", strtotime("17:01:00"));
        $evening_end = date("h:i:s", strtotime("21:00:00"));

        if (time() >= $morning_start && time() < $afternoon_start) {
            $part = "morning";
        } elseif (time() >= $afternoon_start && time() < $evening_start) {
            $part = "afternoon";
        } elseif (time() >= $evening_start && time() <= $evening_end) {
            $part = "evening";
        } else {
            $part = "night";
        }

        return $part;
    }

    public static function env_update($key, $value)
    {
        $path = base_path('.env');
        if (file_exists($path)) {
            file_put_contents($path, str_replace(
                $key . '=' . env($key),
                $key . '=' . $value,
                file_get_contents($path)
            ));
        }
    }

    public static function env_key_replace($key_from, $key_to, $value)
    {
        $path = base_path('.env');
        if (file_exists($path)) {
            file_put_contents($path, str_replace(
                $key_from . '=' . env($key_from),
                $key_to . '=' . $value,
                file_get_contents($path)
            ));
        }
    }

    public static  function remove_dir($dir)
    {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir . "/" . $object) == "dir") Helpers::remove_dir($dir . "/" . $object);
                    else unlink($dir . "/" . $object);
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }

    public static function get_store_id()
    {
        if (auth('vendor_employee')->check()) {
            return auth('vendor_employee')->user()->store->id;
        }
        return auth('vendor')->user()->stores[0]->id;
    }

    public static function get_vendor_id()
    {
        if (auth('vendor')->check()) {
            return auth('vendor')->id();
        } else if (auth('vendor_employee')->check()) {
            return auth('vendor_employee')->user()->vendor_id;
        }
        return 0;
    }

    public static function get_vendor_data()
    {
        if (auth('vendor')->check()) {
            return auth('vendor')->user();
        } else if (auth('vendor_employee')->check()) {
            return auth('vendor_employee')->user()->vendor;
        }
        return 0;
    }

    public static function get_loggedin_user()
    {
        if (auth('vendor')->check()) {
            return auth('vendor')->user();
        } else if (auth('vendor_employee')->check()) {
            return auth('vendor_employee')->user();
        }
        return 0;
    }

    public static function get_store_data()
    {
        if (auth('vendor_employee')->check()) {
            return auth('vendor_employee')->user()->store;
        }
        return auth('vendor')->user()->stores[0];
    }

    public static function upload(string $dir, string $format, $image = null)
    {
        if ($image != null) {
            $imageName = \Carbon\Carbon::now()->toDateString() . "-" . uniqid() . "." . $format;
            if (!Storage::disk('public')->exists($dir)) {
                Storage::disk('public')->makeDirectory($dir);
            }
            Storage::disk('public')->putFileAs($dir, $image, $imageName);
        } else {
            $imageName = 'def.png';
        }

        return $imageName;
    }

    public static function update(string $dir, $old_image, string $format, $image = null)
    {
        if ($image == null) {
            return $old_image;
        }
        if (Storage::disk('public')->exists($dir . $old_image)) {
            Storage::disk('public')->delete($dir . $old_image);
        }
        $imageName = Helpers::upload($dir, $format, $image);
        return $imageName;
    }

    public static function format_coordiantes($coordinates)
    {
        $data = [];
        foreach ($coordinates as $coord) {
            $data[] = (object)['lat' => $coord->getlat(), 'lng' => $coord->getlng()];
        }
        return $data;
    }

    public static function module_permission_check($mod_name)
    {
        if (!auth('admin')->user()->role) {
            return false;
        }

        if ($mod_name == 'zone' && auth('admin')->user()->zone_id) {
            return false;
        }

        $permission = auth('admin')->user()->role->modules;
        if (isset($permission) && in_array($mod_name, (array)json_decode($permission)) == true) {
            return true;
        }

        if (auth('admin')->user()->role_id == 1) {
            return true;
        }
        return false;
    }

    public static function employee_module_permission_check($mod_name)
    {
        if (auth('vendor')->check()) {
            if ($mod_name == 'reviews') {
                return auth('vendor')->user()->stores[0]->reviews_section;
            } else if ($mod_name == 'deliveryman') {
                return auth('vendor')->user()->stores[0]->self_delivery_system;
            } else if ($mod_name == 'pos') {
                return auth('vendor')->user()->stores[0]->pos_system;
            } else if ($mod_name == 'addon') {
                return config('module.' . auth('vendor')->user()->stores[0]->module->module_type)['add_on'];
            }
            return true;
        } else if (auth('vendor_employee')->check()) {
            $permission = auth('vendor_employee')->user()->role->modules;
            if (isset($permission) && in_array($mod_name, (array)json_decode($permission)) == true) {
                if ($mod_name == 'reviews') {
                    return auth('vendor_employee')->user()->store->reviews_section;
                } else if ($mod_name == 'deliveryman') {
                    return auth('vendor_employee')->user()->store->self_delivery_system;
                } else if ($mod_name == 'pos') {
                    return auth('vendor_employee')->user()->store->pos_system;
                } else if ($mod_name == 'addon') {
                    return config('module.' . auth('vendor_employee')->user()->store->module->module_type)['add_on'];
                }
                return true;
            }
        }

        return false;
    }
    public static function calculate_addon_price($addons, $add_on_qtys)
    {
        $add_ons_cost = 0;
        $data = [];
        if ($addons) {
            foreach ($addons as $key2 => $addon) {
                if ($add_on_qtys == null) {
                    $add_on_qty = 1;
                } else {
                    $add_on_qty = $add_on_qtys[$key2];
                }
                $data[] = ['id' => $addon->id, 'name' => $addon->name, 'price' => $addon->price, 'quantity' => $add_on_qty];
                $add_ons_cost += $addon['price'] * $add_on_qty;
            }
            return ['addons' => $data, 'total_add_on_price' => $add_ons_cost];
        }
        return null;
    }

    public static function get_settings($name)
    {
        $config = null;
        $data = BusinessSetting::where(['key' => $name])->first();
        if (isset($data)) {
            $config = json_decode($data['value'], true);
            if (is_null($config)) {
                $config = $data['value'];
            }
        }
        return $config;
    }

    public static function setEnvironmentValue($envKey, $envValue)
    {
        $envFile = app()->environmentFilePath();
        $str = file_get_contents($envFile);
        $oldValue = env($envKey);
        if (strpos($str, $envKey) !== false) {
            $str = str_replace("{$envKey}={$oldValue}", "{$envKey}={$envValue}", $str);
        } else {
            $str .= "{$envKey}={$envValue}\n";
        }
        $fp = fopen($envFile, 'w');
        fwrite($fp, $str);
        fclose($fp);
        return $envValue;
    }

    public static function requestSender()
    {
        $class = new LaravelchkController();
        $response = $class->actch();
        return json_decode($response->getContent(), true);
    }

    public static function insert_business_settings_key($key, $value = null)
    {
        $data =  BusinessSetting::where('key', $key)->first();
        if (!$data) {
            DB::table('business_settings')->updateOrInsert(['key' => $key], [
                'value' => $value,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return true;
    }

    public static function get_language_name($key)
    {
        $languages = array(
            "af" => "Afrikaans",
            "sq" => "Albanian - shqip",
            "am" => "Amharic - አማርኛ",
            "ar" => "Arabic - العربية",
            "an" => "Aragonese - aragonés",
            "hy" => "Armenian - հայերեն",
            "ast" => "Asturian - asturianu",
            "az" => "Azerbaijani - azərbaycan dili",
            "eu" => "Basque - euskara",
            "be" => "Belarusian - беларуская",
            "bn" => "Bengali - বাংলা",
            "bs" => "Bosnian - bosanski",
            "br" => "Breton - brezhoneg",
            "bg" => "Bulgarian - български",
            "ca" => "Catalan - català",
            "ckb" => "Central Kurdish - کوردی (دەستنوسی عەرەبی)",
            "zh" => "Chinese - 中文",
            "zh-HK" => "Chinese (Hong Kong) - 中文（香港）",
            "zh-CN" => "Chinese (Simplified) - 中文（简体）",
            "zh-TW" => "Chinese (Traditional) - 中文（繁體）",
            "co" => "Corsican",
            "hr" => "Croatian - hrvatski",
            "cs" => "Czech - čeština",
            "da" => "Danish - dansk",
            "nl" => "Dutch - Nederlands",
            "en" => "English",
            "en-AU" => "English (Australia)",
            "en-CA" => "English (Canada)",
            "en-IN" => "English (India)",
            "en-NZ" => "English (New Zealand)",
            "en-ZA" => "English (South Africa)",
            "en-GB" => "English (United Kingdom)",
            "en-US" => "English (United States)",
            "eo" => "Esperanto - esperanto",
            "et" => "Estonian - eesti",
            "fo" => "Faroese - føroyskt",
            "fil" => "Filipino",
            "fi" => "Finnish - suomi",
            "fr" => "French - français",
            "fr-CA" => "French (Canada) - français (Canada)",
            "fr-FR" => "French (France) - français (France)",
            "fr-CH" => "French (Switzerland) - français (Suisse)",
            "gl" => "Galician - galego",
            "ka" => "Georgian - ქართული",
            "de" => "German - Deutsch",
            "de-AT" => "German (Austria) - Deutsch (Österreich)",
            "de-DE" => "German (Germany) - Deutsch (Deutschland)",
            "de-LI" => "German (Liechtenstein) - Deutsch (Liechtenstein)",
            "de-CH" => "German (Switzerland) - Deutsch (Schweiz)",
            "el" => "Greek - Ελληνικά",
            "gn" => "Guarani",
            "gu" => "Gujarati - ગુજરાતી",
            "ha" => "Hausa",
            "haw" => "Hawaiian - ʻŌlelo Hawaiʻi",
            "he" => "Hebrew - עברית",
            "hi" => "Hindi - हिन्दी",
            "hu" => "Hungarian - magyar",
            "is" => "Icelandic - íslenska",
            "id" => "Indonesian - Indonesia",
            "ia" => "Interlingua",
            "ga" => "Irish - Gaeilge",
            "it" => "Italian - italiano",
            "it-IT" => "Italian (Italy) - italiano (Italia)",
            "it-CH" => "Italian (Switzerland) - italiano (Svizzera)",
            "ja" => "Japanese - 日本語",
            "kn" => "Kannada - ಕನ್ನಡ",
            "kk" => "Kazakh - қазақ тілі",
            "km" => "Khmer - ខ្មែរ",
            "ko" => "Korean - 한국어",
            "ku" => "Kurdish - Kurdî",
            "ky" => "Kyrgyz - кыргызча",
            "lo" => "Lao - ລາວ",
            "la" => "Latin",
            "lv" => "Latvian - latviešu",
            "ln" => "Lingala - lingála",
            "lt" => "Lithuanian - lietuvių",
            "mk" => "Macedonian - македонски",
            "ms" => "Malay - Bahasa Melayu",
            "ml" => "Malayalam - മലയാളം",
            "mt" => "Maltese - Malti",
            "mr" => "Marathi - मराठी",
            "mn" => "Mongolian - монгол",
            "ne" => "Nepali - नेपाली",
            "no" => "Norwegian - norsk",
            "nb" => "Norwegian Bokmål - norsk bokmål",
            "nn" => "Norwegian Nynorsk - nynorsk",
            "oc" => "Occitan",
            "or" => "Oriya - ଓଡ଼ିଆ",
            "om" => "Oromo - Oromoo",
            "ps" => "Pashto - پښتو",
            "fa" => "Persian - فارسی",
            "pl" => "Polish - polski",
            "pt" => "Portuguese - português",
            "pt-BR" => "Portuguese (Brazil) - português (Brasil)",
            "pt-PT" => "Portuguese (Portugal) - português (Portugal)",
            "pa" => "Punjabi - ਪੰਜਾਬੀ",
            "qu" => "Quechua",
            "ro" => "Romanian - română",
            "mo" => "Romanian (Moldova) - română (Moldova)",
            "rm" => "Romansh - rumantsch",
            "ru" => "Russian - русский",
            "gd" => "Scottish Gaelic",
            "sr" => "Serbian - српски",
            "sh" => "Serbo-Croatian - Srpskohrvatski",
            "sn" => "Shona - chiShona",
            "sd" => "Sindhi",
            "si" => "Sinhala - සිංහල",
            "sk" => "Slovak - slovenčina",
            "sl" => "Slovenian - slovenščina",
            "so" => "Somali - Soomaali",
            "st" => "Southern Sotho",
            "es" => "Spanish - español",
            "es-AR" => "Spanish (Argentina) - español (Argentina)",
            "es-419" => "Spanish (Latin America) - español (Latinoamérica)",
            "es-MX" => "Spanish (Mexico) - español (México)",
            "es-ES" => "Spanish (Spain) - español (España)",
            "es-US" => "Spanish (United States) - español (Estados Unidos)",
            "su" => "Sundanese",
            "sw" => "Swahili - Kiswahili",
            "sv" => "Swedish - svenska",
            "tg" => "Tajik - тоҷикӣ",
            "ta" => "Tamil - தமிழ்",
            "tt" => "Tatar",
            "te" => "Telugu - తెలుగు",
            "th" => "Thai - ไทย",
            "ti" => "Tigrinya - ትግርኛ",
            "to" => "Tongan - lea fakatonga",
            "tr" => "Turkish - Türkçe",
            "tk" => "Turkmen",
            "tw" => "Twi",
            "uk" => "Ukrainian - українська",
            "ur" => "Urdu - اردو",
            "ug" => "Uyghur",
            "uz" => "Uzbek - o‘zbek",
            "vi" => "Vietnamese - Tiếng Việt",
            "wa" => "Walloon - wa",
            "cy" => "Welsh - Cymraeg",
            "fy" => "Western Frisian",
            "xh" => "Xhosa",
            "yi" => "Yiddish",
            "yo" => "Yoruba - Èdè Yorùbá",
            "zu" => "Zulu - isiZulu",
        );
        return array_key_exists($key, $languages) ? $languages[$key] : $key;
    }

    public static function get_view_keys()
    {
        $keys = BusinessSetting::whereIn('key', ['toggle_veg_non_veg', 'toggle_dm_registration', 'toggle_store_registration'])->get();
        $data = [];
        foreach ($keys as $key) {
            $data[$key->key] = (bool)$key->value;
        }
        return $data;
    }
    public static function default_lang()
    {
        if (strpos(url()->current(), '/api')) {
            $lang = App::getLocale();
        } elseif (strpos(url()->current(), '/admin') && session()->has('local')) {
            $lang = session('local');
        } elseif (strpos(url()->current(), '/store-panel') && session()->has('vendor_local')) {
            $lang = session('vendor_local');
        } elseif (session()->has('landing_local')) {
            $lang = session('landing_local');
        } elseif (session()->has('local')) {
            $lang = session('local');
        } else {
            $data = Helpers::get_business_settings('language');
            $code = 'en';
            $direction = 'ltr';
            foreach ($data as $ln) {
                if (is_array($ln) && array_key_exists('default', $ln) && $ln['default']) {
                    $code = $ln['code'];
                    if (array_key_exists('direction', $ln)) {
                        $direction = $ln['direction'];
                    }
                }
            }
            session()->put('local', $code);
            $lang = $code;
        }
        return $lang;
    }
    //Mail Config Check
    public static function remove_invalid_charcaters($str)
    {
        return str_ireplace(['\'', '"', ',', ';', '<', '>', '?'], ' ', $str);
    }

    //Generate referer code

    // public static function generate_referer_code($user)
    // {
    //     $user_name = explode('@', $user->email)[0];
    //     $user_id = $user->id;
    //     //dd($user_id);
    //     $uid_length = strlen($user->id);
    //     if (strlen($user_name) > 10 - $uid_length) {
    //         $user_name = substr($user_name, 0, 10 - $uid_length);
    //     } else if (strlen($user_name) < 10 - $uid_length) {
    //         $user_id = $user_id * pow(10, ((10 - $uid_length) - strlen($user_name)));
    //     }
    //     return $user_name . $user_id;
    // }

    public static function generate_referer_code() {
        $ref_code = strtoupper(Str::random(10));

        if (self::referer_code_exists($ref_code)) {
            return self::generate_referer_code();
        }

        return $ref_code;
    }

    public static function referer_code_exists($ref_code) {
        return User::where('ref_code', '=', $ref_code)->exists();
    }

    public static function number_format_short( $n ) {
        if ($n < 900) {
            // 0 - 900
            $n = $n;
            $suffix = '';
        } else if ($n < 900000) {
            // 0.9k-850k
            $n = $n / 1000;
            $suffix = 'K';
        } else if ($n < 900000000) {
            // 0.9m-850m
            $n = $n / 1000000;
            $suffix = 'M';
        } else if ($n < 900000000000) {
            // 0.9b-850b
            $n = $n / 1000000000;
            $suffix = 'B';
        } else {
            // 0.9t+
            $n = $n / 1000000000000;
            $suffix = 'T';
        }

        if(!session()->has('currency_symbol_position')){
            $currency_symbol_position = BusinessSetting::where(['key' => 'currency_symbol_position'])->first()->value;
            session()->put('currency_symbol_position',$currency_symbol_position);
        }
        $currency_symbol_position = session()->get('currency_symbol_position');

        return $currency_symbol_position == 'right' ? number_format($n, config('round_up_to_digit')).$suffix . ' ' . self::currency_symbol() : self::currency_symbol() . ' ' . number_format($n, config('round_up_to_digit')).$suffix;
    }
    public static function export_attributes($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item['name'],
            ];
        }
        return $data;
    }

    public static function push_notification_export_data($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.title') => $item['title'],
                 translate('messages.description') => $item['description'],
                 translate('messages.zone') => $item->zone?$item->zone->name: '',
                 translate('messages.status') => $item['status'],
                 translate('messages.tergat') => $item['tergat'],
            ];
        }
        return $data;
    }

    public static function export_categories($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item['name'],
                 translate('messages.module') => $item->module->module_name,
                 translate('messages.status') => $item['status'],
                 translate('messages.priority') => $item['priority'],
            ];
        }
        return $data;
    }

    public static function export_store_withdraw($collection){
        $data = [];
        $status = ['pending','approved','denied'];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.amount') => $item->amount,
                 translate('messages.store') => isset($item->vendor) ? $item->vendor->stores[0]->name : '',
                 translate('messages.request_time') => date('Y-m-d '.config('timeformat'),strtotime($item->created_at)),
                 translate('messages.status') => isset($status[$item->approved])?translate("messages.".$status[$item->approved]):"",
            ];
        }
        return $data;
    }

    public static function export_account_transaction($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.collect_from') => $item->store ? $item->store->name : ($item->deliveryman ? $item->deliveryman->f_name . ' ' . $item->deliveryman->l_name : translate('messages.not_found')),
                 translate('messages.type') => $item->from_type,
                 translate('messages.transaction_date') => $item->transaction_date,
                 translate('messages.created_at') => $item->created_at->format('Y-m-d '.config('timeformat')),
                 translate('messages.amount') => $item->amount,
                 translate('messages.reference') => $item->ref,
                 translate('messages.method') => $item->method,
            ];
        }
        return $data;
    }

    public static function export_delivery_man_transaction($account_transaction, $order_transactions){
        $data = [];
        $sl = 1;
        foreach($account_transaction as $key=>$item){
            if($item->from_type == 'store'){
                $store = Store::where('id', $item->from_id)->first();
                $store_name = $store->name;
            }else{
                $store_name = '';
            }
            $dm = $item->deliveryman ?? '';
            $data[] = [
                '#'=>$sl,
                'Order ID' => '',
                'Created at' => $item->created_at->format('Y-m-d H:i'),
                'Service name' => '',
                'Delivery man name' => $dm ? $dm->f_name . ' ' . $dm->l_name : '',
                'Delivery man type' => $dm ? ($dm->earning == 1 ? 'Freelance' : 'Salary') : '',
                'Client name' => '',
                'Client phone' => '',
                'Delivery charge' => '',
                'Delivery man commission' => '',
                'Postajji commission' => '',
                'Order amount' => '',
                'Store amount with tax' => '',
                'Commission amount from Store' => '',
                'Coupon code' => '',
                'Coupon type' => '',
                'Coupon discount' => '',
                'Coupon amount' => '',
                'Amount due from delivery man' => (float)($item->amount * -1),
                'Transaction date' => $item->transaction_date,
                'Collected amount' => (float)$item->amount,
                'Reference' => $item->ref,
                //'Coupon title' => '',
                'Store name' => $store_name,
                'Order type' => '',
                'Admin Name' => '',
            ];
            $sl += 1;
        }
        foreach($order_transactions as $key=>$item){
            $order = $item->order;
            $client = $order->customer;
            if(isset($order->admin_id)){
                $admin = Admin::where('id', $order->admin_id)->first();
            }
            if(!empty($item->whatsapp_market_id)){
                $store = WhatsAppStore::where('id', $item->whatsapp_market_id)->first();
                $store_name = $store->name ?? '';
            }else{
                $store_name = $order->store->name ?? '';
            }
            $dm = $item->delivery_man ?? '';
            $amountDueFromDeliveryMan = (float)($item->delivery_charge - $item->original_delivery_charge) + (float)$item->commission_amount_from_store - ($order->coupon_info != null ? $order->coupon_discount_amount : 0);
            $data[] = [
                '#'=>$sl++,
                'Order ID' => $item->order_id,
                'Created at' => date("Y-m-d H:i", strtotime($order->created_at)),
                'Service name' => $item->module->module_name,
                'Delivery man name' => $dm ? $dm->f_name . ' ' . $dm->l_name : '',
                'Delivery man type' => $dm ? ($dm->earning == 1 ? 'Freelance' : 'Salary') : '',
                'Client name' => isset($client) ? $client->f_name . $client->l_name : '',
                'Client phone' => isset($client) ? $client->phone : '',
                'Delivery charge' => (float)$item->delivery_charge,
                'Delivery man commission' => (float)$item->original_delivery_charge,
                'Postajji commission' => (float)$item->delivery_charge - (float)$item->original_delivery_charge,
                'Order amount' => $item->module->module_type != 'parcel' ? (float)$item->order_amount : 0,
                'Store amount with tax' => (float)($item->store_amount + $item->tax),
                'Commission amount from Store' => (float)$item->commission_amount_from_store,
                'Coupon code' => $order->coupon_info != null ? $order->coupon_code : '',
                'Coupon type' => $order->coupon_info != null ? json_decode($order->coupon_info)->coupon_type : '',
                'Coupon discount' => $order->coupon_info != null ? (json_decode($order->coupon_info)->discount . ' ' . (json_decode($order->coupon_info)->discount_type == 'percent' ? ' %' : ' S.P')) : '',
                'Coupon amount' => $order->coupon_info != null ? $order->coupon_discount_amount : '',
                'Amount due from delivery man' => $amountDueFromDeliveryMan,// < 0 ? 0 : $amountDueFromDeliveryMan,
                'Transaction date' => '',
                'Collected amount' => '',
                'Reference' => '',
                //'Coupon title' => $order->coupon_info != null ? $order->coupon_discount_title : '',
                'Store name' => $store_name,
                'Order type' => $order->order_type,
                'Admin Name' => isset($admin) ? $admin->f_name . ' ' . $admin->l_name : '',
            ];
        }
        return $data;
    }

    public static function export_store_account_transaction($account_transaction){
        $data = [];
        $sl = 1;
        foreach($account_transaction as $key=>$item){
            $store = DB::table('stores')->where('id', $item->from_id)->first();
            $data[] = [
                '#'=>$sl,
                'Store name' => isset($store) ? $store->name : '',
                'Store phone' => isset($store) ? $store->phone : '',
                'Collected amount' => (float)$item->amount,
                'Method' => $item->method,
                'Reference' => $item->ref,
                'Created at' => $item->created_at->format('Y-m-d'),
            ];
            $sl += 1;
        }
        return $data;
    }

    public static function export_store_orders_transaction($order_transactions){
        $data = [];
        $sl = 1;
        foreach($order_transactions as $key=>$item){
            $storeCommission = 0;
            $order = $item->order;
            $client = $order->customer;
            if(isset($order->store->name)){
                $storeCommission = $item->order_amount - $item->delivery_charge - $item->store_amount;
            }
            $data[] = [
                '#'=>$sl++,
                'Delivery man name' => ($item->delivery_man) ? $item->delivery_man->f_name . ' ' . $item->delivery_man->l_name : '',
                'Client name' => isset($client) ? $client->f_name . $client->l_name : '',
                'Client phone' => isset($client) ? $client->phone : '',
                'Created at' => $item->created_at->format('Y-m-d'),
                'Order ID' => $item->order_id,
                'Delivery charge' => (float)$item->delivery_charge,
                'Delivery man commission' => (float)$item->original_delivery_charge,
                'Postajji commission' => (float)$item->delivery_charge - (float)$item->original_delivery_charge,
                'Store Items Price' => (float)$item->store_amount,
                'Store commission' => (float)$storeCommission,
                'Service name' => $item->module->module_name,
                'Store name' => isset($order->store->name) ? $order->store->name : '',
                'Amount due from delivery man' => (float)($item->delivery_charge - $item->original_delivery_charge) + (float)$storeCommission,
                'Order type' => $order->order_type,
            ];
        }
        return $data;
    }

    public static function export_dm_earning($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                translate('messages.name') => isset($item->delivery_man) ? $item->delivery_man->f_name.' '.$item->delivery_man->l_name : translate('messages.not_found'),
                 translate('messages.received_at') => $item->created_at->format('Y-m-d '.config('timeformat')),
                 translate('messages.amount') => $item->amount,
                 translate('messages.method') => $item->method,
                 translate('messages.reference') => $item->ref,
            ];
        }
        return $data;
    }

    public static function export_items($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $translate = DB::table('translations')->where('translationable_type', 'App\Models\Item')->where('translationable_id', $item['id'])->where('key', 'name')->first();
            $arName = isset($translate->value) ? $translate->value : '';
            $data[] = [
                //'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') . ' (EN)' => $item['name'],
                 translate('messages.name') . ' (AR)' => $arName,
                 translate('messages.category') => isset($item->category->parent) ? $item->category->parent->name : '',
                 translate('messages.sub_category') => isset($item->category) ? $item->category->name : '',
                 translate('messages.price') => $item['price'],
                 translate('messages.store') => isset($item->store) ? $item->store->name : '',
                 translate('messages.available_time_starts') => $item->available_time_starts,
                 translate('messages.available_time_ends') => $item->available_time_ends,
                 //translate('messages.status') => $item['status'],
            ];
        }
        return $data;
    }

    public static function export_store_item($collection): array
    {
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item['name'],
                 'Sub-Category ID' => $item->category_id,
                 'Sub-Category' => $item->category ? $item->category->name : '',
                 translate('messages.price') => $item['price'],
                 translate('messages.store_id') => $item['store_id'],
                 translate('messages.status') => $item['status'],
            ];
        }
        return $data;
    }

    public static function export_stores($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.store_name') => $item['name'],
                 translate('messages.store_phone') => $item['phone'],
                 translate('messages.store_phone_2') => $item['phone_2'],
                 translate('messages.module') => $item->module->module_name,
                 translate('messages.owner_name') => $item->vendor->f_name.' '.$item->vendor->l_name,
                 translate('messages.owner_phone') => $item->vendor->phone,
                 translate('messages.zone') => $item->zone?$item->zone->name:'',
                 translate('messages.featured') => $item['featured'],
                 translate('messages.status') => $item['status'],
            ];
        }
        return $data;
    }

    public static function export_units($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.unit') => $item['unit'],
            ];
        }
        return $data;
    }

    public static function export_customers($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item->f_name.' '.$item->l_name,
                 translate('messages.phone') => $item['phone'],
                 translate('messages.email') => $item['email'],
                 translate('messages.total_order') => $item['order_count'],
                 translate('messages.status') => $item['status'],
                 'Created at' => date('Y-m-d', strtotime($item['created_at'])),
            ];
        }
        return $data;
    }

    public static function export_day_wise_report($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.order_id') => $item['order_id'],
                 translate('messages.store')=>$item->order->store?$item->order->store->name:translate('messages.invalid'),
                 translate('messages.customer_name')=>$item->order->customer?$item->order->customer['f_name'].' '.$item->order->customer['l_name']:translate('messages.invalid').' '.translate('messages.customer').' '.translate('messages.data'),
                 translate('messages.delivery_man')=>$item->order->delivery_man?$item->order->delivery_man['f_name'].' '.$item->order->delivery_man['l_name']:translate('messages.invalid').' '.translate('messages.delivery_man').' '.translate('messages.data'),
                 translate('total_item_amount')=>\App\CentralLogics\Helpers::format_currency($item->order['order_amount'] - $item->order['dm_tips']-$item->order['delivery_charge'] - $item['tax'] + $item->order['coupon_discount_amount'] + $item->order['store_discount_amount']),
                 translate('item_discount')=>\App\CentralLogics\Helpers::format_currency($item->order->details->sum('discount_on_item')),
                 translate('coupon_discount')=>\App\CentralLogics\Helpers::format_currency($item->order['coupon_discount_amount']),
                 translate('discounted_amount')=>\App\CentralLogics\Helpers::format_currency($item->order['coupon_discount_amount'] + $item->order['store_discount_amount']),
                 translate('messages.tax')=>\App\CentralLogics\Helpers::format_currency($item->order['total_tax_amount']),
                 translate('messages.delivery_charge')=>\App\CentralLogics\Helpers::format_currency($item['delivery_charge']),
                 translate('messages.total_order_amount') => \App\CentralLogics\Helpers::format_currency($item['order_amount']),
                 translate('messages.admin_discount') => \App\CentralLogics\Helpers::format_currency($item['admin_expense']),
                 translate('messages.store_discount') => \App\CentralLogics\Helpers::format_currency($item->order['store_discount_amount']),
                 translate('messages.admin_commission') => \App\CentralLogics\Helpers::format_currency(($item->admin_commission + $item->admin_expense) - $item->delivery_fee_comission),
                 translate('Comission on delivery fee') => \App\CentralLogics\Helpers::format_currency($item['delivery_fee_comission']),
                 translate('admin_net_income') => \App\CentralLogics\Helpers::format_currency($item['admin_commission']),
                 translate('store_net_income') => \App\CentralLogics\Helpers::format_currency($item['store_amount'] - $item['tax']),
                 translate('messages.amount_received_by') => $item['received_by'],
                 translate('messages.payment_method')=>translate(str_replace('_', ' ', $item->order['payment_method'])),
                 translate('messages.payment_status') => $item->status ? translate("messages.refunded") : translate("messages.completed"),
            ];
        }
        return $data;
    }


    public static function export_expense_wise_report($collection){
        $data = [];
        foreach($collection as $key=>$item){
            if(isset($item->order->customer)){
                            $customer_name= $item->order->customer->f_name.' '.$item->order->customer->l_name;
                                }
            $data[] = [
                'SL'=>$key+1,
                translate('messages.order_id') => $item['order_id'],
                translate('messages.expense_date') =>  $item['created_at'],
                // translate('messages.expense_date') =>  $item->created_at->format('Y-m-d '.config('timeformat')),
                translate('messages.type') => str::title( str_replace('_', ' ',  $item['type'])),
                translate('messages.customer_name') => $customer_name,
                translate('messages.amount') => $item['amount'],
            ];
        }
        return $data;
    }

    public static function export_item_wise_report($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item['name'],
                 translate('messages.module') =>$item->module ? $item->module->module_name : '',
                 translate('messages.store') => $item->store ? $item->store->name : '',
                 translate('messages.order') => $item->orders_count,
                 translate('messages.price') => \App\CentralLogics\Helpers::format_currency($item->price),
                 translate('messages.total_amount_sold') => \App\CentralLogics\Helpers::format_currency($item->orders_sum_price),
                 translate('messages.total_discount_given') => \App\CentralLogics\Helpers::format_currency($item->orders_sum_discount_on_item),
                 translate('messages.average_sale_value') => $item->orders_count>0? \App\CentralLogics\Helpers::format_currency(($item->orders_sum_price-$item->orders_sum_discount_on_item)/$item->orders_count):0 ,
                 translate('messages.average_ratings') => round($item->avg_rating,1),
            ];
        }
        return $data;
    }

    public static function export_stock_wise_report($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item['name'],
                 translate('messages.store') => $item->store?$item->store->name : '',
                 translate('messages.zone') => ($item->store && $item->store->zone) ? $item->store->zone->name:'',
                 translate('messages.stock') => $item['stock'],
            ];
        }
        return $data;
    }

    public static function export_delivery_men($collection){
        $data = [];
        foreach($collection as $key=>$item){

            $theRemainingBalance = DeliveryMan::getTheRemainingBalanceForDeliveryMan($item, '', '');
            $data[] = [
                'SL'=>$key+1,
                 translate('messages.id') => $item['id'],
                 translate('messages.name') => $item->f_name.' '.$item->l_name,
                 translate('messages.phone') => $item['phone'],
                 translate('messages.zone') => $item->zone?$item->zone->name:'',
                 translate('messages.total_order') => $item['order_count'],
                 translate('messages.currently_assigned_orders') => (int) $item['current_orders'],
                 translate('messages.status') => $item['status'],
                 translate('messages.approved_at') => date('Y-m-d', strtotime($item['approved_at'])),
                 'The remaining balance' => round($theRemainingBalance),
                 'Status' => $item->status == 1 ? 'Active' : 'Disabled',
                'رقم البوكس التي يملكها' => $item['box_number'],
                'تاريخ استلام البوكس' => $item['box_received_at'],
            ];
        }
        return $data;
    }

    public static function exportGeneralStores($collection){
        $data = [];
        foreach($collection as $key=>$item){
            $data[] = [
                'SL'=>$key+1,
                translate('messages.id') => $item['id'],
                translate('messages.name') => $item->name,
                translate('messages.title') => $item->title,
                translate('messages.zone') => $item->zone ? $item->zone->name : '',
                translate('messages.module') => $item->module ? $item->module->module_name : '',
                translate('messages.category') => $item->category ? $item->category->en_name : '',
                translate('messages.created_at') => !empty($item->created_at) ? date('Y-m-d', strtotime($item->created_at)) : '',
                translate('messages.is_approved') => $item->is_approved,
            ];
        }
        return $data;
    }

    public static function hex_to_rbg($color){
        list($r, $g, $b) = sscanf($color, "#%02x%02x%02x");
        $output = "$r, $g, $b";
        return $output;
    }

    public static function expenseCreate($amount,$type,$datetime,$order_id,$created_by,$store_id=null,$description='',$delivery_man_id=null)
    {
        $expense = new Expense();
        $expense->amount = $amount;
        $expense->type = $type;
        $expense->order_id = $order_id;
        $expense->created_by = $created_by;
        $expense->store_id = $store_id;
        $expense->delivery_man_id = $delivery_man_id;
        $expense->description = $description;
        $expense->created_at = now();
        $expense->updated_at = now();
        return $expense->save();
    }

    public static function get_varient(array $product_variations, array $variations)
    {
        $result = [];
        $variation_price = 0;

        foreach($variations as $k=> $variation){
            foreach($product_variations as  $product_variation){
                if( isset($variation['values']) && isset($product_variation['values']) && $product_variation['name'] == $variation['name']  ){
                    $result[$k] = $product_variation;
                    $result[$k]['values'] = [];
                    foreach($product_variation['values'] as $key=> $option){
                        if(in_array($option['label'], $variation['values']['label'])){
                            $result[$k]['values'][] = $option;
                            $variation_price += $option['optionPrice'];
                        }
                    }
                }
            }
        }

        return ['price'=>$variation_price,'variations'=>$result];
    }

    public static function food_variation_price($product, $variations)
    {
        // $match = json_decode($variations, true)[0];
        $match = $variations;
        $result = 0;
        // foreach (json_decode($product['variations'], true) as $property => $value) {
        //     if ($value['type'] == $match['type']) {
        //         $result = $value['price'];
        //     }
        // }
            foreach($product as $product_variation){
                foreach($product_variation['values'] as $option){
                    foreach($match as $variation){
                        if($product_variation['name'] == $variation['name'] && isset($variation['values']) && in_array($option['label'], $variation['values']['label'])){
                            $result += $option['optionPrice'];
                        }
                    }
                }
            }

        return $result;
    }

    public static function gen_mpdf($view, $file_prefix, $file_postfix)
    {
        $mpdf = new \Mpdf\Mpdf(['tempDir' => __DIR__ . '/../../storage/tmp','default_font' => 'FreeSerif', 'mode' => 'utf-8', 'format' => [190, 250]]);
        /* $mpdf->AddPage('XL', '', '', '', '', 10, 10, 10, '10', '270', '');*/
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;

        $mpdf_view = $view;
        $mpdf_view = $mpdf_view->render();
        $mpdf->WriteHTML($mpdf_view);
        $mpdf->Output($file_prefix . $file_postfix . '.pdf', 'D');
    }

    public static function auto_translator($q, $sl, $tl)
    {
        $res = file_get_contents("https://translate.googleapis.com/translate_a/single?client=gtx&ie=UTF-8&oe=UTF-8&dt=bd&dt=ex&dt=ld&dt=md&dt=qca&dt=rw&dt=rm&dt=ss&dt=t&dt=at&sl=" . $sl . "&tl=" . $tl . "&hl=hl&q=" . urlencode($q), $_SERVER['DOCUMENT_ROOT'] . "/transes.html");
        $res = json_decode($res);
        return str_replace('_',' ',$res[0][0][0]);
    }

    public static function getLanguageCode(string $country_code): string
    {
        $locales = array(
            'en-English(default)',
            'af-Afrikaans',
            'sq-Albanian - shqip',
            'am-Amharic - አማርኛ',
            'ar-Arabic - العربية',
            'an-Aragonese - aragonés',
            'hy-Armenian - հայերեն',
            'ast-Asturian - asturianu',
            'az-Azerbaijani - azərbaycan dili',
            'eu-Basque - euskara',
            'be-Belarusian - беларуская',
            'bn-Bengali - বাংলা',
            'bs-Bosnian - bosanski',
            'br-Breton - brezhoneg',
            'bg-Bulgarian - български',
            'ca-Catalan - català',
            'ckb-Central Kurdish - کوردی (دەستنوسی عەرەبی)',
            'zh-Chinese - 中文',
            'zh-HK-Chinese (Hong Kong) - 中文（香港）',
            'zh-CN-Chinese (Simplified) - 中文（简体）',
            'zh-TW-Chinese (Traditional) - 中文（繁體）',
            'co-Corsican',
            'hr-Croatian - hrvatski',
            'cs-Czech - čeština',
            'da-Danish - dansk',
            'nl-Dutch - Nederlands',
            'en-AU-English (Australia)',
            'en-CA-English (Canada)',
            'en-IN-English (India)',
            'en-NZ-English (New Zealand)',
            'en-ZA-English (South Africa)',
            'en-GB-English (United Kingdom)',
            'en-US-English (United States)',
            'eo-Esperanto - esperanto',
            'et-Estonian - eesti',
            'fo-Faroese - føroyskt',
            'fil-Filipino',
            'fi-Finnish - suomi',
            'fr-French - français',
            'fr-CA-French (Canada) - français (Canada)',
            'fr-FR-French (France) - français (France)',
            'fr-CH-French (Switzerland) - français (Suisse)',
            'gl-Galician - galego',
            'ka-Georgian - ქართული',
            'de-German - Deutsch',
            'de-AT-German (Austria) - Deutsch (Österreich)',
            'de-DE-German (Germany) - Deutsch (Deutschland)',
            'de-LI-German (Liechtenstein) - Deutsch (Liechtenstein)
            ',
            'de-CH-German (Switzerland) - Deutsch (Schweiz)',
            'el-Greek - Ελληνικά',
            'gn-Guarani',
            'gu-Gujarati - ગુજરાતી',
            'ha-Hausa',
            'haw-Hawaiian - ʻŌlelo Hawaiʻi',
            'he-Hebrew - עברית',
            'hi-Hindi - हिन्दी',
            'hu-Hungarian - magyar',
            'is-Icelandic - íslenska',
            'id-Indonesian - Indonesia',
            'ia-Interlingua',
            'ga-Irish - Gaeilge',
            'it-Italian - italiano',
            'it-IT-Italian (Italy) - italiano (Italia)',
            'it-CH-Italian (Switzerland) - italiano (Svizzera)',
            'ja-Japanese - 日本語',
            'kn-Kannada - ಕನ್ನಡ',
            'kk-Kazakh - қазақ тілі',
            'km-Khmer - ខ្មែរ',
            'ko-Korean - 한국어',
            'ku-Kurdish - Kurdî',
            'ky-Kyrgyz - кыргызча',
            'lo-Lao - ລາວ',
            'la-Latin',
            'lv-Latvian - latviešu',
            'ln-Lingala - lingála',
            'lt-Lithuanian - lietuvių',
            'mk-Macedonian - македонски',
            'ms-Malay - Bahasa Melayu',
            'ml-Malayalam - മലയാളം',
            'mt-Maltese - Malti',
            'mr-Marathi - मराठी',
            'mn-Mongolian - монгол',
            'ne-Nepali - नेपाली',
            'no-Norwegian - norsk',
            'nb-Norwegian Bokmål - norsk bokmål',
            'nn-Norwegian Nynorsk - nynorsk',
            'oc-Occitan',
            'or-Oriya - ଓଡ଼ିଆ',
            'om-Oromo - Oromoo',
            'ps-Pashto - پښتو',
            'fa-Persian - فارسی',
            'pl-Polish - polski',
            'pt-Portuguese - português',
            'pt-BR-Portuguese (Brazil) - português (Brasil)',
            'pt-PT-Portuguese (Portugal) - português (Portugal)',
            'pa-Punjabi - ਪੰਜਾਬੀ',
            'qu-Quechua',
            'ro-Romanian - română',
            'mo-Romanian (Moldova) - română (Moldova)',
            'rm-Romansh - rumantsch',
            'ru-Russian - русский',
            'gd-Scottish Gaelic',
            'sr-Serbian - српски',
            'sh-Serbo-Croatian - Srpskohrvatski',
            'sn-Shona - chiShona',
            'sd-Sindhi',
            'si-Sinhala - සිංහල',
            'sk-Slovak - slovenčina',
            'sl-Slovenian - slovenščina',
            'so-Somali - Soomaali',
            'st-Southern Sotho',
            'es-Spanish - español',
            'es-AR-Spanish (Argentina) - español (Argentina)',
            'es-419-Spanish (Latin America) - español (Latinoamérica)
            ',
            'es-MX-Spanish (Mexico) - español (México)',
            'es-ES-Spanish (Spain) - español (España)',
            'es-US-Spanish (United States) - español (Estados Unidos)
            ',
            'su-Sundanese',
            'sw-Swahili - Kiswahili',
            'sv-Swedish - svenska',
            'tg-Tajik - тоҷикӣ',
            'ta-Tamil - தமிழ்',
            'tt-Tatar',
            'te-Telugu - తెలుగు',
            'th-Thai - ไทย',
            'ti-Tigrinya - ትግርኛ',
            'to-Tongan - lea fakatonga',
            'tr-Turkish - Türkçe',
            'tk-Turkmen',
            'tw-Twi',
            'uk-Ukrainian - українська',
            'ur-Urdu - اردو',
            'ug-Uyghur',
            'uz-Uzbek - o‘zbek',
            'vi-Vietnamese - Tiếng Việt',
            'wa-Walloon - wa',
            'cy-Welsh - Cymraeg',
            'fy-Western Frisian',
            'xh-Xhosa',
            'yi-Yiddish',
            'yo-Yoruba - Èdè Yorùbá',
            'zu-Zulu - isiZulu',
        );

        foreach ($locales as $locale) {
            $locale_region = explode('-',$locale);
            if ($country_code == $locale_region[0]) {
                return $locale_region[0];
            }
        }

        return "en";
    }
    // function getLanguageCode(string $country_code): string
    // {
    //     $locales = array('af-ZA',
    //         'am-ET',
    //         'ar-AE',
    //         'ar-BH',
    //         'ar-DZ',
    //         'ar-EG',
    //         'ar-IQ',
    //         'ar-JO',
    //         'ar-KW',
    //         'ar-LB',
    //         'ar-LY',
    //         'ar-MA',
    //         'ar-OM',
    //         'ar-QA',
    //         'ar-SA',
    //         'ar-SY',
    //         'ar-TN',
    //         'ar-YE',
    //         'az-Cyrl-AZ',
    //         'az-Latn-AZ',
    //         'be-BY',
    //         'bg-BG',
    //         'bn-BD',
    //         'bs-Cyrl-BA',
    //         'bs-Latn-BA',
    //         'cs-CZ',
    //         'da-DK',
    //         'de-AT',
    //         'de-CH',
    //         'de-DE',
    //         'de-LI',
    //         'de-LU',
    //         'dv-MV',
    //         'el-GR',
    //         'en-AU',
    //         'en-BZ',
    //         'en-CA',
    //         'en-GB',
    //         'en-IE',
    //         'en-JM',
    //         'en-MY',
    //         'en-NZ',
    //         'en-SG',
    //         'en-TT',
    //         'en-US',
    //         'en-ZA',
    //         'en-ZW',
    //         'es-AR',
    //         'es-BO',
    //         'es-CL',
    //         'es-CO',
    //         'es-CR',
    //         'es-DO',
    //         'es-EC',
    //         'es-ES',
    //         'es-GT',
    //         'es-HN',
    //         'es-MX',
    //         'es-NI',
    //         'es-PA',
    //         'es-PE',
    //         'es-PR',
    //         'es-PY',
    //         'es-SV',
    //         'es-US',
    //         'es-UY',
    //         'es-VE',
    //         'et-EE',
    //         'fa-IR',
    //         'fi-FI',
    //         'fil-PH',
    //         'fo-FO',
    //         'fr-BE',
    //         'fr-CA',
    //         'fr-CH',
    //         'fr-FR',
    //         'fr-LU',
    //         'fr-MC',
    //         'he-IL',
    //         'hi-IN',
    //         'hr-BA',
    //         'hr-HR',
    //         'hu-HU',
    //         'hy-AM',
    //         'id-ID',
    //         'ig-NG',
    //         'is-IS',
    //         'it-CH',
    //         'it-IT',
    //         'ja-JP',
    //         'ka-GE',
    //         'kk-KZ',
    //         'kl-GL',
    //         'km-KH',
    //         'ko-KR',
    //         'ky-KG',
    //         'lb-LU',
    //         'lo-LA',
    //         'lt-LT',
    //         'lv-LV',
    //         'mi-NZ',
    //         'mk-MK',
    //         'mn-MN',
    //         'ms-BN',
    //         'ms-MY',
    //         'mt-MT',
    //         'nb-NO',
    //         'ne-NP',
    //         'nl-BE',
    //         'nl-NL',
    //         'pl-PL',
    //         'prs-AF',
    //         'ps-AF',
    //         'pt-BR',
    //         'pt-PT',
    //         'ro-RO',
    //         'ru-RU',
    //         'rw-RW',
    //         'sv-SE',
    //         'si-LK',
    //         'sk-SK',
    //         'sl-SI',
    //         'sq-AL',
    //         'sr-Cyrl-BA',
    //         'sr-Cyrl-CS',
    //         'sr-Cyrl-ME',
    //         'sr-Cyrl-RS',
    //         'sr-Latn-BA',
    //         'sr-Latn-CS',
    //         'sr-Latn-ME',
    //         'sr-Latn-RS',
    //         'sw-KE',
    //         'tg-Cyrl-TJ',
    //         'th-TH',
    //         'tk-TM',
    //         'tr-TR',
    //         'uk-UA',
    //         'ur-PK',
    //         'uz-Cyrl-UZ',
    //         'uz-Latn-UZ',
    //         'vi-VN',
    //         'wo-SN',
    //         'yo-NG',
    //         'zh-CN',
    //         'zh-HK',
    //         'zh-MO',
    //         'zh-SG',
    //         'zh-TW');

    //     foreach ($locales as $locale) {
    //         $locale_region = explode('-',$locale);
    //         if (strtoupper($country_code) == $locale_region[1]) {
    //             return $locale_region[0];
    //         }
    //     }

    //     return "en";
    // }

    public static function pagination_limit()
    {
        $pagination_limit = BusinessSetting::where('key', 'pagination_limit')->first();
        if ($pagination_limit != null) {
            return $pagination_limit->value;
        } else {
            return 25;
        }
    }

    public static function language_load()
    {
        if (\session()->has('language_settings')) {
            $language = \session('language_settings');
        } else {
            $language = BusinessSetting::where('key', 'system_language')->first();
            \session()->put('language_settings', $language);
        }
        return $language;
    }

    public static function vendor_language_load()
    {
        if (\session()->has('vendor_language_settings')) {
            $language = \session('vendor_language_settings');
        } else {
            $language = BusinessSetting::where('key', 'system_language')->first();
            \session()->put('vendor_language_settings', $language);
        }
        return $language;
    }

    public static function landing_language_load()
    {
        if (\session()->has('landing_language_settings')) {
            $language = \session('landing_language_settings');
        } else {
            $language = BusinessSetting::where('key', 'system_language')->first();
            \session()->put('landing_language_settings', $language);
        }
        return $language;
    }


    public static function product_tax($price , $tax, $is_include=false){
        //$price_tax = ($price * $tax) / (100 + ($is_include?$tax:0)) ;
        $price_tax = ($price * $tax) / 100 ;
        return $price_tax;
    }

    public static function apple_client_secret(){
        // Set up the necessary variables
        $keyId = 'U7KA7F82UM';
        $teamId = '7WSYLQ8Y87';
        $clientId = 'com.sixamtech.sixamMartApp';
        $privateKey = file_get_contents('AuthKey_U7KA7F82UM.p8'); // Should be a string containing the contents of the private key file.

        // Create the JWT header
        $header = [
            'alg' => 'ES256',
            'kid' => $keyId,
        ];

        // Create the JWT payload
        $payload = [
            'iss' => $teamId,
            'iat' => time(),
            'exp' => time() + 86400 * 180, // 180 days in seconds
            'aud' => 'https://appleid.apple.com',
            'sub' => $clientId,
        ];

        // Encode the JWT header and payload
        $base64Header = base64_encode(json_encode($header));
        $base64Payload = base64_encode(json_encode($payload));

        // Create the signature using the private key and the SHA-256 algorithm
        $dataToSign = $base64Header . '.' . $base64Payload;
        $signature = '';
        openssl_sign($dataToSign, $signature, $privateKey, 'sha256');

        // Encode the signature
        $base64Signature = base64_encode($signature);

        // Create the Apple Client Secret key
        $clientSecret = $base64Header . '.' . $base64Payload . '.' . $base64Signature;

        // Output the key
        return $clientSecret;
    }

    public static function error_formater($key, $mesage, $errors = [])
    {
        $errors[] = ['code' => $key, 'message' => $mesage];

        return $errors;
    }

    public static function react_activation_check($react_domain, $react_license_code){
        $scheme = str_contains($react_domain, 'localhost')?'http://':'https://';
        $url = empty(parse_url($react_domain)['scheme']) ? $scheme . ltrim($react_domain, '/') : $react_domain;
        $response = Http::post('https://store.6amtech.com/api/v1/customer/license-check', [
            'domain_name' => str_ireplace('www.', '', parse_url($url, PHP_URL_HOST)),
            'license_code' => $react_license_code
        ]);
        return ($response->successful() && isset($response->json('content')['is_active']) && $response->json('content')['is_active']);
    }

    public static function activation_submit($purchase_key)
    {
        $post = [
            'purchase_key' => $purchase_key
        ];
        $live = 'https://check.6amtech.com';
        $ch = curl_init($live . '/api/v1/software-check');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        $response = curl_exec($ch);

        curl_close($ch);
        $response_body = json_decode($response, true);

        try {
            if ($response_body['is_valid'] && $response_body['result']['item']['id'] == env('REACT_APP_KEY')) {
                $previous_active = json_decode(BusinessSetting::where('key', 'app_activation')->first()->value ?? '[]');
                $found = 0;
                foreach ($previous_active as $key => $item) {
                    if ($item->software_id == env('REACT_APP_KEY')) {
                        $found = 1;
                    }
                }
                if (!$found) {
                    $previous_active[] = [
                        'software_id' => env('REACT_APP_KEY'),
                        'is_active' => 1
                    ];
                    DB::table('business_settings')->updateOrInsert(['key' => 'app_activation'], [
                        'value' => json_encode($previous_active)
                    ]);
                }
                return true;
            }

        } catch (\Exception $exception) {
            info($exception->getMessage());

            $previous_active[] = [
                'software_id' => env('REACT_APP_KEY'),
                'is_active' => 1
            ];
            DB::table('business_settings')->updateOrInsert(['key' => 'app_activation'], [
                'value' => json_encode($previous_active)
            ]);

            return true;
        }
        return false;
    }

    public static function react_domain_status_check(){
        $data = self::get_business_settings('react_setup');
        if($data && isset($data['react_domain']) && isset($data['react_license_code'])){
            if(isset($data['react_platform']) && $data['react_platform'] == 'codecanyon'){
                $data['status'] = (int)self::activation_submit($data['react_license_code']);
            }elseif(!self::react_activation_check($data['react_domain'], $data['react_license_code'])){
                $data['status']=0;
            }elseif($data['status'] != 1){
                $data['status']=1;
            }
            DB::table('business_settings')->updateOrInsert(['key' => 'react_setup'], [
                'value' => json_encode($data)
            ]);
        }
    }

    public static function cancelOrdersAfterCertainTime()
    {
        $minutes = 40;
        $orders = Order::where('order_status', 'pending')->where('created_at', '<', Carbon::now()->subMinute($minutes))->get();
        foreach ($orders as $order){
            if (config('module.' . $order->module->module_type)['stock']) {
                foreach ($order->details as $detail) {
                    $variant = json_decode($detail['variation'], true);
                    $item = $detail->item;
                    if ($detail->campaign) {
                        $item = $detail->campaign;
                    }
                    ProductLogic::update_stock($item, -$detail->quantity, count($variant) ? $variant[0]['type'] : null)->save();
                }
            }
            if ($order->delivery_man) {
                $dm = $order->delivery_man;
                $dm->current_orders = $dm->current_orders > 1 ? $dm->current_orders - 1 : 0;
                $dm->save();
            }
            OrderLogic::refund_before_delivered($order);
            $order->order_status = 'canceled';
            $order->canceled = now();
            $order->canceled_by = 'system';
            $order->cancellation_reason = 'تم إلغاء الطلب من السيستم بعد مرور 40 دقيقة ولم يستلمه أحد من البوسطجيين.';
            $order->save();

            $orderInfo = Order::where('id', $order->id)->first();
            Helpers::sendNotificationToAPISubscriptionServer($orderInfo);
        }
    }

    public static function checkPermission($role, $adminRoles)
    {
        // For master admin
        if (auth('admin')->user()->role_id == 1) {
            return true;
        }

        // For other employees [For more than one role] (Return true if admin has at-list one role)
        if(is_array($role)) {
            foreach ($role as $item){
                if(in_array($item, $adminRoles)) return true;
            }
        }else{
            // For other employees [For one role]
            if(in_array($role, $adminRoles)){
                return true;
            }
        }

        return false;
    }

    public static function getDMLogMessage($type)
    {
        if($type == 'add_bonus'){
            //return 'تم اضافة مبلغ إلى رصيدك بسبب تحقيق الحافز لفترة من ******';
            return 'شيّك رصيدك يا كبير.. مبروك تحقيقك الحافز';
        }else if($type == 'customer_used_coupon'){
            //return 'تم تعويض المندوب بقيمة الكوبون للطلب رقم: ****** بسبب استخدام الزبون لكوبون.';
            return 'عوضنا الوحش الاصفر بقيمة الكوبون لان الزبون استخدمو';
        }else if($type == 'delivery_charge_amount_for_company'){
            //return 'نسبة الشركة من اجور التوصيل للطلب رقم: ******';
            return 'حصة بوسطجي من حق التوصيل للطلب';
        }else if($type == 'commission_amount_from_store'){
            //return 'نسبة الشركة من المطعم للطلب رقم: ******';
            return 'حصة بوسطجي من المطعم للطلب رقم: ******';
        }else if($type == 'compensate_dm_for_distance'){
            //return 'تم تعويض المندوب عن المسافة بينه وبين مكان استلام الطلب رقم: ******';
            return 'عوضنالك المسافة يلي قطعتا زيادة بقرشين حلوين';
        }else if($type == 'boost_for_order'){
            //return 'تم اضافة مبلغ للمندوب بسبب استخدامه دعم للطلب رقم: ******';
            return 'هدول المصاري لأنك كبست على زر القوة';
        }
    }

    public static function createRandomCode(): string
    {
        $chars = "abcdefghijkmnopqrstuvwxyz023456789";
        srand((double)microtime()*1000000);
        $i = 0;
        $code = '' ;
        while ($i <= 7) {
            $num = rand() % 33;
            $tmp = substr($chars, $num, 1);
            $code = $code . $tmp;
            $i++;
        }
        return $code;
    }

    public static function createCouponAfterRegister($user)
    {
        try {
            $start_date = date('Y-m-d');
            $expire_date = Carbon::now()->addDays(30)->format('Y-m-d');

            $coupon_code = Helpers::createRandomCode();
            DB::table('coupons')->insert([
                'title' => 'تسجيل الزبون: ' . $user->name,
                'code' => $coupon_code,
                'limit' => 1,
                'coupon_type' => 'default',
                'start_date' => $start_date,
                'expire_date' => $expire_date,
                'min_purchase' => 0,
                'max_discount' => 0,
                'discount' => 50,
                'discount_type' => 'percent',
                'status' => 1,
                'image' => '',
                'created_by' => 'admin',
                'data' => json_encode(''),
                'store_id' => null,
                'customer_id' => json_encode(['all']),
                'module_id' => 3,
                'view_in_coupons_list' => 0,
                'items_discount_on' => 'admin',
                'delivery_discount_on' => 'admin',
                'created_at' => now(),
                'updated_at' => now()
            ]);
            $newLine = '
';
$message = 'اهلا وسهلا' . $newLine .'
لأنك معنا، صار فيك تستمتع بخصم 50% على أول توصيل' . $newLine .'
ضيف كوبون (' . $coupon_code .') وخلي أول طلبية أوفر وأسهل';

            SMS_module::sendMTNSMSCompanyMessage($user->phone, $message);
        }catch (\Exception $exception){
            Log::error($exception->getMessage());
        }

    }

    public static function sendDeliveryChargeToCompaniesSystem($orderId)
    {
        $orderInfo = Order::where('id', $orderId)->first();
        if(!$orderInfo){
            return;
        }

        $deliveryMan = DeliveryMan::where('id', $orderInfo->delivery_man_id)->first();
        if(!$deliveryMan){
            return;
        }
        $orderTransaction = OrderTransaction::where('order_id', $orderId)->first();
        if(!$orderTransaction){
            return;
        }

        if($deliveryMan->earning != 0){
            return;
        }

        if($orderInfo->order_status != 'delivered'){
            return;
        }

        $body = [
            'orderInfo' => json_encode($orderInfo),
            'deliveryManInfo' => json_encode($deliveryMan),
            'totalDeliveryCharge' => $orderInfo->delivery_charge,
            'deliveryManCommission' => $orderTransaction->original_delivery_charge,
            'adminCommission' => $orderTransaction->admin_commission,
            'commissionFromStore' => $orderTransaction->commission_amount_from_store,
            'couponDiscountAmount' => $orderInfo->coupon_discount_amount,
            'discountAmountCouponOnDeliveryCharge' => $orderTransaction->discount_amount_coupon_on_delivery_charge,
            'discountAmountCouponOnItems' => $orderTransaction->discount_amount_coupon_on_items,
            'couponInfo' => $orderInfo->coupon_info,
        ];

        $response = Http::withOptions([
            'verify' => false,
        ])->post('https://postajji.net/b2b/api/app-orders/store', $body);

    }

    public static function updateAppConfigCache(): void {
        $settings = BusinessSetting::whereIn('key', BusinessSetting::AppConfigKeys)->get()->toArray();
        $data = array_column($settings, 'value', 'key');

        Cache::put('app_configuration', $data, now()->addDays(7));
    }
}
