<?php

namespace App\CentralLogics;

use App\Models\Order;
use App\Models\Store;
use Carbon\Carbon;

class CouponLogic
{
    public static function get_discount($coupon, $order_amount)
    {
        if($coupon->discount_type=='percent' && $coupon->discount > 0)
        {
            $discountAmount = $order_amount* ($coupon->discount/100);
        }else{
            $discountAmount = $coupon->discount;
        }
        if($coupon->max_discount > 0)
        {
            $discountAmount = min($discountAmount, $coupon->max_discount);
        }
        if($discountAmount > $order_amount){
            $discountAmount = $order_amount;
        }
        return $discountAmount;
    }

    public static function is_valide($coupon, $user_id, $store_id, $module_id = null): int
    {

        $start_date = Carbon::parse($coupon->start_date);
        $expire_date = Carbon::parse($coupon->expire_date);
        $customer_ids=json_decode($coupon->customer_id, true);

        $today = Carbon::now();

        $module_id = $module_id ?? config('module.current_module_data')['id'];

        $moduleIds = json_decode($coupon->module_ids);
        if((isset($module_id) && $coupon->module_id != $module_id) and (is_array($moduleIds) and !in_array($module_id, $moduleIds) and !in_array('all', $moduleIds)))
        {
            return 404;
        }

        if($start_date->format('Y-m-d') > $today->format('Y-m-d') || $expire_date->format('Y-m-d') < $today->format('Y-m-d'))
        {
            return 407;  //coupon expire
        }

        $storeIds = json_decode($coupon->store_ids);

        if($store_id != '0' && ($store_id != $coupon->store_id and (is_array($storeIds) and !in_array($store_id, $storeIds) and !in_array('all', $storeIds))))
        {
            return 404;
        }

        if($coupon->one_user_coupon == '1' && ($coupon->used_from_customer_id != null and $coupon->used_from_customer_id != $user_id))
        {
            return 405; //Coupon used from another user
        }

        if($coupon->created_by == 'vendor' && ($store_id != $coupon->store_id and (is_array($storeIds) and !in_array($store_id, $storeIds) and !in_array('all', $storeIds))) ){
            return 404;
        }

        if((!in_array("all", $customer_ids) && !in_array($user_id,$customer_ids)) ){
            return 408; //unauthorized user
        }

        else if($coupon->coupon_type == 'zone_wise')
        {
            if(json_decode($coupon->data, true)){
                $data = Store::whereIn('zone_id',json_decode($coupon->data, true))->where('id', $store_id)->first();
                if(!$data)
                {
                    return 404;
                }
            }
            else
            {
                return 404;
            }
        }
        else if($coupon->coupon_type == 'first_order')
        {
            $total = Order::where(['user_id' => $user_id])->count();
            if ($total < $coupon['limit']) {
                return 200;
            }else{
                return 406;//Limit order
            }
        }
        if ($coupon['limit'] == null) {
            return 200;
        } else {
            $total = Order::where(['user_id' => $user_id, 'coupon_code' => $coupon['code']])->count();
            if ($total < $coupon['limit']) {
                return 200;
            }else{
                return 406;//Limit order
            }
        }
    }

    public static function getValidationMessage($statusCode): array
    {
        $result = [
            'isValid' => false,
            'message' => '',
        ];
        if($statusCode == 407){
            $result['message'] = translate('messages.coupon_expire');
        }else if($statusCode == 408){
            $result['message'] = translate('messages.You_are_not_eligible_for_this_coupon');
        }else if($statusCode == 406){
            $result['message'] = translate('messages.coupon_usage_limit_over');
        }else if($statusCode == 404){
            $result['message'] = translate('messages.not_found');
        }else if($statusCode == 405){
            $result['message'] = translate('messages.coupon_used_from_another_user');
        }else{
            $result['isValid'] = true;
        }

        return $result;
    }
}
