<?php

namespace App\CentralLogics;

use App\Models\MainBanner;
use App\Models\Item;
use App\Models\Store;
use App\CentralLogics\Helpers;

class MainBannerLogic
{
    public static function get_banners($zone_id, $featured = false)
    {
        $banners = MainBanner::where(['status'=> 1])
            ->when($featured, function ($query) {
                $query->where(['featured'=> 1]);
            });
            $banners = $banners->whereIn('zone_id', json_decode($zone_id, true))
                ->orderBy('title', 'ASC')
                ->get();

        $data = [];
        foreach($banners as $banner)
        {
            if($banner->type=='store_wise')
            {
                $store = Store::where(['status'=>1])
                    ->find($banner->data);
                $data[]=[
                    'id'=>$banner->id,
                    'title'=>$banner->title,
                    'type'=>$banner->type,
                    'image'=>$banner->image,
                    'en_image'=>$banner->en_image,
                    'link'=> null,
                    'store' => $store ? Helpers::store_data_formatting($store, false) : null,
                    'item'=>null
                ];
            }
            if($banner->type=='item_wise')
            {
                $item = Item::where(['status'=>1])
                    ->find($banner->data);
                $data[]=[
                    'id'=>$banner->id,
                    'title'=>$banner->title,
                    'type'=>$banner->type,
                    'image'=>$banner->image,
                    'en_image'=>$banner->en_image,
                    'link'=> null,
                    'store'=> null,
                    'item'=> $item?Helpers::product_data_formatting($item, false, false, app()->getLocale()):null,
                ];
            }
            if($banner->type=='default')
            {
                $data[]=[
                    'id'=>$banner->id,
                    'title'=>$banner->title,
                    'type'=>$banner->type,
                    'image'=>$banner->image,
                    'en_image'=>$banner->en_image,
                    'link'=>$banner->default_link,
                    'store'=> null,
                    'item'=> null,
                ];
            }
            if($banner->type == null)
            {
                $data[]=[
                    'id'=>$banner->id,
                    'title'=>$banner->title,
                    'type'=>$banner->type,
                    'image'=>$banner->image,
                    'en_image'=>$banner->en_image,
                    'link'=> null,
                    'store'=> null,
                    'item'=> null,
                ];
            }
        }
        return $data;
    }
}
